/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.ApplicationClassificationConfigResourceDefinition;
import org.jboss.as.domain.management.access.ApplicationClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionPropertyResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractPlugInAuthResourceDefinition;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.BaseLdapUserSearchResource;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ManagementXml {
    private final Delegate delegate;

    public ManagementXml(Delegate delegate) {
        this.delegate = delegate;
    }

    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: {
                this.parseManagement_1_0(reader, address, expectedNs, list, requireNativeInterface);
                break;
            }
            default: {
                this.parseManagement_1_5(reader, address, expectedNs, list, requireNativeInterface);
            }
        }
    }

    private void parseManagement_1_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseSecurityRealms(reader, managementAddress, expectedNs, list);
                    continue block5;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseOutboundConnections(reader, managementAddress, expectedNs, list);
                    continue block5;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseManagementInterfaces(reader, managementAddress, expectedNs, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseManagement_1_5(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseSecurityRealms(reader, managementAddress, expectedNs, list);
                    continue block7;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseOutboundConnections(reader, managementAddress, expectedNs, list);
                    continue block7;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.delegate.parseManagementInterfaces(reader, managementAddress, expectedNs, list);
                    continue block7;
                }
                case AUDIT_LOG: {
                    this.delegate.parseAuditLog(reader, managementAddress, expectedNs, list);
                    continue block7;
                }
                case ACCESS_CONTROL: {
                    this.delegate.parseAccessControl(reader, managementAddress, expectedNs, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private static void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LDAP: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: 
                        case DOMAIN_1_3: {
                            ManagementXml.parseLdapConnection_1_0(reader, address, list);
                            continue block8;
                        }
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: {
                            ManagementXml.parseLdapConnection_1_4(reader, address, list);
                            continue block8;
                        }
                        case DOMAIN_2_0: {
                            ManagementXml.parseLdapConnection_2_0(reader, address, expectedNs, list);
                            continue block8;
                        }
                    }
                    ManagementXml.parseLdapConnection_2_1(reader, address, expectedNs, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseLdapConnection_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL, Attribute.SEARCH_DN, Attribute.SEARCH_CREDENTIAL);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block7;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseLdapConnection_1_4(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block8;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseLdapConnection_2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block11;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    ManagementXml.parseLdapConnectionProperties(reader, connectionAddress, expectedNs, list);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseLdapConnection_2_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block13;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case REFERRALS: {
                    LdapConnectionResourceDefinition.REFERRALS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case HANDLES_REFERRALS_FOR: {
                    for (String url : reader.getListAttributeValue(i)) {
                        LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.parseAndAddParameterElement(url, add, (XMLStreamReader)reader);
                    }
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    ManagementXml.parseLdapConnectionProperties(reader, connectionAddress, expectedNs, list);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseLdapConnectionProperties(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    int count = reader.getAttributeCount();
                    block8: for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        required.remove(attribute);
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address.clone()).add("property", value);
                                continue block8;
                            }
                            case VALUE: {
                                LdapConnectionPropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (required.size() > 0) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    list.add(add);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            ManagementXml.parseSecurityRealm_1_0(reader, address, expectedNs, list);
                            continue block8;
                        }
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            ManagementXml.parseSecurityRealm_1_1(reader, address, expectedNs, list);
                            continue block8;
                        }
                        case DOMAIN_1_3: {
                            ManagementXml.parseSecurityRealm_1_3(reader, address, expectedNs, list);
                            continue block8;
                        }
                    }
                    ManagementXml.parseSecurityRealm_1_4(reader, address, expectedNs, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecurityRealm_1_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    ManagementXml.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
                case AUTHENTICATION: {
                    ManagementXml.parseAuthentication_1_0(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecurityRealm_1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    ManagementXml.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
                case AUTHENTICATION: {
                    ManagementXml.parseAuthentication_1_1(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
                case AUTHORIZATION: {
                    ManagementXml.parseAuthorization_1_1(reader, expectedNs, add, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecurityRealm_1_3(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    ManagementXml.parsePlugIns(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case SERVER_IDENTITIES: {
                    ManagementXml.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHENTICATION: {
                    ManagementXml.parseAuthentication_1_3(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHORIZATION: {
                    switch (expectedNs) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: {
                            ManagementXml.parseAuthorization_1_3(reader, expectedNs, realmAddress, list);
                            continue block9;
                        }
                    }
                    ManagementXml.parseAuthorization_1_5(reader, expectedNs, add, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecurityRealm_1_4(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    ManagementXml.parsePlugIns(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case SERVER_IDENTITIES: {
                    ManagementXml.parseServerIdentities(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHENTICATION: {
                    ManagementXml.parseAuthentication_1_3(reader, expectedNs, realmAddress, list);
                    continue block9;
                }
                case AUTHORIZATION: {
                    switch (expectedNs) {
                        case DOMAIN_1_4: {
                            ManagementXml.parseAuthorization_1_3(reader, expectedNs, realmAddress, list);
                            continue block9;
                        }
                    }
                    ManagementXml.parseAuthorization_1_5(reader, expectedNs, add, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePlugIns(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_IN: {
                    ModelNode plugIn = new ModelNode();
                    plugIn.get("operation").set("add");
                    String moduleValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.MODULE.getLocalName());
                    ModelNode newAddress = realmAddress.clone();
                    newAddress.add("plug-in", moduleValue);
                    plugIn.get("address").set(newAddress);
                    list.add(plugIn);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseServerIdentities(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    ManagementXml.parseSecret(reader, realmAddress, list);
                    continue block4;
                }
                case SSL: {
                    ManagementXml.parseSSL(reader, expectedNs, realmAddress, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSecret(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode secret = new ModelNode();
        secret.get("operation").set("add");
        secret.get("address").set(realmAddress).add("server-identity", "secret");
        String secretValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
        SecretServerIdentityResourceDefinition.VALUE.parseAndSetParameter(secretValue, secret, (XMLStreamReader)reader);
        list.add(secret);
    }

    private static void parseSSL(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            ManagementXml.parseKeystore_1_0(reader, ssl);
                            continue block11;
                        }
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: 
                        case DOMAIN_2_0: {
                            ManagementXml.parseKeystore_1_3(reader, ssl, true);
                            continue block11;
                        }
                    }
                    ManagementXml.parseKeystore_2_1(reader, ssl, true);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseKeystore_1_0(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.PASSWORD);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseKeystore_1_3(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.KEYSTORE_PASSWORD);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PASSWORD: {
                    DomainManagementLogger.ROOT_LOGGER.passwordAttributeDeprecated();
                    required.remove(Attribute.KEYSTORE_PASSWORD);
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseKeystore_2_1(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        boolean pathSet = false;
        boolean keystorePasswordSet = false;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROVIDER: {
                    KeystoreAttributes.KEYSTORE_PROVIDER.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    pathSet = true;
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    keystorePasswordSet = true;
                    continue block8;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!keystorePasswordSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.KEYSTORE_PASSWORD));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseAuthentication_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        int userCount = 0;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (++userCount > 1) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LDAP: {
                    ManagementXml.parseLdapAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case PROPERTIES: {
                    ManagementXml.parsePropertiesAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case USERS: {
                    ManagementXml.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ManagementXml.addLegacyLocalAuthentication(realmAddress, list);
    }

    private static void parseAuthentication_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean usernamePasswordFound = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseJaasAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseLdapAuthentication_1_1(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseTruststore(reader, expectedNs, realmAddress, list);
                    trustStoreFound = true;
                    continue block7;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ManagementXml.addLegacyLocalAuthentication(realmAddress, list);
    }

    private static void parseAuthentication_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean usernamePasswordFound = false;
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (expectedNs) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: 
                        case DOMAIN_2_0: 
                        case DOMAIN_2_1: {
                            ManagementXml.parseJaasAuthentication_1_1(reader, realmAddress, list);
                            break;
                        }
                        default: {
                            ManagementXml.parseJaasAuthentication_3_0(reader, realmAddress, list);
                        }
                    }
                    usernamePasswordFound = true;
                    continue block19;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (expectedNs) {
                        case DOMAIN_1_3: {
                            ManagementXml.parseLdapAuthentication_1_1(reader, expectedNs, realmAddress, list);
                            break;
                        }
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: {
                            ManagementXml.parseLdapAuthentication_1_4(reader, expectedNs, realmAddress, list);
                            break;
                        }
                        default: {
                            ManagementXml.parseLdapAuthentication_2_0(reader, expectedNs, realmAddress, list);
                        }
                    }
                    usernamePasswordFound = true;
                    continue block19;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block19;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseTruststore(reader, expectedNs, realmAddress, list);
                    trustStoreFound = true;
                    continue block19;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ManagementXml.parseUsersAuthentication(reader, expectedNs, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block19;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    ManagementXml.parsePlugIn_Authentication(reader, expectedNs, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block19;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (expectedNs) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: 
                        case DOMAIN_2_0: {
                            ManagementXml.parseLocalAuthentication_1_3(reader, expectedNs, realmAddress, list);
                            break;
                        }
                        default: {
                            ManagementXml.parseLocalAuthentication_2_1(reader, expectedNs, realmAddress, list);
                        }
                    }
                    localFound = true;
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseJaasAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseJaasAuthentication_3_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                case ASSIGN_GROUPS: {
                    JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseLdapAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN, Attribute.USERNAME_ATTRIBUTE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USERNAME_ATTRIBUTE: {
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseLdapAuthentication_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean choiceFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private static void parseLdapAuthentication_1_4(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean choiceFound = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block12;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private static void parseLdapAuthentication_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                case USERNAME_LOAD: {
                    LdapAuthenticationResourceDefinition.USERNAME_LOAD.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode addLdapCache = null;
        boolean choiceFound = false;
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CACHE: {
                    if (addLdapCache != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    addLdapCache = ManagementXml.parseLdapCache(reader);
                    continue block14;
                }
                case ADVANCED_FILTER: {
                    choiceFound = true;
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block14;
                }
                case USERNAME_FILTER: {
                    choiceFound = true;
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
        if (addLdapCache != null) {
            ManagementXml.correctCacheAddress(ldapAuthentication, addLdapCache);
            list.add(addLdapCache);
        }
    }

    private static ModelNode parseLdapCache(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addr = new ModelNode();
        ModelNode addCacheOp = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        String type = "by-search-time";
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if ("by-access-time".equals(value) || "by-search-time".equals(value)) {
                        type = value;
                        continue block6;
                    }
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                }
                case EVICTION_TIME: {
                    LdapCacheResourceDefinition.EVICTION_TIME.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case CACHE_FAILURES: {
                    LdapCacheResourceDefinition.CACHE_FAILURES.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_CACHE_SIZE: {
                    LdapCacheResourceDefinition.MAX_CACHE_SIZE.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addCacheOp.get("address").add("cache", type);
        return addCacheOp;
    }

    private static void correctCacheAddress(ModelNode parentAdd, ModelNode cacheAdd) {
        List addressList = cacheAdd.get("address").asPropertyList();
        ModelNode cacheAddress = parentAdd.get("address").clone();
        for (Property current : addressList) {
            cacheAddress.add(current.getName(), current.getValue().asString());
        }
        cacheAdd.get("address").set(cacheAddress);
    }

    private static void addLegacyLocalAuthentication(ModelNode realmAddress, List<ModelNode> list) {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        local.get("default-user").set("$local");
        list.add(local);
    }

    private static void parseLocalAuthentication_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseLocalAuthentication_2_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_GROUP_LOADING: {
                    LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parsePropertiesAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        properties.get("plain-text").set(true);
    }

    private static void parsePropertiesAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case PLAIN_TEXT: {
                    PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseUsersAuthentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode usersAddress = realmAddress.clone().add("authentication", "users");
        list.add(Util.getEmptyOperation((String)"add", (ModelNode)usersAddress));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case USER: {
                    ManagementXml.parseUser(reader, expectedNs, usersAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseUser(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode usersAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode userAddress = usersAddress.clone().add("user", userName);
        ModelNode user = Util.getEmptyOperation((String)"add", (ModelNode)userAddress);
        list.add(user);
        String password = null;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PASSWORD: {
                    password = reader.getElementText();
                    UserResourceDefinition.PASSWORD.parseAndSetParameter(password, user, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (password == null) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.PASSWORD));
        }
    }

    private static void parseTruststore(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(realmAddress).add("authentication", "truststore");
        switch (expectedNs) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: {
                ManagementXml.parseKeystore_1_0(reader, op);
                break;
            }
            case DOMAIN_1_3: 
            case DOMAIN_1_4: 
            case DOMAIN_1_5: 
            case DOMAIN_2_0: {
                ManagementXml.parseKeystore_1_3(reader, op, false);
                break;
            }
            default: {
                ManagementXml.parseKeystore_2_1(reader, op, false);
            }
        }
        list.add(op);
    }

    private static void parseAuthorization_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        boolean authzFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    ManagementXml.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseAuthorization_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean authzFound = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    ManagementXml.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block4;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    ManagementXml.parsePlugIn_Authorization(reader, expectedNs, parentAddress, list);
                    authzFound = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseAuthorization_1_5(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAP_GROUPS_TO_ROLES: {
                    SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.parseAndSetParameter(value, realmAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean authzFound = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    ManagementXml.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    ManagementXml.parsePlugIn_Authorization(reader, expectedNs, parentAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case LDAP: {
                    ManagementXml.parseLdapAuthorization_1_5(reader, expectedNs, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseLdapAuthorization_1_5(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "ldap");
        ModelNode ldapAuthorization = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthorization);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthorizationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthorization, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        HashSet<Element> foundElements = new HashSet<Element>();
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (!foundElements.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_TO_DN: {
                    switch (expectedNs) {
                        case DOMAIN_1_5: {
                            ManagementXml.parseUsernameToDn_1_5(reader, expectedNs, addr, list);
                            continue block14;
                        }
                    }
                    ManagementXml.parseUsernameToDn_2_0(reader, expectedNs, addr, list);
                    continue block14;
                }
                case GROUP_SEARCH: {
                    switch (expectedNs) {
                        case DOMAIN_1_5: {
                            ManagementXml.parseGroupSearch_1_5(reader, expectedNs, addr, list);
                            continue block14;
                        }
                    }
                    ManagementXml.parseGroupSearch_2_0(reader, expectedNs, addr, list);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseUsernameToDn_1_5(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_IS_DN: {
                    filterFound = true;
                    ManagementXml.parseUsernameIsDn(reader, address, childAdd);
                    continue block9;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    ManagementXml.parseUsernameFilter(reader, address, childAdd);
                    continue block9;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    ManagementXml.parseAdvancedFilter(reader, address, childAdd);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
    }

    private static void parseUsernameToDn_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = ManagementXml.parseLdapCache(reader);
                    continue block10;
                }
                case USERNAME_IS_DN: {
                    filterFound = true;
                    ManagementXml.parseUsernameIsDn(reader, address, childAdd);
                    continue block10;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    ManagementXml.parseUsernameFilter(reader, address, childAdd);
                    continue block10;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    ManagementXml.parseAdvancedFilter(reader, address, childAdd);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            ManagementXml.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private static void parseUsernameIsDn(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-is-dn"));
    }

    private static void parseUsernameFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    UserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    UserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case ATTRIBUTE: {
                    UserSearchResourceDefintion.ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-filter"));
    }

    private static void parseAdvancedFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    AdvancedUserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    AdvancedUserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case FILTER: {
                    AdvancedUserSearchResourceDefintion.FILTER.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("advanced-filter"));
    }

    private static void parseGroupSearch_1_5(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode address = ldapAddress.clone().add("group-search");
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    ManagementXml.parseGroupToPrincipal(reader, expectedNs, address, childAdd);
                    continue block11;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    ManagementXml.parsePrincipalToGroup_1_5(reader, expectedNs, address, childAdd);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
    }

    private static void parseGroupSearch_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block14;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block14;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block14;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("group-search");
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = ManagementXml.parseLdapCache(reader);
                    continue block15;
                }
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    ManagementXml.parseGroupToPrincipal(reader, expectedNs, address, childAdd);
                    continue block15;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    switch (expectedNs) {
                        case DOMAIN_2_0: {
                            ManagementXml.parsePrincipalToGroup_1_5(reader, expectedNs, address, childAdd);
                            continue block15;
                        }
                    }
                    ManagementXml.parsePrincipalToGroup_2_1(reader, expectedNs, address, childAdd);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            ManagementXml.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private static void parseGroupToPrincipalAttributes_1_5_2_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private static void parseGroupToPrincipalAttributes_3_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private static void parseGroupToPrincipal(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_5: 
            case DOMAIN_2_0: 
            case DOMAIN_2_1: {
                ManagementXml.parseGroupToPrincipalAttributes_1_5_2_0(reader, addOp);
                break;
            }
            default: {
                ManagementXml.parseGroupToPrincipalAttributes_3_0(reader, addOp);
            }
        }
        boolean elementFound = false;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (elementFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            elementFound = true;
            switch (element) {
                case MEMBERSHIP_FILTER: {
                    ManagementXml.parseMembershipFilter(reader, addOp);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        addOp.get("address").set(parentAddress.clone().add("group-to-principal"));
    }

    private static void parseMembershipFilter(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean principalAttribute = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PRINCIPAL_ATTRIBUTE: {
                    principalAttribute = true;
                    GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!principalAttribute) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PRINCIPAL_ATTRIBUTE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parsePrincipalToGroup_1_5(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private static void parsePrincipalToGroup_2_1(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private static void parsePropertiesAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthorizationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parsePlugIn_Authentication(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    PlugInAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    nameFound = true;
                    continue block10;
                }
                case MECHANISM: {
                    PlugInAuthenticationResourceDefinition.MECHANISM.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block12: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                ManagementXml.parseProperty(reader, addr, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePlugIn_Authorization(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String plugInName = reader.getAttributeValue(0);
        plugIn.get("name").set(plugInName);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block7: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                ManagementXml.parseProperty(reader, addr, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        boolean addressFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(parentAddress).add("property", value);
                    addressFound = true;
                    continue block4;
                }
                case VALUE: {
                    PropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!addressFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public static void parseAccessControlRoleMapping(XMLExtendedStreamReader reader, ModelNode accContAddr, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.ROLE) {
                ManagementXml.parseRole(reader, accContAddr, expectedNs, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseRole(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        list.add(add);
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case INCLUDE_ALL: {
                    RoleMappingResourceDefinition.INCLUDE_ALL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode addr = address.clone().add("role-mapping", name);
        add.get("address").set(addr);
        add.get("operation").set("add");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INCLUDE: {
                    ModelNode includeAddr = addr.clone().add("include");
                    ManagementXml.parseIncludeExclude(reader, includeAddr, expectedNs, list);
                    continue block9;
                }
                case EXCLUDE: {
                    ModelNode excludeAddr = addr.clone().add("exclude");
                    ManagementXml.parseIncludeExclude(reader, excludeAddr, expectedNs, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseIncludeExclude(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case GROUP: {
                    ManagementXml.parsePrincipal(reader, address, "group", expectedNs, list);
                    continue block4;
                }
                case USER: {
                    ManagementXml.parsePrincipal(reader, address, "user", expectedNs, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePrincipal(XMLExtendedStreamReader reader, ModelNode address, String type, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        String alias = null;
        String realm = null;
        String name = null;
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("type").set(type);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALIAS: {
                    alias = value;
                    continue block5;
                }
                case NAME: {
                    name = value;
                    PrincipalResourceDefinition.NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case REALM: {
                    realm = value;
                    PrincipalResourceDefinition.REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String addrValue = alias == null ? ManagementXml.generateAlias(type, name, realm) : alias;
        ModelNode addAddr = address.clone().add(addrValue);
        addOp.get("address").set(addAddr);
        list.add(addOp);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String generateAlias(String type, String name, String realm) {
        return type + "-" + name + (realm != null ? "@" + realm : "");
    }

    public static void parseAccessControlConstraints(XMLExtendedStreamReader reader, ModelNode accAuthzAddr, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_EXPRESSION_SENSITIVITY: {
                    ModelNode vaultAddr = accAuthzAddr.clone().add("constraint", "vault-expression");
                    ManagementXml.parseClassificationType(reader, vaultAddr, expectedNs, list, true);
                    continue block5;
                }
                case SENSITIVE_CLASSIFICATIONS: {
                    ModelNode sensAddr = accAuthzAddr.clone().add("constraint", "sensitivity-classification");
                    ManagementXml.parseSensitiveClassifications(reader, sensAddr, expectedNs, list);
                    continue block5;
                }
                case APPLICATION_CLASSIFICATIONS: {
                    ModelNode applAddr = accAuthzAddr.clone().add("constraint", "application-classification");
                    ManagementXml.parseApplicationClassifications(reader, applAddr, expectedNs, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSensitiveClassifications(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SENSITIVE_CLASSIFICATION: {
                    ManagementXml.parseSensitivityClassification(reader, address, expectedNs, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseSensitivityClassification(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ManagementXml.parseClassificationType(reader, address, expectedNs, list, false);
    }

    private static void parseClassificationType(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean vault) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String type = null;
        HashMap<String, ModelNode> values = new HashMap<String, ModelNode>();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case TYPE: {
                    type = value;
                    continue block7;
                }
                case REQUIRES_READ: {
                    values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.parse(value, (XMLStreamReader)reader));
                    continue block7;
                }
                case REQUIRES_WRITE: {
                    values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.parse(value, (XMLStreamReader)reader));
                    continue block7;
                }
                case REQUIRES_ADDRESSABLE: {
                    if (!vault) {
                        values.put(SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.getName(), SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.parse(value, (XMLStreamReader)reader));
                        continue block7;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null && !vault) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (type == null && !vault) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        ModelNode newAddress = vault ? address : address.clone().add(SensitivityClassificationTypeResourceDefinition.PATH_ELEMENT.getKey(), type).add(SensitivityResourceDefinition.PATH_ELEMENT.getKey(), name);
        for (Map.Entry entry : values.entrySet()) {
            list.add(Util.getWriteAttributeOperation((ModelNode)newAddress, (String)((String)entry.getKey()), (ModelNode)((ModelNode)entry.getValue())));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseApplicationClassifications(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case APPLICATION_CLASSIFICATION: {
                    ManagementXml.parseApplicationClassification(reader, address, expectedNs, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseApplicationClassification(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String type = null;
        Boolean applicationValue = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case TYPE: {
                    type = value;
                    continue block5;
                }
                case APPLICATION: {
                    applicationValue = Boolean.valueOf(value);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (type == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        if (applicationValue == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.APPLICATION));
        }
        ModelNode newAddress = address.clone().add(ApplicationClassificationTypeResourceDefinition.PATH_ELEMENT.getKey(), type).add(ApplicationClassificationConfigResourceDefinition.PATH_ELEMENT.getKey(), name);
        list.add(Util.getWriteAttributeOperation((ModelNode)newAddress, (String)ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.getName(), (String)applicationValue.toString()));
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public static void parseServerGroupScopedRoles(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String scopedRoleType = ServerGroupScopedRoleResourceDefinition.PATH_ELEMENT.getKey();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE: {
                    ManagementXml.parseScopedRole(reader, address, expectedNs, list, scopedRoleType, Element.SERVER_GROUP, ServerGroupScopedRoleResourceDefinition.BASE_ROLE, ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS, true);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public static void parseHostScopedRoles(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String scopedRoleType = HostScopedRolesResourceDefinition.PATH_ELEMENT.getKey();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE: {
                    ManagementXml.parseScopedRole(reader, address, expectedNs, list, scopedRoleType, Element.HOST, HostScopedRolesResourceDefinition.BASE_ROLE, HostScopedRolesResourceDefinition.HOSTS, false);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseScopedRole(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> ops, String scopedRoleType, Element listElement, SimpleAttributeDefinition baseRoleDefinition, ListAttributeDefinition listDefinition, boolean requireChildren) throws XMLStreamException {
        ModelNode addOp = Util.createAddOperation();
        ops.add(addOp);
        ModelNode ourAddress = addOp.get("address").set(address);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.BASE_ROLE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    ourAddress.add(scopedRoleType, value);
                    continue block4;
                }
                case BASE_ROLE: {
                    baseRoleDefinition.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean missingChildren = requireChildren;
        while (reader.hasNext() && reader.nextTag() != 2) {
            boolean named = false;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == listElement) {
                missingChildren = false;
                int groupCount = reader.getAttributeCount();
                for (int i = 0; i < groupCount; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    required.remove(attribute);
                    if (attribute != Attribute.NAME) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    named = true;
                    listDefinition.parseAndAddParameterElement(value, addOp, (XMLStreamReader)reader);
                }
            } else {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!named) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
        if (missingChildren) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(listElement));
        }
    }

    public void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        ModelNode auditLog;
        boolean hasSecurityRealm = management.hasDefined("security-realm");
        boolean hasConnection = management.hasDefined("ldap-connection");
        boolean hasInterface = allowInterfaces && management.hasDefined("management-interface");
        ModelNode accessAuthorization = management.hasDefined("access") ? management.get(new String[]{"access", "authorization"}) : null;
        boolean accessAuthorizationDefined = accessAuthorization != null && accessAuthorization.isDefined();
        boolean hasServerGroupRoles = accessAuthorizationDefined && accessAuthorization.hasDefined("server-group-scoped-role");
        boolean hasHostRoles = accessAuthorizationDefined && (accessAuthorization.hasDefined("host-scoped-role") || accessAuthorization.hasDefined("host-scoped-roles"));
        boolean hasRoleMapping = accessAuthorizationDefined && accessAuthorization.hasDefined("role-mapping");
        Map<String, Map<String, Set<String>>> configuredAccessConstraints = ManagementXml.getConfiguredAccessConstraints(accessAuthorization);
        boolean hasProvider = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PROVIDER.getName());
        boolean hasCombinationPolicy = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName());
        ModelNode modelNode = auditLog = management.hasDefined("access") ? management.get(new String[]{"access", "audit"}) : new ModelNode();
        if (!(hasSecurityRealm || hasConnection || hasInterface || hasServerGroupRoles || hasHostRoles || hasRoleMapping || configuredAccessConstraints.size() != 0 || hasProvider || hasCombinationPolicy || auditLog.isDefined())) {
            return;
        }
        writer.writeStartElement(Element.MANAGEMENT.getLocalName());
        if (hasSecurityRealm) {
            this.writeSecurityRealm(writer, management);
        }
        if (hasConnection) {
            this.writeOutboundConnections(writer, management);
        }
        if (auditLog.isDefined()) {
            this.delegate.writeAuditLog(writer, auditLog);
        }
        if (allowInterfaces && hasInterface) {
            this.writeManagementInterfaces(writer, management);
        }
        if (accessAuthorizationDefined) {
            this.delegate.writeAccessControl(writer, accessAuthorization);
        }
        writer.writeEndElement();
    }

    private static void writeAccessControl(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
        ModelNode serverGroupRoles;
        if (accessAuthorization == null || !accessAuthorization.isDefined()) {
            return;
        }
        boolean hasServerGroupRoles = accessAuthorization.hasDefined("server-group-scoped-role");
        boolean hasHostRoles = accessAuthorization.hasDefined("host-scoped-role") || accessAuthorization.hasDefined("host-scoped-roles");
        boolean hasRoleMapping = accessAuthorization.hasDefined("role-mapping");
        Map<String, Map<String, Set<String>>> configuredAccessConstraints = ManagementXml.getConfiguredAccessConstraints(accessAuthorization);
        boolean hasProvider = accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PROVIDER.getName());
        boolean hasCombinationPolicy = accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName());
        if (!(hasProvider || hasCombinationPolicy || hasServerGroupRoles || hasHostRoles || hasRoleMapping || configuredAccessConstraints.size() != 0)) {
            return;
        }
        writer.writeStartElement(Element.ACCESS_CONTROL.getLocalName());
        AccessAuthorizationResourceDefinition.PROVIDER.marshallAsAttribute(accessAuthorization, (XMLStreamWriter)writer);
        AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.marshallAsAttribute(accessAuthorization, (XMLStreamWriter)writer);
        if (hasServerGroupRoles && (serverGroupRoles = accessAuthorization.get("server-group-scoped-role")).asInt() > 0) {
            ManagementXml.writeServerGroupScopedRoles(writer, serverGroupRoles);
        }
        if (hasHostRoles && (serverGroupRoles = accessAuthorization.get("host-scoped-role")).asInt() > 0) {
            ManagementXml.writeHostScopedRoles(writer, serverGroupRoles);
        }
        if (hasRoleMapping) {
            ManagementXml.writeRoleMapping(writer, accessAuthorization);
        }
        if (configuredAccessConstraints.size() > 0) {
            ManagementXml.writeAccessConstraints(writer, accessAuthorization, configuredAccessConstraints);
        }
        writer.writeEndElement();
    }

    private void writeSecurityRealm(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        ModelNode securityRealms = management.get("security-realm");
        writer.writeStartElement(Element.SECURITY_REALMS.getLocalName());
        for (Property variable : securityRealms.asPropertyList()) {
            writer.writeStartElement(Element.SECURITY_REALM.getLocalName());
            ManagementXml.writeAttribute(writer, Attribute.NAME, variable.getName());
            ModelNode realm = variable.getValue();
            if (realm.hasDefined("plug-in")) {
                this.writePlugIns(writer, realm.get("plug-in"));
            }
            if (realm.hasDefined("server-identity")) {
                this.writeServerIdentities(writer, realm);
            }
            if (realm.hasDefined("authentication")) {
                this.writeAuthentication(writer, realm);
            }
            this.writeAuthorization(writer, realm);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePlugIns(XMLExtendedStreamWriter writer, ModelNode plugIns) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_INS.getLocalName());
        for (Property variable : plugIns.asPropertyList()) {
            writer.writeEmptyElement(Element.PLUG_IN.getLocalName());
            writer.writeAttribute(Attribute.MODULE.getLocalName(), variable.getName());
        }
        writer.writeEndElement();
    }

    private void writeServerIdentities(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.SERVER_IDENTITIES.getLocalName());
        ModelNode serverIdentities = realm.get("server-identity");
        if (serverIdentities.hasDefined("ssl")) {
            boolean hasProvider;
            writer.writeStartElement(Element.SSL.getLocalName());
            ModelNode ssl = serverIdentities.get("ssl");
            SSLServerIdentityResourceDefinition.PROTOCOL.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
            boolean bl = hasProvider = ssl.hasDefined("keystore-provider") && !"JKS".equals(ssl.require("keystore-provider").asString());
            if (hasProvider || ssl.hasDefined(KeystoreAttributes.KEYSTORE_PATH.getName())) {
                writer.writeEmptyElement(Element.KEYSTORE.getLocalName());
                KeystoreAttributes.KEYSTORE_PROVIDER.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.ALIAS.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                KeystoreAttributes.KEY_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        if (serverIdentities.hasDefined("secret")) {
            ModelNode secret = serverIdentities.get("secret");
            writer.writeEmptyElement(Element.SECRET.getLocalName());
            SecretServerIdentityResourceDefinition.VALUE.marshallAsAttribute(secret, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeLdapCacheIfDefined(XMLExtendedStreamWriter writer, ModelNode parent) throws XMLStreamException {
        if (parent.hasDefined("cache")) {
            String type;
            ModelNode cache;
            ModelNode cacheHolder = parent.require("cache");
            if (cacheHolder.hasDefined("by-access-time")) {
                cache = cacheHolder.require("by-access-time");
                type = "by-access-time";
            } else if (cacheHolder.hasDefined("by-search-time")) {
                cache = cacheHolder.require("by-search-time");
                type = "by-search-time";
            } else {
                return;
            }
            writer.writeStartElement(Element.CACHE.getLocalName());
            if (!type.equals("by-search-time")) {
                writer.writeAttribute(Attribute.TYPE.getLocalName(), type);
            }
            LdapCacheResourceDefinition.EVICTION_TIME.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            LdapCacheResourceDefinition.CACHE_FAILURES.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            LdapCacheResourceDefinition.MAX_CACHE_SIZE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
        ModelNode authentication = realm.require("authentication");
        if (authentication.hasDefined("truststore")) {
            ModelNode truststore = authentication.require("truststore");
            writer.writeEmptyElement(Element.TRUSTSTORE.getLocalName());
            KeystoreAttributes.KEYSTORE_PROVIDER.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PATH.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_RELATIVE_TO.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
            KeystoreAttributes.KEYSTORE_PASSWORD.marshallAsAttribute(truststore, (XMLStreamWriter)writer);
        }
        if (authentication.hasDefined("local")) {
            ModelNode local = authentication.require("local");
            writer.writeStartElement(Element.LOCAL.getLocalName());
            LocalAuthenticationResourceDefinition.DEFAULT_USER.marshallAsAttribute(local, (XMLStreamWriter)writer);
            LocalAuthenticationResourceDefinition.ALLOWED_USERS.marshallAsAttribute(local, (XMLStreamWriter)writer);
            LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.marshallAsAttribute(local, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (authentication.hasDefined("jaas")) {
            ModelNode jaas = authentication.get("jaas");
            writer.writeStartElement(Element.JAAS.getLocalName());
            JaasAuthenticationResourceDefinition.NAME.marshallAsAttribute(jaas, (XMLStreamWriter)writer);
            JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.marshallAsAttribute(jaas, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (authentication.hasDefined("ldap")) {
            ModelNode userLdap = authentication.get("ldap");
            writer.writeStartElement(Element.LDAP.getLocalName());
            LdapAuthenticationResourceDefinition.CONNECTION.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.BASE_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.RECURSIVE.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.USER_DN.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            LdapAuthenticationResourceDefinition.USERNAME_LOAD.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            this.writeLdapCacheIfDefined(writer, userLdap);
            if (LdapAuthenticationResourceDefinition.USERNAME_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.USERNAME_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.USERNAME_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            } else if (LdapAuthenticationResourceDefinition.ADVANCED_FILTER.isMarshallable(userLdap)) {
                writer.writeEmptyElement(Element.ADVANCED_FILTER.getLocalName());
                LdapAuthenticationResourceDefinition.ADVANCED_FILTER.marshallAsAttribute(userLdap, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("properties")) {
            ModelNode properties = authentication.require("properties");
            writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
            PropertiesAuthenticationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
            PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.marshallAsAttribute(properties, (XMLStreamWriter)writer);
        } else if (authentication.has("users")) {
            ModelNode userDomain = authentication.get("users");
            ModelNode users = userDomain.hasDefined("user") ? userDomain.require("user") : new ModelNode().setEmptyObject();
            writer.writeStartElement(Element.USERS.getLocalName());
            for (Property userProps : users.asPropertyList()) {
                String userName = userProps.getName();
                ModelNode currentUser = userProps.getValue();
                writer.writeStartElement(Element.USER.getLocalName());
                writer.writeAttribute(Attribute.USERNAME.getLocalName(), userName);
                UserResourceDefinition.PASSWORD.marshallAsElement(currentUser, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (authentication.hasDefined("plug-in")) {
            this.writePlugIn_Authentication(writer, authentication.get("plug-in"));
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authentication(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        PlugInAuthenticationResourceDefinition.MECHANISM.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            for (Property current : plugIn.get("property").asPropertyList()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current.getName());
                PropertyResourceDefinition.VALUE.marshallAsAttribute(current.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode realm) throws XMLStreamException {
        String mapGroupsToRoles;
        String defaultMapGroupsToRoles = Boolean.toString(SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.getDefaultValue().asBoolean());
        String string = mapGroupsToRoles = realm.hasDefined("map-groups-to-roles") ? realm.require("map-groups-to-roles").asString() : defaultMapGroupsToRoles;
        if (realm.hasDefined("authorization") || !defaultMapGroupsToRoles.equals(mapGroupsToRoles)) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.marshallAsAttribute(realm, (XMLStreamWriter)writer);
            if (realm.hasDefined("authorization")) {
                ModelNode authorization = realm.require("authorization");
                if (authorization.hasDefined("properties")) {
                    ModelNode properties = authorization.require("properties");
                    writer.writeEmptyElement(Element.PROPERTIES.getLocalName());
                    PropertiesAuthorizationResourceDefinition.PATH.marshallAsAttribute(properties, (XMLStreamWriter)writer);
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.marshallAsAttribute(properties, (XMLStreamWriter)writer);
                } else if (authorization.hasDefined("plug-in")) {
                    this.writePlugIn_Authorization(writer, authorization.get("plug-in"));
                } else if (authorization.hasDefined("ldap")) {
                    this.writeLdapAuthorization(writer, authorization.get("ldap"));
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeLdapAuthorization(XMLExtendedStreamWriter writer, ModelNode ldapNode) throws XMLStreamException {
        ModelNode groupSearch;
        ModelNode usenameToDn;
        writer.writeStartElement(Element.LDAP.getLocalName());
        LdapAuthorizationResourceDefinition.CONNECTION.marshallAsAttribute(ldapNode, (XMLStreamWriter)writer);
        if (ldapNode.hasDefined("username-to-dn") && ((usenameToDn = ldapNode.require("username-to-dn")).hasDefined("username-is-dn") || usenameToDn.hasDefined("username-filter") || usenameToDn.hasDefined("advanced-filter"))) {
            writer.writeStartElement(Element.USERNAME_TO_DN.getLocalName());
            if (usenameToDn.hasDefined("username-is-dn")) {
                ModelNode usernameIsDn = usenameToDn.require("username-is-dn");
                UserIsDnResourceDefintion.FORCE.marshallAsAttribute(usernameIsDn, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, usernameIsDn);
                writer.writeEmptyElement(Element.USERNAME_IS_DN.getLocalName());
            } else if (usenameToDn.hasDefined("username-filter")) {
                ModelNode usernameFilter = usenameToDn.require("username-filter");
                UserSearchResourceDefintion.FORCE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, usernameFilter);
                writer.writeStartElement(Element.USERNAME_FILTER.getLocalName());
                UserSearchResourceDefintion.BASE_DN.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.RECURSIVE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.USER_DN_ATTRIBUTE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                UserSearchResourceDefintion.ATTRIBUTE.marshallAsAttribute(usernameFilter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else {
                ModelNode advancedFilter = usenameToDn.require("advanced-filter");
                AdvancedUserSearchResourceDefintion.FORCE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, advancedFilter);
                writer.writeStartElement(Element.ADVANCED_FILTER.getLocalName());
                AdvancedUserSearchResourceDefintion.BASE_DN.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.RECURSIVE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.USER_DN_ATTRIBUTE.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                AdvancedUserSearchResourceDefintion.FILTER.marshallAsAttribute(advancedFilter, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (ldapNode.hasDefined("group-search") && ((groupSearch = ldapNode.require("group-search")).hasDefined("group-to-principal") || groupSearch.hasDefined("principal-to-group"))) {
            writer.writeStartElement(Element.GROUP_SEARCH.getLocalName());
            if (groupSearch.hasDefined("group-to-principal")) {
                ModelNode groupToPrincipal = groupSearch.require("group-to-principal");
                GroupToPrincipalResourceDefinition.GROUP_NAME.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.ITERATIVE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.GROUP_DN_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.GROUP_NAME_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, groupToPrincipal);
                writer.writeStartElement(Element.GROUP_TO_PRINCIPAL.getLocalName());
                GroupToPrincipalResourceDefinition.SEARCH_BY.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.BASE_DN.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.RECURSIVE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                writer.writeStartElement(Element.MEMBERSHIP_FILTER.getLocalName());
                GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.marshallAsAttribute(groupToPrincipal, (XMLStreamWriter)writer);
                writer.writeEndElement();
                writer.writeEndElement();
            } else {
                ModelNode principalToGroup = groupSearch.require("principal-to-group");
                PrincipalToGroupResourceDefinition.GROUP_NAME.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.ITERATIVE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.GROUP_DN_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.GROUP_NAME_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                this.writeLdapCacheIfDefined(writer, principalToGroup);
                writer.writeStartElement(Element.PRINCIPAL_TO_GROUP.getLocalName());
                PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.marshallAsAttribute(principalToGroup, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePlugIn_Authorization(XMLExtendedStreamWriter writer, ModelNode plugIn) throws XMLStreamException {
        writer.writeStartElement(Element.PLUG_IN.getLocalName());
        AbstractPlugInAuthResourceDefinition.NAME.marshallAsAttribute(plugIn, (XMLStreamWriter)writer);
        if (plugIn.hasDefined("property")) {
            writer.writeStartElement("properties");
            for (Property current : plugIn.get("property").asPropertyList()) {
                writer.writeEmptyElement("property");
                writer.writeAttribute(Attribute.NAME.getLocalName(), current.getName());
                PropertyResourceDefinition.VALUE.marshallAsAttribute(current.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeOutboundConnections(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.OUTBOUND_CONNECTIONS.getLocalName());
        for (Property variable : management.get("ldap-connection").asPropertyList()) {
            List propertyList;
            ModelNode connection = variable.getValue();
            writer.writeStartElement(Element.LDAP.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), variable.getName());
            LdapConnectionResourceDefinition.URL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_DN.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.SECURITY_REALM.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.REFERRALS.marshallAsAttribute(connection, (XMLStreamWriter)writer);
            LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.marshallAsElement(connection, (XMLStreamWriter)writer);
            if (connection.hasDefined("property") && (propertyList = connection.get("property").asPropertyList()).size() > 0) {
                writer.writeStartElement("properties");
                for (Property current : propertyList) {
                    writer.writeEmptyElement("property");
                    writer.writeAttribute(Attribute.NAME.getLocalName(), current.getName());
                    LdapConnectionPropertyResourceDefinition.VALUE.marshallAsAttribute(current.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeManagementInterfaces(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
        ModelNode managementInterfaces = management.get("management-interface");
        if (managementInterfaces.hasDefined("native-remoting-interface")) {
            writer.writeEmptyElement(Element.NATIVE_REMOTING_INTERFACE.getLocalName());
        }
        if (managementInterfaces.hasDefined("native-interface")) {
            this.delegate.writeNativeManagementProtocol(writer, managementInterfaces.get("native-interface"));
        }
        if (managementInterfaces.hasDefined("http-interface")) {
            this.delegate.writeHttpManagementProtocol(writer, managementInterfaces.get("http-interface"));
        }
        writer.writeEndElement();
    }

    private static Map<String, Map<String, Set<String>>> getConfiguredAccessConstraints(ModelNode accessAuthorization) {
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (accessAuthorization != null && accessAuthorization.hasDefined("constraint")) {
            ModelNode constraint = accessAuthorization.get("constraint");
            configuredConstraints.putAll(ManagementXml.getVaultConstraints(constraint));
            configuredConstraints.putAll(ManagementXml.getSensitivityClassificationConstraints(constraint));
            configuredConstraints.putAll(ManagementXml.getApplicationClassificationConstraints(constraint));
        }
        return configuredConstraints;
    }

    private static Map<String, Map<String, Set<String>>> getVaultConstraints(ModelNode constraint) {
        ModelNode classification;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("vault-expression") && ((classification = constraint.require("vault-expression")).hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName()) || classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName()))) {
            configuredConstraints.put(SensitivityResourceDefinition.VAULT_ELEMENT.getKey(), Collections.emptyMap());
        }
        return configuredConstraints;
    }

    private static Map<String, Map<String, Set<String>>> getSensitivityClassificationConstraints(ModelNode constraint) {
        ModelNode sensitivityParent;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("sensitivity-classification") && (sensitivityParent = constraint.require("sensitivity-classification")).hasDefined("type")) {
            for (Property typeProperty : sensitivityParent.get("type").asPropertyList()) {
                if (!typeProperty.getValue().hasDefined("classification")) continue;
                for (Property sensitivityProperty : typeProperty.getValue().get("classification").asPropertyList()) {
                    TreeSet<String> types;
                    ModelNode classification = sensitivityProperty.getValue();
                    if (!classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && !classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.getName()) && !classification.hasDefined(SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.getName())) continue;
                    TreeMap<String, TreeSet<String>> constraintMap = (TreeMap<String, TreeSet<String>>)configuredConstraints.get("sensitivity-classification");
                    if (constraintMap == null) {
                        constraintMap = new TreeMap<String, TreeSet<String>>();
                        configuredConstraints.put("sensitivity-classification", constraintMap);
                    }
                    if ((types = (TreeSet<String>)constraintMap.get(typeProperty.getName())) == null) {
                        types = new TreeSet<String>();
                        constraintMap.put(typeProperty.getName(), types);
                    }
                    types.add(sensitivityProperty.getName());
                }
            }
        }
        return configuredConstraints;
    }

    private static Map<String, Map<String, Set<String>>> getApplicationClassificationConstraints(ModelNode constraint) {
        ModelNode appTypeParent;
        HashMap<String, Map<String, Set<String>>> configuredConstraints = new HashMap<String, Map<String, Set<String>>>();
        if (constraint.hasDefined("application-classification") && (appTypeParent = constraint.require("application-classification")).hasDefined("type")) {
            for (Property typeProperty : appTypeParent.get("type").asPropertyList()) {
                if (!typeProperty.getValue().hasDefined("classification")) continue;
                for (Property applicationProperty : typeProperty.getValue().get("classification").asPropertyList()) {
                    TreeSet<String> types;
                    ModelNode applicationType = applicationProperty.getValue();
                    if (!applicationType.hasDefined(ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.getName())) continue;
                    TreeMap<String, TreeSet<String>> constraintMap = (TreeMap<String, TreeSet<String>>)configuredConstraints.get("application-classification");
                    if (constraintMap == null) {
                        constraintMap = new TreeMap<String, TreeSet<String>>();
                        configuredConstraints.put("application-classification", constraintMap);
                    }
                    if ((types = (TreeSet<String>)constraintMap.get(typeProperty.getName())) == null) {
                        types = new TreeSet<String>();
                        constraintMap.put(typeProperty.getName(), types);
                    }
                    types.add(applicationProperty.getName());
                }
            }
        }
        return configuredConstraints;
    }

    private static void writeRoleMapping(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
        writer.writeStartElement(Element.ROLE_MAPPING.getLocalName());
        if (accessAuthorization.hasDefined("role-mapping")) {
            ModelNode roleMappings = accessAuthorization.get("role-mapping");
            for (Property variable : roleMappings.asPropertyList()) {
                writer.writeStartElement(Element.ROLE.getLocalName());
                ManagementXml.writeAttribute(writer, Attribute.NAME, variable.getName());
                ModelNode role = variable.getValue();
                RoleMappingResourceDefinition.INCLUDE_ALL.marshallAsAttribute(role, (XMLStreamWriter)writer);
                if (role.hasDefined("include")) {
                    ManagementXml.writeIncludeExclude(writer, Element.INCLUDE.getLocalName(), role.get("include"));
                }
                if (role.hasDefined("exclude")) {
                    ManagementXml.writeIncludeExclude(writer, Element.EXCLUDE.getLocalName(), role.get("exclude"));
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeIncludeExclude(XMLExtendedStreamWriter writer, String elementName, ModelNode includeExclude) throws XMLStreamException {
        List list = includeExclude.asPropertyList();
        if (list.isEmpty()) {
            return;
        }
        writer.writeStartElement(elementName);
        for (Property current : list) {
            ManagementXml.writePrincipal(writer, current.getName(), current.getValue());
        }
        writer.writeEndElement();
    }

    private static void writePrincipal(XMLExtendedStreamWriter writer, String alias, ModelNode principal) throws XMLStreamException {
        String elementName = principal.require("type").asString().equalsIgnoreCase("group") ? Element.GROUP.getLocalName() : Element.USER.getLocalName();
        writer.writeStartElement(elementName);
        String realm = principal.get("realm").isDefined() ? principal.require("realm").asString() : null;
        String name = principal.require("name").asString();
        String expectedAlias = ManagementXml.generateAlias(elementName, name, realm);
        if (!alias.equals(expectedAlias)) {
            ManagementXml.writeAttribute(writer, Attribute.ALIAS, alias);
        }
        PrincipalResourceDefinition.REALM.marshallAsAttribute(principal, (XMLStreamWriter)writer);
        PrincipalResourceDefinition.NAME.marshallAsAttribute(principal, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private static void writeAccessConstraints(XMLExtendedStreamWriter writer, ModelNode accessAuthorization, Map<String, Map<String, Set<String>>> configuredConstraints) throws XMLStreamException {
        ModelNode model;
        Map<String, Set<String>> constraints;
        writer.writeStartElement(Element.CONSTRAINTS.getLocalName());
        if (configuredConstraints.containsKey(SensitivityResourceDefinition.VAULT_ELEMENT.getKey())) {
            writer.writeEmptyElement(Element.VAULT_EXPRESSION_SENSITIVITY.getLocalName());
            ModelNode model2 = accessAuthorization.get(new String[]{SensitivityResourceDefinition.VAULT_ELEMENT.getKey(), SensitivityResourceDefinition.VAULT_ELEMENT.getValue()});
            SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.marshallAsAttribute(model2, (XMLStreamWriter)writer);
            SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.marshallAsAttribute(model2, (XMLStreamWriter)writer);
        }
        if (configuredConstraints.containsKey("sensitivity-classification")) {
            writer.writeStartElement(Element.SENSITIVE_CLASSIFICATIONS.getLocalName());
            constraints = configuredConstraints.get("sensitivity-classification");
            for (Map.Entry<String, Set<String>> entry : constraints.entrySet()) {
                for (String classification : entry.getValue()) {
                    writer.writeEmptyElement(Element.SENSITIVE_CLASSIFICATION.getLocalName());
                    model = accessAuthorization.get(new String[]{"constraint", "sensitivity-classification", "type", entry.getKey(), "classification", classification});
                    ManagementXml.writeAttribute(writer, Attribute.TYPE, entry.getKey());
                    ManagementXml.writeAttribute(writer, Attribute.NAME, classification);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_ADDRESSABLE.marshallAsAttribute(model, (XMLStreamWriter)writer);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_READ.marshallAsAttribute(model, (XMLStreamWriter)writer);
                    SensitivityResourceDefinition.CONFIGURED_REQUIRES_WRITE.marshallAsAttribute(model, (XMLStreamWriter)writer);
                }
            }
            writer.writeEndElement();
        }
        if (configuredConstraints.containsKey("application-classification")) {
            writer.writeStartElement(Element.APPLICATION_CLASSIFICATIONS.getLocalName());
            constraints = configuredConstraints.get("application-classification");
            for (Map.Entry<String, Set<String>> entry : constraints.entrySet()) {
                for (String classification : entry.getValue()) {
                    writer.writeEmptyElement(Element.APPLICATION_CLASSIFICATION.getLocalName());
                    model = accessAuthorization.get(new String[]{"constraint", "application-classification", "type", entry.getKey(), "classification", classification});
                    ManagementXml.writeAttribute(writer, Attribute.TYPE, entry.getKey());
                    ManagementXml.writeAttribute(writer, Attribute.NAME, classification);
                    ApplicationClassificationConfigResourceDefinition.CONFIGURED_APPLICATION.marshallAsAttribute(model, (XMLStreamWriter)writer);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeServerGroupScopedRoles(XMLExtendedStreamWriter writer, ModelNode scopedRoles) throws XMLStreamException {
        writer.writeStartElement(Element.SERVER_GROUP_SCOPED_ROLES.getLocalName());
        for (Property property : scopedRoles.asPropertyList()) {
            writer.writeStartElement(Element.ROLE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            ModelNode value = property.getValue();
            ServerGroupScopedRoleResourceDefinition.BASE_ROLE.marshallAsAttribute(value, (XMLStreamWriter)writer);
            ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS.marshallAsElement(value, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeHostScopedRoles(XMLExtendedStreamWriter writer, ModelNode scopedRoles) throws XMLStreamException {
        writer.writeStartElement(Element.HOST_SCOPED_ROLES.getLocalName());
        for (Property property : scopedRoles.asPropertyList()) {
            writer.writeStartElement(Element.ROLE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            ModelNode value = property.getValue();
            HostScopedRolesResourceDefinition.BASE_ROLE.marshallAsAttribute(value, (XMLStreamWriter)writer);
            HostScopedRolesResourceDefinition.HOSTS.marshallAsElement(value, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    public static abstract class Delegate {
        protected void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> operationsList) throws XMLStreamException {
            ManagementXml.parseSecurityRealms(reader, address, expectedNs, operationsList);
        }

        protected void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> operationsList) throws XMLStreamException {
            ManagementXml.parseOutboundConnections(reader, address, expectedNs, operationsList);
        }

        protected void parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> operationsList) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        protected void parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> operationsList) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        protected void parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        protected void writeAccessControl(XMLExtendedStreamWriter writer, ModelNode accessAuthorization) throws XMLStreamException {
            ManagementXml.writeAccessControl(writer, accessAuthorization);
        }

        protected void writeNativeManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        protected void writeHttpManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        protected void writeAuditLog(XMLExtendedStreamWriter writer, ModelNode auditLog) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }
    }
}

