/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.domain.management.controller.ActiveOperationResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class SecureOperationReadHandler
implements OperationStepHandler {
    private static final String HIDDEN = "<hidden>";
    private static final Set<Action.ActionEffect> ADDRESS_EFFECT = EnumSet.of(Action.ActionEffect.ADDRESS);
    static final OperationStepHandler INSTANCE = new SecureOperationReadHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        AuthorizedAddress authorizedAddress = this.authorizeAddress(context, operation);
        String attribute = operation.require("name").asString();
        if (ActiveOperationResourceDefinition.OPERATION_NAME.getName().equals(attribute)) {
            if (authorizedAddress.elided) {
                context.getResult().set(HIDDEN);
            } else {
                context.getResult().set(model.get(attribute));
            }
        } else if (ActiveOperationResourceDefinition.ADDRESS.getName().equals(attribute)) {
            if (authorizedAddress.elided) {
                context.getResult().set(authorizedAddress.address);
            } else {
                context.getResult().set(model.get(attribute));
            }
        } else {
            throw new IllegalStateException();
        }
        context.stepCompleted();
    }

    private AuthorizedAddress authorizeAddress(OperationContext context, ModelNode operation) {
        ModelNode address = operation.get("address");
        ModelNode testOp = new ModelNode();
        testOp.get("operation").set("read-resource");
        testOp.get("address").set(address);
        AuthorizationResult authResult = context.authorize(testOp, ADDRESS_EFFECT);
        if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT) {
            return new AuthorizedAddress(address, false);
        }
        ModelNode partialAddress = new ModelNode().setEmptyList();
        ModelNode elidedAddress = new ModelNode().setEmptyList();
        for (Property prop : address.asPropertyList()) {
            partialAddress.add(prop);
            testOp.get("address").set(address);
            authResult = context.authorize(testOp, ADDRESS_EFFECT);
            if (authResult.getDecision() == AuthorizationResult.Decision.DENY) {
                elidedAddress.add(prop.getName(), HIDDEN);
                return new AuthorizedAddress(elidedAddress, false);
            }
            elidedAddress.add(prop);
        }
        ModelNode strange = new ModelNode();
        strange.add(HIDDEN, HIDDEN);
        return new AuthorizedAddress(strange, true);
    }

    private static class AuthorizedAddress {
        private final ModelNode address;
        private final boolean elided;

        private AuthorizedAddress(ModelNode address, boolean elided) {
            this.address = address;
            this.elided = elided;
        }
    }
}

