/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class PropertiesCallbackHandler
extends UserPropertiesFileLoader
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "properties_authentication";
    private static UsernamePasswordHashUtil hashUtil = null;
    private final String realm;
    private final boolean plainText;

    public PropertiesCallbackHandler(String realm, String path, boolean plainText) {
        super(path);
        this.realm = realm;
        this.plainText = plainText;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.DIGEST;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.singleton(AuthMechanism.PLAIN);
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        HashMap<String, String> response = new HashMap<String, String>(2);
        response.put("org.jboss.as.domain.management.digest.plain_text", Boolean.toString(this.plainText));
        response.put("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
        return response;
    }

    @Override
    public boolean isReady() {
        Properties users;
        try {
            users = this.getProperties();
        }
        catch (IOException e) {
            return false;
        }
        return users.size() > 0;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    protected void verifyProperties(Properties properties) throws IOException {
        String admin = "admin";
        if (properties.contains("admin") && "admin".equals(properties.get("admin"))) {
            DomainManagementLogger.ROOT_LOGGER.userAndPasswordWarning();
        }
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            String fileRealm = this.getRealmName();
            if (fileRealm != null && !this.realm.equals(this.getRealmName())) {
                DomainManagementLogger.ROOT_LOGGER.realmMisMatch(this.realm, fileRealm);
            }
        }
        catch (IOException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToLoadProperties(e);
        }
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        boolean userFound = false;
        Properties users = this.getProperties();
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                userFound = users.containsKey(userName);
                continue;
            }
            if (current instanceof PasswordCallback && this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof DigestHashCallback && !this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof VerifyPasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementLogger.ROOT_LOGGER.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            String hash;
            UsernamePasswordHashUtil hashUtil;
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
                acb.setAuthorized(authorized);
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (!userFound) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                    throw new UserNotFoundException(userName);
                }
                String password = users.get(userName).toString();
                ((PasswordCallback)current).setPassword(password.toCharArray());
                continue;
            }
            if (current instanceof DigestHashCallback) {
                if (!userFound) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                    throw new UserNotFoundException(userName);
                }
                String hash2 = users.get(userName).toString();
                ((DigestHashCallback)current).setHexHash(hash2);
                continue;
            }
            if (!(current instanceof VerifyPasswordCallback)) continue;
            if (!userFound) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                throw new UserNotFoundException(userName);
            }
            VerifyPasswordCallback vpc = (VerifyPasswordCallback)current;
            if (this.plainText) {
                String password = users.get(userName).toString();
                boolean verified = password.equals(vpc.getPassword());
                if (!verified) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user '%s'", userName);
                }
                vpc.setVerified(verified);
                continue;
            }
            UsernamePasswordHashUtil usernamePasswordHashUtil = hashUtil = PropertiesCallbackHandler.getHashUtil();
            synchronized (usernamePasswordHashUtil) {
                hash = hashUtil.generateHashedHexURP(userName, this.realm, vpc.getPassword().toCharArray());
            }
            String expected = users.get(userName).toString();
            boolean verified = expected.equals(hash);
            if (!verified) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Digest verification failed for user '%s'", userName);
            }
            vpc.setVerified(verified);
        }
    }

    private static UsernamePasswordHashUtil getHashUtil() {
        if (hashUtil == null) {
            try {
                hashUtil = new UsernamePasswordHashUtil();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return hashUtil;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PropertiesCallbackHandler.SERVICE_SUFFIX});
        }
    }
}

