/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

abstract class ScopedRoleAddHandler
extends AbstractAddStepHandler {
    private static final PathAddress AUTHZ_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT});
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    ScopedRoleAddHandler(WritableAuthorizerConfiguration authorizerConfiguration, AttributeDefinition ... attributes) {
        super(ScopedRoleAddHandler.enhanceAttributes(authorizerConfiguration, attributes));
        this.authorizerConfiguration = authorizerConfiguration;
    }

    private static Collection<? extends AttributeDefinition> enhanceAttributes(final WritableAuthorizerConfiguration authorizerConfiguration, AttributeDefinition ... attributes) {
        ArrayList<Object> enhanced = new ArrayList<Object>(attributes.length);
        for (AttributeDefinition current : attributes) {
            if (current.getName().equals("base-role")) {
                assert (current instanceof SimpleAttributeDefinition);
                enhanced.add(new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)current).setValidator(new ParameterValidator(){

                    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        this.validateParameter(parameterName, value);
                    }

                    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        Set standardRoles = authorizerConfiguration.getStandardRoles();
                        String specifiedRole = value.asString();
                        for (String current : standardRoles) {
                            if (!specifiedRole.equalsIgnoreCase(current)) continue;
                            return;
                        }
                        throw DomainManagementLogger.ROOT_LOGGER.badBaseRole(specifiedRole);
                    }
                }).setCorrector(new ParameterCorrector(){

                    public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
                        Set standardRoles = authorizerConfiguration.getStandardRoles();
                        String specifiedRole = newValue.asString();
                        for (String current : standardRoles) {
                            if (!specifiedRole.equalsIgnoreCase(current) || specifiedRole.equals(current)) continue;
                            return new ModelNode(current);
                        }
                        return newValue;
                    }
                }).build());
                continue;
            }
            enhanced.add(current);
        }
        return enhanced;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement lastElement = address.getLastElement();
        String roleName = lastElement.getValue();
        Set standardRoles = this.authorizerConfiguration.getStandardRoles();
        for (String current : standardRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.scopedRoleStandardName(roleName, current);
        }
        Resource readResource = context.readResourceFromRoot(AUTHZ_ADDRESS, false);
        Set hostScopedRoles = readResource.getChildrenNames("host-scoped-role");
        for (String current : hostScopedRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.duplicateScopedRole("host-scoped-role", roleName);
        }
        Set serverGroupScopedRoles = readResource.getChildrenNames("server-group-scoped-role");
        for (String current : serverGroupScopedRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.duplicateScopedRole("server-group-scoped-role", roleName);
        }
        super.execute(context, operation);
    }
}

