/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractTrustManagerService;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class FileTrustManagerService
extends AbstractTrustManagerService {
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private volatile String provider;
    private volatile String path;
    private volatile char[] keystorePassword;
    private volatile TrustManagerFactory trustManagerFactory;
    private volatile FileKeystore keyStore;

    FileTrustManagerService(String provider, String path, char[] keystorePassword) {
        this.provider = provider;
        this.path = path;
        this.keystorePassword = keystorePassword;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            this.trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        this.keyStore = FileKeystore.newTrustStore(this.provider, file, this.keystorePassword);
        this.keyStore.load();
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.keyStore = null;
    }

    @Override
    protected TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = this.loadTrustStore();
        this.trustManagerFactory.init(trustStore);
        TrustManager[] tmpTrustManagers = this.trustManagerFactory.getTrustManagers();
        TrustManager[] trustManagers = new TrustManager[tmpTrustManagers.length];
        for (int i = 0; i < tmpTrustManagers.length; ++i) {
            trustManagers[i] = new DelegatingTrustManager((X509TrustManager)tmpTrustManagers[i], this.keyStore);
        }
        return trustManagers;
    }

    @Override
    protected KeyStore loadTrustStore() {
        return this.keyStore.getKeyStore();
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    private class DelegatingTrustManager
    implements X509TrustManager {
        private X509TrustManager delegate;
        private final FileKeystore theTrustStore;

        private DelegatingTrustManager(X509TrustManager trustManager, FileKeystore theTrustStore) {
            this.delegate = trustManager;
            this.theTrustStore = theTrustStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.getDelegate().getAcceptedIssuers();
        }

        private synchronized X509TrustManager getDelegate() {
            if (this.theTrustStore.isModified()) {
                try {
                    this.theTrustStore.load();
                }
                catch (StartException e1) {
                    throw DomainManagementLogger.ROOT_LOGGER.unableToLoadKeyTrustFile(e1.getCause());
                }
                try {
                    TrustManager[] trustManagers;
                    FileTrustManagerService.this.trustManagerFactory.init(this.theTrustStore.getKeyStore());
                    for (TrustManager current : trustManagers = FileTrustManagerService.this.trustManagerFactory.getTrustManagers()) {
                        if (!(current instanceof X509TrustManager)) continue;
                        this.delegate = (X509TrustManager)current;
                        break;
                    }
                }
                catch (GeneralSecurityException e) {
                    throw DomainManagementLogger.ROOT_LOGGER.unableToOperateOnTrustStore(e);
                }
            }
            if (this.delegate == null) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToCreateDelegateTrustManager();
            }
            return this.delegate;
        }
    }
}

