/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class LengthRestriction
implements PasswordRestriction {
    private final int desiredLength;

    public LengthRestriction(int desiredLength) {
        this.desiredLength = desiredLength;
    }

    @Override
    public String getRequirementMessage() {
        return DomainManagementLogger.ROOT_LOGGER.passwordLengthInfo(this.desiredLength);
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (password == null || password.length() < this.desiredLength) {
            throw DomainManagementLogger.ROOT_LOGGER.passwordNotLongEnough(this.desiredLength);
        }
    }
}

