/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LdapSubjectSupplementalService
implements Service,
SubjectSupplementalService {
    private final Consumer<SubjectSupplementalService> subjectSupplementalServiceConsumer;
    private final Supplier<LdapConnectionManager> connectionManagerSupplier;
    private final Supplier<LdapSearcherCache<LdapEntry, String>> userSearcherSupplier;
    private final Supplier<LdapSearcherCache<LdapEntry[], LdapEntry>> groupSearcherSupplier;
    private LdapSearcherCache<LdapEntry, String> userSearcher;
    private LdapSearcherCache<LdapEntry[], LdapEntry> groupSearcher;
    protected final int searchTimeLimit = 10000;
    private final String realmName;
    private final boolean shareConnection;
    private final boolean forceUserDnSearch;
    private final boolean iterative;
    private final BaseLdapGroupSearchResource.GroupName groupName;

    LdapSubjectSupplementalService(Consumer<SubjectSupplementalService> subjectSupplementalServiceConsumer, Supplier<LdapConnectionManager> connectionManagerSupplier, Supplier<LdapSearcherCache<LdapEntry, String>> userSearcherSupplier, Supplier<LdapSearcherCache<LdapEntry[], LdapEntry>> groupSearcherSupplier, String realmName, boolean shareConnection, boolean forceUserDnSearch, boolean iterative, BaseLdapGroupSearchResource.GroupName groupName) {
        this.subjectSupplementalServiceConsumer = subjectSupplementalServiceConsumer;
        this.connectionManagerSupplier = connectionManagerSupplier;
        this.userSearcherSupplier = userSearcherSupplier;
        this.groupSearcherSupplier = groupSearcherSupplier;
        this.realmName = realmName;
        this.shareConnection = shareConnection;
        this.forceUserDnSearch = forceUserDnSearch;
        this.iterative = iterative;
        this.groupName = groupName;
    }

    public void start(StartContext context) {
        this.userSearcher = this.userSearcherSupplier != null ? this.userSearcherSupplier.get() : null;
        this.groupSearcher = this.groupSearcherSupplier.get();
        if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService realmName=%s", this.realmName);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService shareConnection=%b", this.shareConnection);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService forceUserDnSearch=%b", this.forceUserDnSearch);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService iterative=%b", this.iterative);
            DomainManagementLogger.SECURITY_LOGGER.tracef("LdapSubjectSupplementalService groupName=%s", (Object)this.groupName);
        }
        this.subjectSupplementalServiceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.subjectSupplementalServiceConsumer.accept(null);
        this.groupSearcher = null;
        this.userSearcher = null;
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return new LdapSubjectSupplemental(sharedState);
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ldap-authorization";

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return new RealmIdentityImpl(principal, SecurityRealmService.SharedStateSecurityRealm.getSharedState());
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final LdapGroupSearcher ldapGroupSearcher;
            private final Principal principal;
            private Set<String> groups;

            public RealmIdentityImpl(Principal principal, Map<String, Object> sharedState) {
                this.ldapGroupSearcher = new LdapGroupSearcher(sharedState != null ? sharedState : new HashMap());
                this.principal = principal;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                Set<String> groups = this.getGroups();
                return groups != null && !groups.isEmpty();
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                Set<String> groups = this.getGroups();
                if (groups != null && !groups.isEmpty()) {
                    HashMap<String, Set<String>> groupsAttributeMap = new HashMap<String, Set<String>>();
                    groupsAttributeMap.put("GROUPS", Collections.unmodifiableSet(groups));
                    return AuthorizationIdentity.basicIdentity((Attributes)new MapAttributes(Collections.unmodifiableMap(groupsAttributeMap)));
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("No groups found for identity '%s' in LDAP file.", this.principal.getName());
                return AuthorizationIdentity.EMPTY;
            }

            private synchronized Set<String> getGroups() throws RealmUnavailableException {
                if (this.groups == null) {
                    ClassLoader old = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(LdapSubjectSupplemental.class);
                    try {
                        this.groups = this.ldapGroupSearcher.loadGroups(Collections.singleton(this.principal.getName()));
                    }
                    catch (IOException e) {
                        throw new RealmUnavailableException((Throwable)e);
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                    }
                }
                return this.groups;
            }
        }
    }

    private class LdapGroupSearcher {
        private final Set<LdapEntry> searchedPerformed = new HashSet<LdapEntry>();
        private final Map<String, Object> sharedState;

        protected LdapGroupSearcher(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        Set<String> loadGroups(Set<String> users) throws IOException {
            LdapConnectionHandler connectionHandler;
            HashSet<String> groups = new HashSet<String>();
            if (this.sharedState.containsKey(LdapConnectionHandler.class.getName())) {
                DomainManagementLogger.SECURITY_LOGGER.trace("Using existing LdapConnectionHandler from shared state.");
                connectionHandler = (LdapConnectionHandler)this.sharedState.remove(LdapConnectionHandler.class.getName());
            } else {
                DomainManagementLogger.SECURITY_LOGGER.trace("Creating new LdapConnectionHandler.");
                connectionHandler = LdapConnectionHandler.newInstance((LdapConnectionManager)LdapSubjectSupplementalService.this.connectionManagerSupplier.get());
            }
            try {
                for (String current : users) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Loading groups for '%s'", current);
                    groups.addAll(this.loadGroups(current, connectionHandler));
                }
                HashSet<String> hashSet = groups;
                return hashSet;
            }
            catch (Exception e) {
                DomainManagementLogger.SECURITY_LOGGER.trace("Failure supplementing Subject", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            finally {
                connectionHandler.close();
            }
        }

        private Set<String> loadGroups(String user, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            LdapEntry entry = null;
            if (!LdapSubjectSupplementalService.this.forceUserDnSearch && this.sharedState.containsKey(LdapEntry.class.getName())) {
                entry = (LdapEntry)this.sharedState.get(LdapEntry.class.getName());
                DomainManagementLogger.SECURITY_LOGGER.tracef("Loaded from sharedState '%s'", entry);
            }
            if (entry == null || !user.equals(entry.getSimpleName())) {
                entry = (LdapEntry)LdapSubjectSupplementalService.this.userSearcher.search(connectionHandler, user).getResult();
                DomainManagementLogger.SECURITY_LOGGER.tracef("Performed userSearch '%s'", entry);
            }
            return this.loadGroups(entry, connectionHandler);
        }

        private Set<String> loadGroups(LdapEntry entry, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            HashSet<String> realmGroups = new HashSet<String>();
            Stack<LdapEntry[]> entries = new Stack<LdapEntry[]>();
            entries.push(this.loadGroupEntries(entry, connectionHandler));
            while (!entries.isEmpty()) {
                LdapEntry[] found;
                for (LdapEntry current : found = (LdapEntry[])entries.pop()) {
                    String group = LdapSubjectSupplementalService.this.groupName == BaseLdapGroupSearchResource.GroupName.SIMPLE ? current.getSimpleName() : current.getDistinguishedName();
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding RealmGroup '%s'", group);
                    realmGroups.add(group);
                    if (!LdapSubjectSupplementalService.this.iterative) continue;
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Performing iterative load for %s", current);
                    entries.push(this.loadGroupEntries(current, connectionHandler));
                }
            }
            return realmGroups;
        }

        private LdapEntry[] loadGroupEntries(LdapEntry entry, LdapConnectionHandler connectionHandler) throws IOException, NamingException {
            if (!this.searchedPerformed.add(entry)) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("A search has already been performed for %s", entry);
                return new LdapEntry[0];
            }
            return (LdapEntry[])LdapSubjectSupplementalService.this.groupSearcher.search(connectionHandler, entry).getResult();
        }
    }

    class LdapSubjectSupplemental
    implements SubjectSupplemental {
        private final LdapGroupSearcher ldapGroupSearcher;

        protected LdapSubjectSupplemental(Map<String, Object> sharedState) {
            this.ldapGroupSearcher = new LdapGroupSearcher(sharedState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void supplementSubject(Subject subject) throws IOException {
            ClassLoader old = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(LdapSubjectSupplemental.class);
            try {
                Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
                Set<Principal> principals = subject.getPrincipals();
                HashSet<RealmGroup> set = new HashSet<RealmGroup>();
                HashSet<String> result = new HashSet<String>();
                for (RealmUser user : users) {
                    String name = user.getName();
                    result.add(name);
                }
                for (String s : this.ldapGroupSearcher.loadGroups(result)) {
                    RealmGroup realmGroup = new RealmGroup(LdapSubjectSupplementalService.this.realmName, s);
                    set.add(realmGroup);
                }
                principals.addAll(set);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
            }
        }
    }
}

