/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.plugin.AuthenticationPlugIn;
import org.jboss.as.domain.management.plugin.AuthorizationPlugIn;
import org.jboss.as.domain.management.plugin.Credential;
import org.jboss.as.domain.management.plugin.PlugInProvider;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class PlugInLoaderService
implements Service {
    private static final String SERVICE_SUFFIX = "plug-in-loader";
    private final Consumer<PlugInLoaderService> plugInLoaderServiceConsumer;
    private final List<String> plugInNames;
    private final Map<String, List<PlugInProvider>> cachedProviders = new HashMap<String, List<PlugInProvider>>();
    private final Map<String, PlugInProvider> authenticationProviders = new HashMap<String, PlugInProvider>();
    private final Map<String, PlugInProvider> authorizationProviders = new HashMap<String, PlugInProvider>();

    PlugInLoaderService(Consumer<PlugInLoaderService> plugInLoaderServiceConsumer, List<String> plugInNames) {
        this.plugInLoaderServiceConsumer = plugInLoaderServiceConsumer;
        this.plugInNames = plugInNames;
    }

    public void start(StartContext context) {
        this.plugInLoaderServiceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.plugInLoaderServiceConsumer.accept(null);
        this.cachedProviders.clear();
        this.authenticationProviders.clear();
        this.authorizationProviders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PlugInProvider> loadPlugInProvider(String name) {
        Map<String, List<PlugInProvider>> map = this.cachedProviders;
        synchronized (map) {
            List<PlugInProvider> response;
            if (this.cachedProviders.containsKey(name)) {
                response = this.cachedProviders.get(name);
            } else {
                LinkedList<PlugInProvider> providers = new LinkedList<PlugInProvider>();
                try {
                    for (PlugInProvider current : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)name), PlugInProvider.class)) {
                        providers.add(current);
                    }
                }
                catch (ModuleLoadException e) {
                    throw DomainManagementLogger.ROOT_LOGGER.unableToLoadPlugInProviders(name, e.getMessage());
                }
                if (!providers.isEmpty()) {
                    this.cachedProviders.put(name, providers);
                    response = providers;
                } else {
                    throw DomainManagementLogger.ROOT_LOGGER.noPlugInProvidersLoaded(name);
                }
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationPlugIn<Credential> loadAuthenticationPlugIn(String name) {
        AuthenticationPlugIn<Credential> response = null;
        Map<String, PlugInProvider> map = this.authenticationProviders;
        synchronized (map) {
            PlugInProvider provider;
            if (this.authenticationProviders.containsKey(name) && (response = (provider = this.authenticationProviders.get(name)).loadAuthenticationPlugIn(name)) == null) {
                this.authenticationProviders.remove(name);
            }
            if (response == null) {
                block3: for (String current : this.plugInNames) {
                    List<PlugInProvider> providerList = this.loadPlugInProvider(current);
                    for (PlugInProvider currentProvider : providerList) {
                        response = currentProvider.loadAuthenticationPlugIn(name);
                        if (response == null) continue;
                        this.authenticationProviders.put(name, currentProvider);
                        continue block3;
                    }
                }
            }
        }
        if (response == null) {
            throw DomainManagementLogger.ROOT_LOGGER.noAuthenticationPlugInFound(name);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationPlugIn loadAuthorizationPlugIn(String name) {
        AuthorizationPlugIn response = null;
        Map<String, PlugInProvider> map = this.authorizationProviders;
        synchronized (map) {
            PlugInProvider provider;
            if (this.authorizationProviders.containsKey(name) && (response = (provider = this.authorizationProviders.get(name)).loadAuthorizationPlugIn(name)) == null) {
                this.authorizationProviders.remove(name);
            }
            if (response == null) {
                block3: for (String current : this.plugInNames) {
                    List<PlugInProvider> providerList = this.loadPlugInProvider(current);
                    for (PlugInProvider currentProvider : providerList) {
                        response = currentProvider.loadAuthorizationPlugIn(name);
                        if (response == null) continue;
                        this.authorizationProviders.put(name, currentProvider);
                        continue block3;
                    }
                }
            }
        }
        if (response == null) {
            throw DomainManagementLogger.ROOT_LOGGER.noAuthenticationPlugInFound(name);
        }
        return response;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PlugInLoaderService.SERVICE_SUFFIX});
        }

        public static Supplier<PlugInLoaderService> requires(ServiceBuilder<?> sb, String realmName) {
            return sb.requires(ServiceUtil.createServiceName(realmName));
        }
    }
}

