/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

class AuthenticationValidatingHandler
implements OperationStepHandler {
    static final AuthenticationValidatingHandler INSTANCE = new AuthenticationValidatingHandler();

    static ModelNode createOperation(ModelNode operationToValidate) {
        PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
        PathAddress realmPA = null;
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"security-realm".equals(pe.getKey())) continue;
            realmPA = pa.subAddress(0, i + 1);
            break;
        }
        assert (realmPA != null) : "operationToValidate did not have an address that included a security-realm";
        return Util.getEmptyOperation((String)"validate-authentication", (ModelNode)realmPA.toModelNode());
    }

    private AuthenticationValidatingHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource kerberosIdentity;
        String realmName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        if (!AuthenticationValidatingHandler.hasResource(context)) {
            return;
        }
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set children = resource.getChildrenNames("authentication");
        if (children.contains("kerberos") && ((kerberosIdentity = resource.getChild(PathElement.pathElement((String)"server-identity", (String)"kerberos"))) == null || kerberosIdentity.getChildrenNames("keytab").isEmpty())) {
            throw DomainManagementLogger.ROOT_LOGGER.kerberosWithoutKeytab(realmName);
        }
        children.remove("truststore");
        children.remove("local");
        children.remove("kerberos");
        if (children.size() > 1) {
            HashSet<String> invalid = new HashSet<String>(children);
            invalid.remove("truststore");
            throw DomainManagementLogger.ROOT_LOGGER.multipleAuthenticationMechanismsDefined(realmName, invalid);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private static boolean hasResource(OperationContext context) {
        try {
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            return true;
        }
        catch (Resource.NoSuchResourceException nsre) {
            return false;
        }
    }
}

