/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class RbacSanityCheckOperation
implements OperationStepHandler {
    private static final OperationContext.AttachmentKey<RbacSanityCheckOperation> KEY = OperationContext.AttachmentKey.create(RbacSanityCheckOperation.class);
    private static final RbacSanityCheckOperation INSTANCE = new RbacSanityCheckOperation();

    private RbacSanityCheckOperation() {
    }

    public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws OperationFailedException {
                    ModelChecker checker = new ModelChecker(context, context.readResource(PathAddress.EMPTY_ADDRESS));
                    if (checker.isRbacEnabled() && !checker.doRoleMappingsExist()) {
                        throw DomainManagementLogger.ROOT_LOGGER.inconsistentRbacConfiguration();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof OperationFailedException) {
                throw (OperationFailedException)cause;
            }
            throw new OperationFailedException((Throwable)cause);
        }
    }

    public static void addOperation(OperationContext context) {
        RbacSanityCheckOperation added = (RbacSanityCheckOperation)context.getAttachment(KEY);
        if (added == null) {
            if (!context.isNormalServer()) {
                return;
            }
            context.addStep(RbacSanityCheckOperation.createOperation(), (OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
            context.attach(KEY, (Object)INSTANCE);
        }
    }

    private static ModelNode createOperation() {
        ModelNode operation = Util.createEmptyOperation((String)"rbac-sanity-check", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT}));
        return operation;
    }

    private static class ModelChecker {
        private final OperationContext context;
        private final Resource managementResource;
        private ModelNode accessAuthorization;

        private ModelChecker(OperationContext context, Resource managementResource) {
            this.context = context;
            this.managementResource = managementResource;
        }

        boolean isRbacEnabled() throws OperationFailedException {
            ModelNode accessAuthorization = this.getAccessAuthorization();
            String value = AccessAuthorizationResourceDefinition.PROVIDER.resolveModelAttribute(this.context, accessAuthorization).asString().toUpperCase(Locale.ENGLISH);
            return AccessAuthorizationResourceDefinition.Provider.valueOf(value) == AccessAuthorizationResourceDefinition.Provider.RBAC;
        }

        boolean doRoleMappingsExist() throws OperationFailedException {
            Resource authorizationResource = this.managementResource.getChild(PathElement.pathElement((String)"access", (String)"authorization"));
            Set roleNames = authorizationResource.getChildrenNames("role-mapping");
            for (String current : roleNames) {
                Resource roleResource = authorizationResource.getChild(PathElement.pathElement((String)"role-mapping", (String)current));
                ModelNode roleModel = roleResource.getModel();
                if (roleModel.get("include-all").isDefined() && roleModel.require("include-all").asBoolean()) {
                    return true;
                }
                if (roleResource.getChildren("include").size() <= 0) continue;
                return true;
            }
            return false;
        }

        private ModelNode getAccessAuthorization() {
            Resource authorizationResource;
            PathElement pathElement;
            if (this.accessAuthorization == null && this.managementResource.hasChild(pathElement = PathElement.pathElement((String)"access", (String)"authorization")) && (authorizationResource = this.managementResource.getChild(pathElement)).isModelDefined()) {
                this.accessAuthorization = authorizationResource.getModel();
            }
            return this.accessAuthorization;
        }
    }
}

