/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ScopedRoleResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition BASE_ROLE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("base-role", ModelType.STRING).setRestartAllServices()).build();
    private final AttributeDefinition roleAttribute;

    protected ScopedRoleResourceDefinition(PathElement path, ResourceDescriptionResolver resolver, final WritableAuthorizerConfiguration authorizerConfiguration) {
        super(path, resolver);
        this.roleAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_ROLE).setValidator(new ParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                Set standardRoles = authorizerConfiguration.getStandardRoles();
                String specifiedRole = value.asString();
                for (String current : standardRoles) {
                    if (!specifiedRole.equalsIgnoreCase(current)) continue;
                    return;
                }
                throw DomainManagementLogger.ROOT_LOGGER.badBaseRole(specifiedRole);
            }
        })).setCorrector(new ParameterCorrector(){

            public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
                Set standardRoles = authorizerConfiguration.getStandardRoles();
                String specifiedRole = newValue.asString();
                for (String current : standardRoles) {
                    if (!specifiedRole.equalsIgnoreCase(current) || specifiedRole.equals(current)) continue;
                    return new ModelNode(current);
                }
                return newValue;
            }
        })).build();
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        registration.registerReadWriteAttribute(this.roleAttribute, null, ReloadRequiredWriteAttributeHandler.INSTANCE);
    }
}

