/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class PropertiesSubjectSupplemental
extends PropertiesFileLoader
implements Service<SubjectSupplementalService>,
SubjectSupplementalService,
SubjectSupplemental {
    private static final String SERVICE_SUFFIX = "properties_authorization";
    private static final String COMMA = ",";
    private final String realmName;

    public PropertiesSubjectSupplemental(String realmName, String path, String relativeTo) {
        super(path, relativeTo);
        this.realmName = realmName;
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    @Override
    public void supplementSubject(Subject subject) throws IOException {
        Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
        Set<Principal> principals = subject.getPrincipals();
        Properties properties = this.getProperties();
        for (RealmUser current : users) {
            principals.addAll(this.loadGroups(properties, current));
        }
    }

    private Set<RealmGroup> loadGroups(Properties properties, RealmUser user) {
        Set<RealmGroup> response;
        String groupString = properties.getProperty(user.getName(), "").trim();
        if (groupString.length() > 0) {
            String[] groups = groupString.split(COMMA);
            response = new HashSet<RealmGroup>(groups.length);
            for (String current : groups) {
                String cleaned = current.trim();
                if (cleaned.length() <= 0) continue;
                RealmGroup newGroup = new RealmGroup(this.realmName, cleaned);
                DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for user '%s'.", newGroup, user);
                response.add(newGroup);
            }
        } else {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No groups found for user '%s' in properties file.", user);
            response = Collections.emptySet();
        }
        return response;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PropertiesSubjectSupplemental.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            try {
                Properties groups = PropertiesSubjectSupplemental.this.getProperties();
                String name = principal.getName();
                return new RealmIdentityImpl(name, groups.getProperty(name, "").trim());
            }
            catch (IOException e) {
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final String name;
            private final String groups;

            private RealmIdentityImpl(String name, String groups) {
                this.name = name;
                this.groups = groups;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                if (this.groups.length() > 0) {
                    String[] temp = this.groups.split(PropertiesSubjectSupplemental.COMMA);
                    HashSet<String> groups = new HashSet<String>(temp.length);
                    for (String current : temp) {
                        String cleaned = current.trim();
                        if (cleaned.length() <= 0) continue;
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for identity '%s'.", cleaned, this.name);
                        groups.add(cleaned);
                    }
                    HashMap groupsAttributeMap = new HashMap();
                    groupsAttributeMap.put("GROUPS", Collections.unmodifiableSet(groups));
                    return AuthorizationIdentity.basicIdentity((Attributes)new MapAttributes(Collections.unmodifiableMap(groupsAttributeMap)));
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("No groups found for identity '%s' in properties file.", this.name);
                return AuthorizationIdentity.EMPTY;
            }
        }
    }
}

