/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class UserLdapCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final LdapSearcherCache.AttachmentKey<PasswordCredential> PASSWORD_KEY = LdapSearcherCache.AttachmentKey.create(PasswordCredential.class);
    private static final String SERVICE_SUFFIX = "ldap";
    public static final String DEFAULT_USER_DN = "dn";
    private final InjectedValue<LdapConnectionManager> connectionManager = new InjectedValue();
    private final InjectedValue<LdapSearcherCache<LdapEntry, String>> userSearcherInjector = new InjectedValue();
    private final boolean allowEmptyPassword;
    private final boolean shareConnection;
    protected final int searchTimeLimit = 10000;

    public UserLdapCallbackHandler(boolean allowEmptyPassword, boolean shareConnection) {
        this.allowEmptyPassword = allowEmptyPassword;
        this.shareConnection = shareConnection;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.PLAIN;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return new LdapCallbackHandler(sharedState);
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<LdapConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    public Injector<LdapSearcherCache<LdapEntry, String>> getLdapUserSearcherInjector() {
        return this.userSearcherInjector;
    }

    private LdapConnectionHandler createLdapConnectionHandler() {
        LdapConnectionManager connectionManager = (LdapConnectionManager)this.connectionManager.getValue();
        return LdapConnectionHandler.newInstance(connectionManager);
    }

    private static boolean verifyPassword(LdapConnectionHandler ldapConnectionHandler, LdapSearcherCache.SearchResult<LdapEntry> searchResult, String username, String password, Map<String, Object> sharedState) {
        LdapEntry ldapEntry = searchResult.getResult();
        PasswordCredential cachedCredential = searchResult.getAttachment(PASSWORD_KEY);
        if (cachedCredential != null) {
            if (cachedCredential.verify(password)) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Password verified for user '%s' (using cached password)", username);
                sharedState.put(LdapEntry.class.getName(), ldapEntry);
                if (!username.equals(ldapEntry.getSimpleName())) {
                    sharedState.put(SecurityRealmService.LOADED_USERNAME_KEY, ldapEntry.getSimpleName());
                }
                return true;
            }
            DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user (using cached password) '%s'", username);
            return false;
        }
        try {
            LdapConnectionHandler verificationHandler = ldapConnectionHandler;
            URI referralUri = ldapEntry.getReferralUri();
            if (referralUri != null) {
                verificationHandler = verificationHandler.findForReferral(referralUri);
            }
            if (verificationHandler != null) {
                verificationHandler.verifyIdentity(ldapEntry.getDistinguishedName(), password);
                DomainManagementLogger.SECURITY_LOGGER.tracef("Password verified for user '%s' (using connection attempt)", username);
                searchResult.attach(PASSWORD_KEY, new PasswordCredential(password));
                sharedState.put(LdapEntry.class.getName(), ldapEntry);
                if (!username.equals(ldapEntry.getSimpleName())) {
                    sharedState.put(SecurityRealmService.LOADED_USERNAME_KEY, ldapEntry.getSimpleName());
                }
                return true;
            }
            DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user '%s', no connection for referral '%s'", username, referralUri.toString());
            return false;
        }
        catch (Exception e) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user (using connection attempt) '%s'", username);
            return false;
        }
    }

    private void safeClose(LdapConnectionHandler ldapConnectionHandler) {
        try {
            if (ldapConnectionHandler != null) {
                ldapConnectionHandler.close();
            }
        }
        catch (IOException e) {
            DomainManagementLogger.SECURITY_LOGGER.trace("Unable to close ldapConnectionHandler", e);
        }
    }

    private static final class PasswordCredential {
        private final String password;

        private PasswordCredential(String password) {
            this.password = password;
        }

        private boolean verify(String password) {
            return this.password.equals(password);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{UserLdapCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            String name = principal.getName();
            if (name.length() == 0) {
                return RealmIdentity.NON_EXISTENT;
            }
            LdapConnectionHandler ldapConnectionHandler = UserLdapCallbackHandler.this.createLdapConnectionHandler();
            try {
                LdapSearcherCache.SearchResult searchResult = ((LdapSearcherCache)UserLdapCallbackHandler.this.userSearcherInjector.getValue()).search(ldapConnectionHandler, name);
                return new RealmIdentityImpl(principal, ldapConnectionHandler, searchResult, SecurityRealmService.SharedStateSecurityRealm.getSharedState());
            }
            catch (IllegalStateException e) {
                UserLdapCallbackHandler.this.safeClose(ldapConnectionHandler);
                return RealmIdentity.NON_EXISTENT;
            }
            catch (IOException | NamingException e) {
                UserLdapCallbackHandler.this.safeClose(ldapConnectionHandler);
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final Principal principal;
            private final LdapConnectionHandler ldapConnectionHandler;
            private final LdapSearcherCache.SearchResult<LdapEntry> searchResult;
            private final Map<String, Object> sharedState;

            private RealmIdentityImpl(Principal principal, LdapConnectionHandler ldapConnectionHandler, LdapSearcherCache.SearchResult<LdapEntry> searchResult, Map<String, Object> sharedState) {
                this.principal = principal;
                this.ldapConnectionHandler = ldapConnectionHandler;
                this.searchResult = searchResult;
                this.sharedState = sharedState != null ? sharedState : new HashMap();
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    PasswordGuessEvidence passwordGuessEvidence = (PasswordGuessEvidence)evidence;
                    char[] guess = passwordGuessEvidence.getGuess();
                    if (guess == null || !UserLdapCallbackHandler.this.allowEmptyPassword && guess.length == 0) {
                        DomainManagementLogger.SECURITY_LOGGER.trace("No password or 0 length password supplied.");
                        return false;
                    }
                    boolean result = UserLdapCallbackHandler.verifyPassword(this.ldapConnectionHandler, this.searchResult, this.principal.getName(), new String(guess), this.sharedState);
                    if (UserLdapCallbackHandler.this.shareConnection && result) {
                        this.sharedState.put(LdapConnectionHandler.class.getName(), this.ldapConnectionHandler);
                    }
                    return result;
                }
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            public void dispose() {
                UserLdapCallbackHandler.this.safeClose(this.ldapConnectionHandler);
            }
        }
    }

    private class LdapCallbackHandler
    implements CallbackHandler {
        private final Map<String, Object> sharedState;

        private LdapCallbackHandler(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            char[] guess;
            if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
                String authorizationId;
                AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
                String authenticationId = acb.getAuthenticationID();
                boolean authorized = authenticationId.equals(authorizationId = acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", authenticationId, authorizationId);
                }
                acb.setAuthorized(authorized);
                return;
            }
            EvidenceVerifyCallback evidenceVerifyCallback = null;
            String username = null;
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    username = ((NameCallback)current).getDefaultName();
                    continue;
                }
                if (current instanceof RealmCallback) continue;
                if (current instanceof EvidenceVerifyCallback) {
                    evidenceVerifyCallback = (EvidenceVerifyCallback)current;
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
            if (username == null || username.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No username or 0 length username supplied.");
                throw DomainManagementLogger.ROOT_LOGGER.noUsername();
            }
            if (evidenceVerifyCallback == null || evidenceVerifyCallback.getEvidence() == null) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password to verify.");
                throw DomainManagementLogger.ROOT_LOGGER.noPassword();
            }
            String password = evidenceVerifyCallback.getEvidence() instanceof PasswordGuessEvidence ? ((guess = ((PasswordGuessEvidence)evidenceVerifyCallback.getEvidence()).getGuess()) != null ? new String(guess) : null) : null;
            if (password == null || !UserLdapCallbackHandler.this.allowEmptyPassword && password.length() == 0) {
                DomainManagementLogger.SECURITY_LOGGER.trace("No password or 0 length password supplied.");
                throw DomainManagementLogger.ROOT_LOGGER.noPassword();
            }
            LdapConnectionHandler lch = UserLdapCallbackHandler.this.createLdapConnectionHandler();
            try {
                LdapSearcherCache.SearchResult searchResult = ((LdapSearcherCache)UserLdapCallbackHandler.this.userSearcherInjector.getValue()).search(lch, username);
                evidenceVerifyCallback.setVerified(UserLdapCallbackHandler.verifyPassword(lch, searchResult, username, password, this.sharedState));
            }
            catch (Exception e) {
                DomainManagementLogger.SECURITY_LOGGER.trace("Unable to verify identity.", e);
                throw DomainManagementLogger.ROOT_LOGGER.cannotPerformVerification(e);
            }
            finally {
                if (UserLdapCallbackHandler.this.shareConnection && lch != null && evidenceVerifyCallback != null && evidenceVerifyCallback.isVerified()) {
                    this.sharedState.put(LdapConnectionHandler.class.getName(), lch);
                } else {
                    lch.close();
                }
            }
        }
    }
}

