/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractKeyManagerService;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

class FileKeyManagerService
extends AbstractKeyManagerService {
    public static final String SHA_256_WITH_RSA = "SHA256withRSA";
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private volatile String provider;
    private volatile String path;
    private volatile String relativeTo;
    private volatile char[] keystorePassword;
    private volatile char[] keyPassword;
    private volatile String alias;
    private volatile FileKeystore keyStore;
    private String autoGenerateCertHostName;

    FileKeyManagerService(String provider, String path, String relativeTo, char[] keystorePassword, char[] keyPassword, String alias, String autoGenerateCertHostName) {
        super(keystorePassword, keyPassword);
        this.provider = provider;
        this.path = path;
        this.relativeTo = relativeTo;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.alias = alias;
        this.autoGenerateCertHostName = autoGenerateCertHostName;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    @Override
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Override
    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.keyStore = null;
    }

    @Override
    protected boolean isLazy() {
        return this.keyStore == null;
    }

    @Override
    protected KeyStore loadKeyStore(boolean startup) {
        try {
            File path;
            if (this.keyStore != null) {
                if (this.keyStore.isModified()) {
                    this.keyStore.load();
                }
                return this.keyStore.getKeyStore();
            }
            String file = this.path;
            if (this.relativeTo != null) {
                PathManager pm = (PathManager)this.pathManager.getValue();
                file = pm.resolveRelativePathEntry(file, this.relativeTo);
                pm.registerCallback(this.relativeTo, new PathManager.Callback(){

                    public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                        if (!eventContext.isResourceServiceRestartAllowed()) {
                            eventContext.reloadRequired();
                        }
                    }

                    public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                    }
                }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
            }
            if (!(path = new File(file)).exists() && this.autoGenerateCertHostName != null) {
                if (startup) {
                    DomainManagementLogger.SECURITY_LOGGER.keystoreWillBeCreated(file, this.autoGenerateCertHostName);
                    return null;
                }
                this.generateFileKeyStore(path);
            }
            this.keyStore = FileKeystore.newKeyStore(this.provider, file, this.keystorePassword, this.keyPassword, this.alias);
            this.keyStore.load();
            return this.keyStore.getKeyStore();
        }
        catch (StartException e) {
            throw new IllegalStateException(e);
        }
    }

    private void generateFileKeyStore(File path) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, new SecureRandom());
            KeyPair pair = keyGen.generateKeyPair();
            X509Certificate cert = this.generateCertificate(pair);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, this.keystorePassword);
            Certificate[] chain = new X509Certificate[]{cert};
            keyStore.setKeyEntry(this.alias, pair.getPrivate(), this.keyPassword, chain);
            try (FileOutputStream stream = new FileOutputStream(path);){
                keyStore.store(stream, this.keystorePassword);
            }
            DomainManagementLogger.SECURITY_LOGGER.keystoreHasBeenCreated(path.toString(), FileKeyManagerService.getSha1Fingerprint(cert, "SHA-1"), FileKeyManagerService.getSha1Fingerprint(cert, "SHA-256"));
        }
        catch (Exception e) {
            throw DomainManagementLogger.SECURITY_LOGGER.failedToGenerateSelfSignedCertificate(e);
        }
    }

    X509Certificate generateCertificate(KeyPair pair) throws Exception {
        PrivateKey privkey = pair.getPrivate();
        X509CertificateBuilder builder = new X509CertificateBuilder();
        Date from = new Date();
        Date to = new Date(from.getTime() + 315360000000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        builder.setNotValidAfter(ZonedDateTime.ofInstant(Instant.ofEpochMilli(to.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setNotValidBefore(ZonedDateTime.ofInstant(Instant.ofEpochMilli(from.getTime()), TimeZone.getDefault().toZoneId()));
        builder.setSerialNumber(sn);
        X500Principal owner = new X500Principal("CN=" + this.autoGenerateCertHostName);
        builder.setSubjectDn(owner);
        builder.setIssuerDn(owner);
        builder.setPublicKey(pair.getPublic());
        builder.setVersion(3);
        builder.setSignatureAlgorithmName(SHA_256_WITH_RSA);
        builder.setSigningKey(privkey);
        return builder.build();
    }

    private static String getSha1Fingerprint(X509Certificate cert, String algo) throws Exception {
        MessageDigest md = MessageDigest.getInstance(algo);
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return FileKeyManagerService.hexify(digest);
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                buf.append(":");
            }
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public Injector<PathManager> getPathManagerInjector() {
        return this.pathManager;
    }
}

