/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslServerFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmSubjectUserInfo;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.KeytabIdentityFactoryService;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedSetValue;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;
import org.wildfly.security.http.util.SortedServerMechanismFactory;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.sasl.util.FilterMechanismSaslServerFactory;
import org.wildfly.security.sasl.util.PropertiesSaslServerFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.SortedMechanismSaslServerFactory;

public class SecurityRealmService
implements Service<SecurityRealm>,
SecurityRealm {
    private static final String[] ADDITIONAL_PERMISSION = new String[]{"org.wildfly.transaction.client.RemoteTransactionPermission", "org.jboss.ejb.client.RemoteEJBPermission"};
    public static final String LOADED_USERNAME_KEY = SecurityRealmService.class.getName() + ".LOADED_USERNAME";
    public static final String SKIP_GROUP_LOADING_KEY = SecurityRealmService.class.getName() + ".SKIP_GROUP_LOADING";
    public static final Oid KERBEROS_V5;
    public static final Oid SPNEGO;
    private final InjectedValue<SubjectSupplementalService> subjectSupplemental = new InjectedValue();
    private final InjectedValue<SSLContext> sslContext = new InjectedValue();
    private final InjectedValue<CallbackHandlerFactory> secretCallbackFactory = new InjectedValue();
    private final InjectedValue<KeytabIdentityFactoryService> keytabFactory = new InjectedValue();
    private final InjectedSetValue<CallbackHandlerService> callbackHandlerServices = new InjectedSetValue();
    private final InjectedValue<String> tmpDirPath = new InjectedValue();
    private final String name;
    private final boolean mapGroupsToRoles;
    private final Map<AuthMechanism, CallbackHandlerService> registeredServices = new HashMap<AuthMechanism, CallbackHandlerService>();
    private SaslAuthenticationFactory saslAuthenticationFactory = null;
    private HttpAuthenticationFactory httpAuthenticationFactory = null;

    public SecurityRealmService(String name, boolean mapGroupsToRoles) {
        this.name = name;
        this.mapGroupsToRoles = mapGroupsToRoles;
    }

    public void start(StartContext context) throws StartException {
        DomainManagementLogger.ROOT_LOGGER.debugf("Starting '%s' Security Realm Service", this.name);
        for (CallbackHandlerService current : this.callbackHandlerServices.getValue()) {
            AuthMechanism mechanism = current.getPreferredMechanism();
            if (this.registeredServices.containsKey((Object)mechanism)) {
                this.registeredServices.clear();
                throw DomainManagementLogger.ROOT_LOGGER.multipleCallbackHandlerForMechanism(mechanism.name());
            }
            this.registeredServices.put(mechanism, current);
        }
        HashMap<String, String> mechanismConfiguration = new HashMap<String, String>();
        HashMap<AuthMechanism, MechanismConfiguration> configurationMap = new HashMap<AuthMechanism, MechanismConfiguration>();
        SubjectSupplementalService subjectSupplementalService = (SubjectSupplementalService)this.subjectSupplemental.getOptionalValue();
        org.wildfly.security.auth.server.SecurityRealm authorizationRealm = subjectSupplementalService != null ? subjectSupplementalService.getElytronSecurityRealm() : null;
        SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
        for (Map.Entry<AuthMechanism, CallbackHandlerService> currentRegistration : this.registeredServices.entrySet()) {
            CallbackHandlerService currentService = currentRegistration.getValue();
            org.wildfly.security.auth.server.SecurityRealm elytronRealm = currentService.getElytronSecurityRealm();
            if (elytronRealm == null) continue;
            AuthMechanism mechanism = currentRegistration.getKey();
            domainBuilder.addRealm(mechanism.toString(), (org.wildfly.security.auth.server.SecurityRealm)(currentService.allowGroupLoading() && authorizationRealm != null ? new SharedStateSecurityRealm((org.wildfly.security.auth.server.SecurityRealm)new AggregateSecurityRealm(elytronRealm, authorizationRealm)) : elytronRealm)).setRoleDecoder(RoleDecoder.simple((String)"GROUPS")).build();
            Function<Principal, Principal> preRealmRewriter = p -> new RealmUser(this.name, p.getName());
            preRealmRewriter = preRealmRewriter.andThen(currentService.getPrincipalMapper());
            configurationMap.put(mechanism, MechanismConfiguration.builder().setPreRealmRewriter(preRealmRewriter).setRealmMapper((p, e) -> mechanism.toString()).addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName(this.name).build()).build());
            for (Map.Entry<String, String> currentOption : currentRegistration.getValue().getConfigurationOptions().entrySet()) {
                switch (currentOption.getKey()) {
                    case "org.jboss.as.domain.management.local.default_user": {
                        mechanismConfiguration.put("wildfly.sasl.local-user.default-user", currentOption.getValue());
                    }
                }
            }
        }
        mechanismConfiguration.put("jboss.sasl.local-user.challenge-path", this.getAuthDir((String)this.tmpDirPath.getValue()));
        mechanismConfiguration.put("wildfly.sasl.digest.alternative_protocols", "remoting");
        domainBuilder.addRealm("EMPTY", org.wildfly.security.auth.server.SecurityRealm.EMPTY_REALM).build();
        domainBuilder.setDefaultRealmName("EMPTY");
        PermissionVerifier permissionVerifier = SecurityRealmService.createPermissionVerifier();
        domainBuilder.setPermissionMapper((permissionMappable, roles) -> permissionVerifier);
        SecurityDomain securityDomain = domainBuilder.build();
        MechanismConfigurationSelector mcs = mi -> {
            AuthMechanism mechanism = this.toAuthMechanism(mi.getMechanismType(), mi.getMechanismName());
            if (mechanism != null) {
                MechanismConfiguration resolved = (MechanismConfiguration)configurationMap.get((Object)mechanism);
                if (AuthMechanism.KERBEROS.equals((Object)mechanism)) {
                    MechanismConfiguration.Builder builder = MechanismConfiguration.builder().setPreRealmRewriter(resolved.getPreRealmRewriter()).setRealmMapper(resolved.getRealmMapper());
                    resolved.getMechanismRealmNames().forEach(s -> builder.addMechanismRealm(resolved.getMechanismRealmConfiguration(s)));
                    String protocol = mi.getMechanismType().equals("HTTP") ? "HTTP" : mi.getProtocol();
                    builder.setServerCredential(() -> this.getGSSKerberosCredential(protocol, mi.getHostName()));
                    return builder.build();
                }
                return resolved;
            }
            return null;
        };
        HttpAuthenticationFactory.Builder httpBuilder = HttpAuthenticationFactory.builder();
        httpBuilder.setSecurityDomain(securityDomain);
        WildFlyElytronProvider elytronProvider = new WildFlyElytronProvider();
        SecurityProviderServerMechanismFactory httpServerFactory = new SecurityProviderServerMechanismFactory(() -> SecurityRealmService.lambda$start$6((Provider)elytronProvider));
        httpServerFactory = new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        httpServerFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory, s -> {
            AuthMechanism mechanism = this.toAuthMechanism("HTTP", (String)s);
            return mechanism != null && configurationMap.containsKey((Object)mechanism);
        });
        httpServerFactory = new SortedServerMechanismFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory, SecurityRealmService::compare);
        httpBuilder.setFactory((HttpServerAuthenticationMechanismFactory)httpServerFactory);
        httpBuilder.setMechanismConfigurationSelector(mcs);
        this.httpAuthenticationFactory = httpBuilder.build();
        SaslAuthenticationFactory.Builder saslBuilder = SaslAuthenticationFactory.builder();
        saslBuilder.setSecurityDomain(securityDomain);
        SecurityProviderSaslServerFactory saslServerFactory = new SecurityProviderSaslServerFactory(() -> SecurityRealmService.lambda$start$8((Provider)elytronProvider));
        saslServerFactory = new FilterMechanismSaslServerFactory((SaslServerFactory)saslServerFactory, s -> {
            AuthMechanism mechanism = this.toAuthMechanism("SASL", (String)s);
            return mechanism != null && configurationMap.containsKey((Object)mechanism);
        });
        saslServerFactory = new PropertiesSaslServerFactory((SaslServerFactory)saslServerFactory, mechanismConfiguration);
        saslServerFactory = new SortedMechanismSaslServerFactory((SaslServerFactory)saslServerFactory, SecurityRealmService::compare);
        saslBuilder.setFactory((SaslServerFactory)saslServerFactory);
        saslBuilder.setMechanismConfigurationSelector(mcs);
        this.saslAuthenticationFactory = saslBuilder.build();
    }

    private static PermissionVerifier createPermissionVerifier() {
        LoginPermission permissionVerifier = LoginPermission.getInstance();
        for (String permissionName : ADDITIONAL_PERMISSION) {
            try {
                Permission permission = PermissionUtil.createPermission((ClassLoader)SecurityRealmService.class.getClassLoader(), (String)permissionName, null, null);
                permissionVerifier = permissionVerifier.or(PermissionVerifier.from((Permission)permission));
            }
            catch (Exception e) {
                DomainManagementLogger.ROOT_LOGGER.tracef(e, "Unable to create permission '%s'", permissionName);
            }
        }
        return permissionVerifier;
    }

    private AuthMechanism toAuthMechanism(String mechanismType, String mechanismName) {
        switch (mechanismType) {
            case "SASL": {
                switch (mechanismName) {
                    case "DIGEST-MD5": {
                        return AuthMechanism.DIGEST;
                    }
                    case "EXTERNAL": {
                        return AuthMechanism.CLIENT_CERT;
                    }
                    case "JBOSS-LOCAL-USER": {
                        return AuthMechanism.LOCAL;
                    }
                    case "GSSAPI": {
                        return AuthMechanism.KERBEROS;
                    }
                    case "PLAIN": {
                        return AuthMechanism.PLAIN;
                    }
                }
                break;
            }
            case "HTTP": {
                switch (mechanismName) {
                    case "CLIENT_CERT": {
                        return AuthMechanism.CLIENT_CERT;
                    }
                    case "DIGEST": {
                        return AuthMechanism.DIGEST;
                    }
                    case "SPNEGO": {
                        return AuthMechanism.KERBEROS;
                    }
                    case "BASIC": {
                        return AuthMechanism.PLAIN;
                    }
                }
            }
        }
        return null;
    }

    private static int compare(String nameOne, String nameTwo) {
        return SecurityRealmService.toPriority(nameTwo) - SecurityRealmService.toPriority(nameOne);
    }

    private static int toPriority(String name) {
        switch (name) {
            case "JBOSS-LOCAL-USER": {
                return 10;
            }
            case "GSSAPI": 
            case "SPNEGO": {
                return 5;
            }
        }
        return 0;
    }

    private String getAuthDir(String path) throws StartException {
        File authDir = new File(path, "auth");
        if (authDir.exists()) {
            if (!authDir.isDirectory()) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToCreateTempDirForAuthTokensFileExists();
            }
        } else if (!authDir.mkdirs()) {
            if (!authDir.isDirectory()) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToCreateAuthDir(authDir.getAbsolutePath());
            }
        } else {
            authDir.setWritable(false, false);
            authDir.setWritable(true, true);
            authDir.setReadable(false, false);
            authDir.setReadable(true, true);
            authDir.setExecutable(false, false);
            authDir.setExecutable(true, true);
        }
        return authDir.getAbsolutePath();
    }

    public void stop(StopContext context) {
        DomainManagementLogger.ROOT_LOGGER.debugf("Stopping '%s' Security Realm Service", this.name);
        this.registeredServices.clear();
        this.saslAuthenticationFactory = null;
        this.httpAuthenticationFactory = null;
    }

    public SecurityRealmService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<AuthMechanism> getSupportedAuthenticationMechanisms() {
        TreeSet<AuthMechanism> response = new TreeSet<AuthMechanism>();
        response.addAll(this.registeredServices.keySet());
        return response;
    }

    @Override
    public Map<String, String> getMechanismConfig(AuthMechanism mechanism) {
        CallbackHandlerService service = this.getCallbackHandlerService(mechanism);
        return service.getConfigurationOptions();
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        for (CallbackHandlerService current : this.registeredServices.values()) {
            if (!current.isReadyForHttpChallenge()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AuthorizingCallbackHandler getAuthorizingCallbackHandler(AuthMechanism mechanism) {
        final CallbackHandlerService handlerService = this.getCallbackHandlerService(mechanism);
        final HashMap sharedState = new HashMap();
        return new AuthorizingCallbackHandler(){
            CallbackHandler handler;
            Map<String, String> options;
            final boolean subjectCallbackSupported;
            Subject subject;
            {
                this.handler = handlerService.getCallbackHandler(sharedState);
                this.options = handlerService.getConfigurationOptions();
                this.subjectCallbackSupported = this.options.containsKey("org.jboss.as.domain.management.subject_callback_supported") ? Boolean.parseBoolean(this.options.get("org.jboss.as.domain.management.subject_callback_supported")) : false;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (this.subjectCallbackSupported && this.notAuthorizeCallback(callbacks)) {
                    Callback[] newCallbacks = new Callback[callbacks.length + 1];
                    System.arraycopy(callbacks, 0, newCallbacks, 0, callbacks.length);
                    SubjectCallback subjectCallBack = new SubjectCallback();
                    newCallbacks[newCallbacks.length - 1] = subjectCallBack;
                    this.handler.handle(newCallbacks);
                    this.subject = subjectCallBack.getSubject();
                } else {
                    this.handler.handle(callbacks);
                }
            }

            private boolean notAuthorizeCallback(Callback[] callbacks) {
                return !(callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback);
            }

            @Override
            public SubjectUserInfo createSubjectUserInfo(Collection<Principal> userPrincipals) throws IOException {
                Object skipGroupLoading;
                Subject subject = this.subject == null ? new Subject() : this.subject;
                Set<Principal> allPrincipals = subject.getPrincipals();
                Object ru = null;
                if (sharedState.containsKey(LOADED_USERNAME_KEY)) {
                    ru = new RealmUser(SecurityRealmService.this.getName(), (String)sharedState.get(LOADED_USERNAME_KEY));
                } else {
                    for (Principal userPrincipal : userPrincipals) {
                        if (!(userPrincipal instanceof RealmUser)) continue;
                        ru = userPrincipal;
                        break;
                    }
                }
                for (Principal userPrincipal : userPrincipals) {
                    if (userPrincipal instanceof RealmUser) continue;
                    allPrincipals.add(userPrincipal);
                    if (ru != null) continue;
                    ru = new RealmUser(SecurityRealmService.this.name, userPrincipal.getName());
                }
                if (ru != null) {
                    allPrincipals.add((Principal)ru);
                }
                if ((skipGroupLoading = sharedState.get(SKIP_GROUP_LOADING_KEY)) == null || !Boolean.parseBoolean(skipGroupLoading.toString())) {
                    SubjectSupplementalService subjectSupplementalService = (SubjectSupplementalService)SecurityRealmService.this.subjectSupplemental.getOptionalValue();
                    if (subjectSupplementalService != null) {
                        SubjectSupplemental subjectSupplemental = subjectSupplementalService.getSubjectSupplemental(sharedState);
                        subjectSupplemental.supplementSubject(subject);
                    }
                    if (SecurityRealmService.this.mapGroupsToRoles) {
                        Set<RealmGroup> groups = subject.getPrincipals(RealmGroup.class);
                        HashSet<RealmRole> roles = new HashSet<RealmRole>(groups.size());
                        for (RealmGroup current : groups) {
                            roles.add(new RealmRole(current.getName()));
                        }
                        subject.getPrincipals().addAll(roles);
                    }
                }
                return new RealmSubjectUserInfo(subject);
            }
        };
    }

    private CallbackHandlerService getCallbackHandlerService(AuthMechanism mechanism) {
        if (this.registeredServices.containsKey((Object)mechanism)) {
            return this.registeredServices.get((Object)mechanism);
        }
        for (CallbackHandlerService current : this.registeredServices.values()) {
            if (!current.getSupplementaryMechanisms().contains((Object)mechanism)) continue;
            return current;
        }
        throw DomainManagementLogger.ROOT_LOGGER.noCallbackHandlerForMechanism(mechanism.toString(), this.name);
    }

    @Override
    public SubjectIdentity getSubjectIdentity(String protocol, String forHost) {
        KeytabIdentityFactoryService kifs = (KeytabIdentityFactoryService)this.keytabFactory.getOptionalValue();
        return kifs != null ? kifs.getSubjectIdentity(protocol, forHost) : null;
    }

    @Override
    public SaslAuthenticationFactory getSaslAuthenticationFactory() {
        return this.saslAuthenticationFactory;
    }

    @Override
    public HttpAuthenticationFactory getHttpAuthenticationFactory() {
        return this.httpAuthenticationFactory;
    }

    public InjectedValue<SubjectSupplementalService> getSubjectSupplementalInjector() {
        return this.subjectSupplemental;
    }

    public InjectedValue<SSLContext> getSSLContextInjector() {
        return this.sslContext;
    }

    public InjectedValue<CallbackHandlerFactory> getSecretCallbackFactory() {
        return this.secretCallbackFactory;
    }

    public InjectedValue<KeytabIdentityFactoryService> getKeytabIdentityFactoryInjector() {
        return this.keytabFactory;
    }

    public InjectedSetValue<CallbackHandlerService> getCallbackHandlerService() {
        return this.callbackHandlerServices;
    }

    public Injector<String> getTmpDirPathInjector() {
        return this.tmpDirPath;
    }

    @Override
    public SSLContext getSSLContext() {
        return (SSLContext)this.sslContext.getOptionalValue();
    }

    @Override
    public CallbackHandlerFactory getSecretCallbackHandlerFactory() {
        return (CallbackHandlerFactory)this.secretCallbackFactory.getOptionalValue();
    }

    private GSSKerberosCredential getGSSKerberosCredential(String protocol, String forHost) throws GeneralSecurityException {
        SubjectIdentity subjectIdentity = this.getSubjectIdentity(protocol, forHost);
        if (subjectIdentity == null) {
            throw DomainManagementLogger.ROOT_LOGGER.noSubjectIdentityForProtocolAndHost(protocol, forHost);
        }
        GSSManager manager = GSSManager.getInstance();
        try {
            GSSCredential gssCredential = Subject.doAs(subjectIdentity.getSubject(), () -> manager.createCredential(null, 0, new Oid[]{KERBEROS_V5, SPNEGO}, 2));
            return new GSSKerberosCredential(gssCredential);
        }
        catch (PrivilegedActionException e) {
            throw new GeneralSecurityException(e.getCause());
        }
    }

    private static /* synthetic */ Provider[] lambda$start$8(Provider elytronProvider) {
        return new Provider[]{elytronProvider};
    }

    private static /* synthetic */ Provider[] lambda$start$6(Provider elytronProvider) {
        return new Provider[]{elytronProvider};
    }

    static {
        try {
            KERBEROS_V5 = new Oid("1.2.840.113554.1.2.2");
            SPNEGO = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to initialise Oid", e);
        }
    }

    static class SharedStateSecurityRealm
    implements org.wildfly.security.auth.server.SecurityRealm {
        private static ThreadLocal<Map<String, Object>> sharedStateLocal = new ThreadLocal();
        private final org.wildfly.security.auth.server.SecurityRealm wrapped;

        public SharedStateSecurityRealm(org.wildfly.security.auth.server.SecurityRealm wrapped) {
            this.wrapped = wrapped;
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            try {
                sharedStateLocal.set(new HashMap());
                RealmIdentity realmIdentity = this.wrapped.getRealmIdentity(principal);
                return realmIdentity;
            }
            finally {
                sharedStateLocal.remove();
            }
        }

        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            try {
                sharedStateLocal.set(new HashMap());
                RealmIdentity realmIdentity = this.wrapped.getRealmIdentity(evidence);
                return realmIdentity;
            }
            finally {
                sharedStateLocal.remove();
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.wrapped.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.wrapped.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        static Map<String, Object> getSharedState() {
            return sharedStateLocal.get();
        }
    }
}

