/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Arrays;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractFileAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING).setAllowNull(true)).setMinSize(1)).build();
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FORMATTER, PATH, RELATIVE_TO, MAX_FAILURE_COUNT};

    public AbstractFileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(auditLogger, pathManager, pathElement, descriptionResolver, addHandler, removeHandler);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler write = this.getWriteAttributeHandler(this.auditLogger, this.pathManager, ATTRIBUTES);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    protected abstract AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler getWriteAttributeHandler(ManagedAuditLogger var1, PathManagerService var2, AttributeDefinition ... var3);

    protected static <T> T[] joinArrays(T[] array1, T[] array2) {
        if (array2 == null) {
            return array1;
        }
        if (array1 == null) {
            return array2;
        }
        T[] joinedArrays = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, joinedArrays, array1.length, array2.length);
        return joinedArrays;
    }

    protected static abstract class AbstractFileAuditLogHandlerWriteAttributeHandler
    extends AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler {
        public AbstractFileAuditLogHandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
            super(auditLogger, pathManager, attributeDefinitions);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected abstract AbstractFileAuditLogHandler createHandler(PathManagerService var1, OperationContext var2, ModelNode var3) throws OperationFailedException;

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if (!super.handleApplyAttributeRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder)) {
                this.auditLogger.getUpdater().updateHandler((AuditLogHandler)this.createHandler(this.pathManager, context, operation));
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (!super.handlerRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handback)) {
                this.auditLogger.getUpdater().rollbackChanges();
            }
        }
    }

    protected static abstract class AbstractFileAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        protected final ManagedAuditLogger auditLogger;
        protected final PathManagerService pathManager;

        protected AbstractFileAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes) {
            super(attributes);
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep((context1, operation1) -> {
                HandlerUtil.checkNoOtherHandlerWithTheSameName(context1);
                String formatterName = resource.getModel().get(AuditLogHandlerResourceDefinition.FORMATTER.getName()).asString();
                if (!HandlerUtil.lookForFormatter(context1, context1.getCurrentAddress(), formatterName)) {
                    throw DomainManagementLogger.ROOT_LOGGER.noFormatterCalled(formatterName);
                }
            }, OperationContext.Stage.MODEL);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected abstract AbstractFileAuditLogHandler createHandler(PathManagerService var1, OperationContext var2, ModelNode var3) throws OperationFailedException;

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)this.createHandler(this.pathManager, context, operation));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }
}

