/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;

public interface SecurityRealm {
    public String getName();

    public Set<AuthMechanism> getSupportedAuthenticationMechanisms();

    public Map<String, String> getMechanismConfig(AuthMechanism var1);

    public AuthorizingCallbackHandler getAuthorizingCallbackHandler(AuthMechanism var1);

    public boolean isReadyForHttpChallenge();

    public SSLContext getSSLContext();

    public CallbackHandlerFactory getSecretCallbackHandlerFactory();

    public SubjectIdentity getSubjectIdentity(String var1, String var2);

    public SaslAuthenticationFactory getSaslAuthenticationFactory();

    public HttpAuthenticationFactory getHttpAuthenticationFactory();

    public static final class ServiceUtil {
        private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "security_realm"});

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return BASE_SERVICE_NAME.append(new String[]{realmName});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<SecurityRealm> injector, String realmName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(realmName), SecurityRealm.class, injector);
            return sb;
        }
    }
}

