/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractTrustManagerService;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ProviderTrustManagerService
extends AbstractTrustManagerService {
    private volatile String provider;
    private volatile KeyStore theKeyStore;

    ProviderTrustManagerService(String provider, char[] storePassword) {
        super(storePassword);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(StartContext context) throws StartException {
        try {
            KeyStore theKeyStore = KeyStore.getInstance(this.provider);
            SecurityRealmAddHandler securityRealmAddHandler = SecurityRealmAddHandler.INSTANCE;
            synchronized (securityRealmAddHandler) {
                theKeyStore.load(null, this.resolvePassword());
            }
            this.theKeyStore = theKeyStore;
        }
        catch (KeyStoreException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (CertificateException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (IOException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (Exception e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.theKeyStore = null;
    }

    @Override
    protected KeyStore loadTrustStore() {
        return this.theKeyStore;
    }
}

