/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron.SSLContextResource;
import org.wildfly.extension.elytron.SSLSessionDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SNIContextMatcher;
import org.wildfly.security.ssl.SNISSLContext;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.X509RevocationTrustManager;

class SSLDefinitions {
    private static final BooleanSupplier IS_FIPS = SSLDefinitions.getFipsSupplier();
    static final ServiceUtil<SSLContext> SERVER_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "server-ssl-context", SSLContext.class);
    static final ServiceUtil<SSLContext> CLIENT_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY, "client-ssl-context", SSLContext.class);
    static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.ssl-context")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PRE_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pre-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition POST_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("post-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FINAL_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("final-principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-mapper", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.ssl-context")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-filter", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setValidator((ParameterValidator)new CipherSuiteFilterValidator())).setDefaultValue(new ModelNode("DEFAULT"))).build();
    static final SimpleAttributeDefinition CIPHER_SUITE_NAMES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cipher-suite-names", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setValidator((ParameterValidator)new CipherSuiteNamesValidator())).build();
    private static final String[] ALLOWED_PROTOCOLS = new String[]{"SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    static final StringListAttributeDefinition PROTOCOLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("protocols").setAllowExpression(true)).setMinSize(1)).setRequired(false)).setAllowedValues(ALLOWED_PROTOCOLS)).setValidator((ParameterValidator)new StringValuesValidator(ALLOWED_PROTOCOLS))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WANT_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("want-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition NEED_CLIENT_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("need-client-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHENTICATION_OPTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-optional", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition USE_CIPHER_SUITES_ORDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-cipher-suites-order", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAXIMUM_SESSION_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-session-cache-size", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setValidator((ParameterValidator)new IntRangeValidator(-1))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setValidator((ParameterValidator)new IntRangeValidator(-1))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WRAP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("wrap", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEY_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-manager", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.key-manager", "org.wildfly.security.ssl-context")).setRestartAllServices()).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition TRUST_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-manager", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.trust-manager", "org.wildfly.security.ssl-context")).setRestartAllServices()).setAllowExpression(false)).build();
    static final SimpleAttributeDefinition MAXIMUM_CERT_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-cert-path", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).setRestartAllServices()).build();
    @Deprecated
    static final SimpleAttributeDefinition MAXIMUM_CERT_PATH_CRL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-cert-path", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).setDeprecated(ModelVersion.create((int)8))).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CERTIFICATE_REVOCATION_LIST = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("certificate-revocation-list", new AttributeDefinition[]{FileAttributeDefinitions.PATH, FileAttributeDefinitions.RELATIVE_TO, MAXIMUM_CERT_PATH_CRL}).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RESPONDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("responder", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PREFER_CRLS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefer-crls", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SOFT_FAIL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("soft-fail", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ONLY_LEAF_CERT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("only-leaf-cert", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RESPONDER_CERTIFICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("responder-certificate", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).setRequired(false)).build();
    static final SimpleAttributeDefinition RESPONDER_KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("responder-keystore", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).setRequired(false)).setRequires(new String[]{"responder-certificate"})).build();
    static final ObjectTypeAttributeDefinition OCSP = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("ocsp", new AttributeDefinition[]{RESPONDER, PREFER_CRLS, RESPONDER_CERTIFICATE, RESPONDER_KEYSTORE}).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEFAULT_SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-ssl-context", ModelType.STRING).setCapabilityReference("org.wildfly.security.ssl-context")).setRequired(true)).setRestartAllServices()).build();
    static final MapAttributeDefinition HOST_CONTEXT_MAP = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("host-context-map", ModelType.STRING, true).setMinSize(0)).setAllowExpression(false)).setCapabilityReference("org.wildfly.security.ssl-context")).setMapValidator((ParameterValidator)new HostContextMapValidator())).setRestartAllServices()).build();
    static final SimpleAttributeDefinition GENERATE_SELF_SIGNED_CERTIFICATE_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("generate-self-signed-certificate-host", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    private static final SimpleAttributeDefinition ACTIVE_SESSION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-session-count", ModelType.INT).setStorageRuntime()).build();

    SSLDefinitions() {
    }

    static ResourceDefinition getKeyManagerDefinition() {
        StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("key-manager");
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.key-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final ObjectTypeAttributeDefinition credentialReferenceDefinition = CredentialReference.getAttributeDefinition((boolean)true);
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, credentialReferenceDefinition, GENERATE_SELF_SIGNED_CERTIFICATE_HOST};
        TrivialAddHandler<KeyManager> add = new TrivialAddHandler<KeyManager>(KeyManager.class, attributes, Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
            }

            @Override
            protected TrivialService.ValueSupplier<KeyManager> getValueSupplier(ServiceBuilder<KeyManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithmName = ALGORITHM.resolveModelAttribute(context, model).asStringOrNull();
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                String providersName = providersDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue providersInjector = new InjectedValue();
                if (providersName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providersName), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = keystoreDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ALIAS_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                String algorithm = algorithmName != null ? algorithmName : KeyManagerFactory.getDefaultAlgorithm();
                String generateSelfSignedCertificateHost = GENERATE_SELF_SIGNED_CERTIFICATE_HOST.resolveModelAttribute(context, model).asStringOrNull();
                ModifiableKeyStoreService keyStoreService = SSLDefinitions.getModifiableKeyStoreService(context, keyStoreName);
                ExceptionSupplier credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceDefinition, (ModelNode)model, serviceBuilder);
                DelegatingKeyManager delegatingKeyManager = new DelegatingKeyManager();
                return () -> {
                    char[] password;
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    KeyManagerFactory keyManagerFactory = null;
                    if (providers != null) {
                        for (Provider provider : providers) {
                            if (providerName != null && !providerName.equals(provider.getName())) continue;
                            try {
                                keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider);
                                break;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                // empty catch block
                            }
                        }
                        if (keyManagerFactory == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(KeyManagerFactory.class.getSimpleName(), algorithm);
                        }
                    } else {
                        try {
                            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    try {
                        CredentialSource cs = (CredentialSource)credentialSourceSupplier.get();
                        if (cs == null) {
                            throw new StartException((Throwable)ElytronSubsystemMessages.ROOT_LOGGER.keyStorePasswordCannotBeResolved(keyStoreName));
                        }
                        password = ((ClearPassword)((PasswordCredential)cs.getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword();
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("KeyManager supplying:  providers = %s  provider = %s  algorithm = %s  keyManagerFactory = %s  keyStoreName = %s  aliasFilter = %s  keyStore = %s  keyStoreSize = %d  password (of item) = %b", new Object[]{Arrays.toString(providers), providerName, algorithm, keyManagerFactory, keyStoreName, aliasFilter, keyStore, keyStore.size(), password != null});
                        }
                    }
                    catch (StartException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    if (keyStoreService instanceof KeyStoreService && ((KeyStoreService)keyStoreService).shouldAutoGenerateSelfSignedCertificate(generateSelfSignedCertificateHost)) {
                        ElytronSubsystemMessages.ROOT_LOGGER.selfSignedCertificateWillBeCreated(((KeyStoreService)keyStoreService).getResolvedAbsolutePath(), generateSelfSignedCertificateHost);
                        return new LazyDelegatingKeyManager(keyStoreService, password, keyManagerFactory, generateSelfSignedCertificateHost, aliasFilter);
                    }
                    try {
                        if (SSLDefinitions.initKeyManagerFactory(keyStore, delegatingKeyManager, aliasFilter, password, keyManagerFactory)) {
                            return delegatingKeyManager;
                        }
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
                };
            }

            protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
                CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)credentialReferenceDefinition, (OperationContext)context, (Resource)resource);
            }
        };
        ServiceUtil<KeyManager> KEY_MANAGER_UTIL = ServiceUtil.newInstance(Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY, "key-manager", KeyManager.class);
        return TrivialResourceDefinition.builder().setPathKey("key-manager").setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.KEY_MANAGER_RUNTIME_CAPABILITY).addOperation((OperationDefinition)new SimpleOperationDefinitionBuilder("init", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build(), SSLDefinitions.init(KEY_MANAGER_UTIL)).build();
    }

    static ResourceDefinition getTrustManagerDefinition() {
        StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("trust-manager");
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.trust-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        final SimpleAttributeDefinition keystoreDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEYSTORE).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.trust-manager")).setAllowExpression(false)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALGORITHM, providersDefinition, PROVIDER_NAME, keystoreDefinition, ALIAS_FILTER, CERTIFICATE_REVOCATION_LIST, OCSP, SOFT_FAIL, ONLY_LEAF_CERT, MAXIMUM_CERT_PATH};
        TrivialAddHandler<TrustManager> add = new TrivialAddHandler<TrustManager>(TrustManager.class, attributes, Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<TrustManager> getValueSupplier(ServiceBuilder<TrustManager> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String algorithmName = ALGORITHM.resolveModelAttribute(context, model).asStringOrNull();
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                String providerLoader = providersDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue providersInjector = new InjectedValue();
                if (providerLoader != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providerLoader), Provider[].class), Provider[].class, (Injector)providersInjector);
                }
                String keyStoreName = keystoreDefinition.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue keyStoreInjector = new InjectedValue();
                if (keyStoreName != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName), KeyStore.class), KeyStore.class, (Injector)keyStoreInjector);
                }
                String aliasFilter = ALIAS_FILTER.resolveModelAttribute(context, model).asStringOrNull();
                String algorithm = algorithmName != null ? algorithmName : TrustManagerFactory.getDefaultAlgorithm();
                ModelNode crlNode = CERTIFICATE_REVOCATION_LIST.resolveModelAttribute(context, model);
                ModelNode ocspNode = OCSP.resolveModelAttribute(context, model);
                boolean softFail = SOFT_FAIL.resolveModelAttribute(context, model).asBoolean();
                Integer maxCertPath = MAXIMUM_CERT_PATH.resolveModelAttribute(context, model).asIntOrNull();
                if (crlNode.isDefined() || ocspNode.isDefined()) {
                    return this.createX509RevocationTrustManager(serviceBuilder, context, algorithm, providerName, (InjectedValue<Provider[]>)providersInjector, (InjectedValue<KeyStore>)keyStoreInjector, softFail, crlNode, ocspNode, maxCertPath, aliasFilter);
                }
                DelegatingTrustManager delegatingTrustManager = new DelegatingTrustManager();
                return () -> {
                    TrustManager[] trustManagers;
                    Object[] providers = (Provider[])providersInjector.getOptionalValue();
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providers, providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    try {
                        if (aliasFilter != null) {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("TrustManager supplying:  providers = %s  provider = %s  algorithm = %s  trustManagerFactory = %s  keyStoreName = %s  keyStore = %s  aliasFilter = %s  keyStoreSize = %d", new Object[]{Arrays.toString(providers), providerName, algorithm, trustManagerFactory, keyStoreName, keyStore, aliasFilter, keyStore.size()});
                        }
                        trustManagerFactory.init((KeyStore)keyStoreInjector.getOptionalValue());
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                    for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                        delegatingTrustManager.setTrustManager((X509ExtendedTrustManager)trustManager);
                        return delegatingTrustManager;
                    }
                    throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFound(X509ExtendedKeyManager.class.getSimpleName());
                };
            }

            private TrivialService.ValueSupplier<TrustManager> createX509RevocationTrustManager(ServiceBuilder<TrustManager> serviceBuilder, OperationContext context, String algorithm, String providerName, InjectedValue<Provider[]> providersInjector, InjectedValue<KeyStore> keyStoreInjector, boolean softFail, ModelNode crlNode, ModelNode ocspNode, Integer maxCertPath, String aliasFilter) throws OperationFailedException {
                URI responderUri;
                InjectedValue responderStoreInjector;
                Integer crlCertPath = MAXIMUM_CERT_PATH_CRL.resolveModelAttribute(context, crlNode).asIntOrNull();
                if (crlCertPath != null) {
                    ElytronSubsystemMessages.ROOT_LOGGER.warn("maximum-cert-path in certificate-revocation-list is for legacy support. Please use only the one in trust-manager!");
                    if (maxCertPath != null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.multipleMaximumCertPathDefinitions();
                    }
                    maxCertPath = crlCertPath;
                }
                String crlPath = null;
                String crlRelativeTo = null;
                InjectedValue pathManagerInjector = new InjectedValue();
                if (crlNode.isDefined()) {
                    crlPath = FileAttributeDefinitions.PATH.resolveModelAttribute(context, crlNode).asStringOrNull();
                    crlRelativeTo = FileAttributeDefinitions.RELATIVE_TO.resolveModelAttribute(context, crlNode).asStringOrNull();
                    if (crlPath != null && crlRelativeTo != null) {
                        serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                        serviceBuilder.requires(FileAttributeDefinitions.pathName(crlRelativeTo));
                    }
                }
                boolean preferCrls = PREFER_CRLS.resolveModelAttribute(context, ocspNode).asBoolean(false);
                String responder = RESPONDER.resolveModelAttribute(context, ocspNode).asStringOrNull();
                String responderCertAlias = RESPONDER_CERTIFICATE.resolveModelAttribute(context, ocspNode).asStringOrNull();
                String responderKeystore = RESPONDER_KEYSTORE.resolveModelAttribute(context, ocspNode).asStringOrNull();
                InjectedValue injectedValue = responderStoreInjector = responderKeystore != null ? new InjectedValue() : keyStoreInjector;
                if (responderKeystore != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)responderKeystore), KeyStore.class), KeyStore.class, (Injector)responderStoreInjector);
                }
                try {
                    responderUri = responder == null ? null : new URI(responder);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
                X509RevocationTrustManager.Builder builder = X509RevocationTrustManager.builder();
                builder.setResponderURI(responderUri);
                builder.setSoftFail(softFail);
                if (maxCertPath != null) {
                    builder.setMaxCertPath(maxCertPath.intValue());
                }
                if (crlNode.isDefined() && !ocspNode.isDefined()) {
                    builder.setPreferCrls(true);
                    builder.setNoFallback(true);
                }
                if (ocspNode.isDefined()) {
                    builder.setResponderURI(responderUri);
                    if (!crlNode.isDefined()) {
                        builder.setPreferCrls(false);
                        builder.setNoFallback(true);
                    } else {
                        builder.setPreferCrls(preferCrls);
                    }
                }
                String finalCrlPath = crlPath;
                String finalCrlRelativeTo = crlRelativeTo;
                return () -> {
                    TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory((Provider[])providersInjector.getOptionalValue(), providerName, algorithm);
                    KeyStore keyStore = (KeyStore)keyStoreInjector.getOptionalValue();
                    if (aliasFilter != null) {
                        try {
                            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
                        }
                        catch (Exception e) {
                            throw new StartException((Throwable)e);
                        }
                    }
                    if (responderCertAlias != null) {
                        KeyStore responderStore = (KeyStore)responderStoreInjector.getOptionalValue();
                        try {
                            builder.setOcspResponderCert((X509Certificate)responderStore.getCertificate(responderCertAlias));
                        }
                        catch (KeyStoreException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToLoadResponderCert(responderCertAlias, e);
                        }
                    }
                    builder.setTrustStore(keyStore);
                    builder.setTrustManagerFactory(trustManagerFactory);
                    if (finalCrlPath != null) {
                        try {
                            builder.setCrlStream((InputStream)new FileInputStream(this.resolveFileLocation(finalCrlPath, finalCrlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)));
                            return this.createReloadableX509CRLTrustManager(finalCrlPath, finalCrlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector, builder);
                        }
                        catch (FileNotFoundException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessCRL(e);
                        }
                    }
                    return builder.build();
                };
            }

            private TrustManager createReloadableX509CRLTrustManager(final String crlPath, final String crlRelativeTo, final InjectedValue<PathManager> pathManagerInjector, final X509RevocationTrustManager.Builder builder) {
                return new ReloadableX509ExtendedTrustManager(){
                    private volatile X509ExtendedTrustManager delegate;
                    private AtomicBoolean reloading;
                    {
                        this.delegate = builder.build();
                        this.reloading = new AtomicBoolean();
                    }

                    @Override
                    void reload() {
                        if (this.reloading.compareAndSet(false, true)) {
                            try {
                                builder.setCrlStream((InputStream)new FileInputStream(this.resolveFileLocation(crlPath, crlRelativeTo, (InjectedValue<PathManager>)pathManagerInjector)));
                                this.delegate = builder.build();
                            }
                            catch (FileNotFoundException cause) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCRL(cause);
                            }
                            finally {
                                this.reloading.lazySet(false);
                            }
                        }
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s, socket);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s, sslEngine);
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.delegate.checkClientTrusted(x509Certificates, s);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        this.delegate.checkServerTrusted(x509Certificates, s);
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return this.delegate.getAcceptedIssuers();
                    }
                };
            }

            private File resolveFileLocation(String path, String relativeTo, InjectedValue<PathManager> pathManagerInjector) {
                File resolvedPath;
                if (relativeTo != null) {
                    PathManager pathManager = (PathManager)pathManagerInjector.getValue();
                    resolvedPath = new File(pathManager.resolveRelativePathEntry(path, relativeTo));
                } else {
                    resolvedPath = new File(path);
                }
                return resolvedPath;
            }

            private TrustManagerFactory createTrustManagerFactory(Provider[] providers, String providerName, String algorithm) throws StartException {
                Object trustManagerFactory = null;
                if (providers != null) {
                    for (Provider current : providers) {
                        if (providerName != null && !providerName.equals(current.getName())) continue;
                        try {
                            return TrustManagerFactory.getInstance(algorithm, current);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            // empty catch block
                        }
                    }
                    if (trustManagerFactory == null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateManagerFactory(TrustManagerFactory.class.getSimpleName(), algorithm);
                    }
                }
                try {
                    return TrustManagerFactory.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new StartException((Throwable)e);
                }
            }
        };
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("trust-manager");
        ServiceUtil<TrustManager> TRUST_MANAGER_UTIL = ServiceUtil.newInstance(Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY, "trust-manager", TrustManager.class);
        return TrivialResourceDefinition.builder().setPathKey("trust-manager").setResourceDescriptionResolver((ResourceDescriptionResolver)resolver).setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY).addOperation((OperationDefinition)new SimpleOperationDefinitionBuilder("reload-certificate-revocation-list", (ResourceDescriptionResolver)resolver).setRuntimeOnly().build(), new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName serviceName = Capabilities.TRUST_MANAGER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue()).getCapabilityServiceName();
                ServiceController<TrustManager> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(true), serviceName, TrustManager.class);
                ServiceController.State serviceState = serviceContainer.getState();
                if (serviceState != ServiceController.State.UP) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
                }
                TrustManager trustManager = (TrustManager)serviceContainer.getValue();
                if (!(trustManager instanceof ReloadableX509ExtendedTrustManager)) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToReloadCRLNotReloadable();
                }
                ((ReloadableX509ExtendedTrustManager)trustManager).reload();
            }
        }).addOperation((OperationDefinition)new SimpleOperationDefinitionBuilder("init", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build(), SSLDefinitions.init(TRUST_MANAGER_UTIL)).build();
    }

    private static OperationStepHandler init(final ServiceUtil<?> managerUtil) {
        return new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                try {
                    ServiceName serviceName = managerUtil.serviceName(operation);
                    Object serviceContainer = null;
                    if (serviceName.getParent().getCanonicalName().equals("org.wildfly.security.key-manager")) {
                        serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, KeyManager.class);
                    } else if (serviceName.getParent().getCanonicalName().equals("org.wildfly.security.trust-manager")) {
                        serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, TrustManager.class);
                    }
                    serviceContainer.getService().stop(null);
                    serviceContainer.getService().start(null);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        };
    }

    static boolean initKeyManagerFactory(KeyStore keyStore, DelegatingKeyManager delegating, String aliasFilter, char[] password, KeyManagerFactory keyManagerFactory) throws Exception {
        if (aliasFilter != null) {
            keyStore = FilteringKeyStore.filteringKeyStore((KeyStore)keyStore, (Predicate)AliasFilter.fromString((String)aliasFilter));
        }
        keyManagerFactory.init(keyStore, password);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        boolean keyManagerTypeFound = false;
        for (KeyManager keyManager : keyManagers) {
            if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
            delegating.setKeyManager((X509ExtendedKeyManager)keyManager);
            keyManagerTypeFound = true;
            break;
        }
        return keyManagerTypeFound;
    }

    private static ResourceDefinition createSSLContextDefinition(String pathKey, final boolean server, AbstractAddStepHandler addHandler, AttributeDefinition[] attributes, boolean serverOrHostController) {
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey(pathKey).setAddHandler(addHandler).setAttributes(attributes).setRuntimeCapabilities(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY);
        if (serverOrHostController) {
            builder.addReadOnlyAttribute((AttributeDefinition)ACTIVE_SESSION_COUNT, new SSLContextRuntimeHandler(){

                @Override
                protected void performRuntime(ModelNode result, ModelNode operation, SSLContext sslContext) throws OperationFailedException {
                    SSLSessionContext sessionContext = server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
                    int sum = 0;
                    for (byte[] b : Collections.list(sessionContext.getIds())) {
                        int i = 1;
                        sum += i;
                    }
                    result.set(sum);
                }

                @Override
                protected ServiceUtil<SSLContext> getSSLContextServiceUtil() {
                    return server ? SERVER_SERVICE_UTIL : CLIENT_SERVICE_UTIL;
                }
            }).addChild((ResourceDefinition)new SSLSessionDefinition(server));
        }
        return builder.build();
    }

    private static <T> InjectedValue<T> addDependency(String baseName, SimpleAttributeDefinition attribute, Class<T> type, ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
        String dynamicNameElement = attribute.resolveModelAttribute(context, model).asStringOrNull();
        InjectedValue injectedValue = new InjectedValue();
        if (dynamicNameElement != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)baseName, (String)dynamicNameElement), type), type, (Injector)injectedValue);
        }
        return injectedValue;
    }

    static ResourceDefinition getServerSSLContextDefinition(boolean serverOrHostController) {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context")).setAllowExpression(false)).setRestartAllServices()).build();
        SimpleAttributeDefinition keyManagerDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(KEY_MANAGER).setRequired(true)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, CIPHER_SUITE_NAMES, PROTOCOLS, SECURITY_DOMAIN, WANT_CLIENT_AUTH, NEED_CLIENT_AUTH, AUTHENTICATION_OPTIONAL, USE_CIPHER_SUITES_ORDER, MAXIMUM_SESSION_CACHE_SIZE, SESSION_TIMEOUT, WRAP, keyManagerDefinition, TRUST_MANAGER, PRE_REALM_PRINCIPAL_TRANSFORMER, POST_REALM_PRINCIPAL_TRANSFORMER, FINAL_PRINCIPAL_TRANSFORMER, REALM_MAPPER, providersDefinition, PROVIDER_NAME};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, ServiceController.Mode.ACTIVE, ServiceController.Mode.PASSIVE, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue securityDomainInjector = SSLDefinitions.addDependency("org.wildfly.security.security-domain", SECURITY_DOMAIN, SecurityDomain.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue keyManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.key-manager", KEY_MANAGER, KeyManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-manager", TRUST_MANAGER, TrustManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue preRealmPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", PRE_REALM_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue postRealmPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", POST_REALM_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue finalPrincipalTransformerInjector = SSLDefinitions.addDependency("org.wildfly.security.principal-transformer", FINAL_PRINCIPAL_TRANSFORMER, PrincipalTransformer.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue realmMapperInjector = SSLDefinitions.addDependency("org.wildfly.security.realm-mapper", REALM_MAPPER, RealmMapper.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = CIPHER_SUITE_FILTER.resolveModelAttribute(context, model).asString();
                String cipherSuiteNames = CIPHER_SUITE_NAMES.resolveModelAttribute(context, model).asStringOrNull();
                boolean wantClientAuth = WANT_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean needClientAuth = NEED_CLIENT_AUTH.resolveModelAttribute(context, model).asBoolean();
                boolean authenticationOptional = AUTHENTICATION_OPTIONAL.resolveModelAttribute(context, model).asBoolean();
                boolean useCipherSuitesOrder = USE_CIPHER_SUITES_ORDER.resolveModelAttribute(context, model).asBoolean();
                int maximumSessionCacheSize = MAXIMUM_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asInt();
                int sessionTimeout = SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
                boolean wrap = WRAP.resolveModelAttribute(context, model).asBoolean();
                return () -> {
                    SecurityDomain securityDomain = (SecurityDomain)securityDomainInjector.getOptionalValue();
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager)keyManagerInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager)trustManagerInjector.getOptionalValue());
                    PrincipalTransformer preRealmRewriter = (PrincipalTransformer)preRealmPrincipalTransformerInjector.getOptionalValue();
                    PrincipalTransformer postRealmRewriter = (PrincipalTransformer)postRealmPrincipalTransformerInjector.getOptionalValue();
                    PrincipalTransformer finalRewriter = (PrincipalTransformer)finalPrincipalTransformerInjector.getOptionalValue();
                    RealmMapper realmMapper = (RealmMapper)realmMapperInjector.getOptionalValue();
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (securityDomain != null) {
                        builder.setSecurityDomain(securityDomain);
                    }
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 6.lambda$null$0((Provider[])providers));
                    }
                    builder.setCipherSuiteSelector(CipherSuiteSelector.aggregate((CipherSuiteSelector)(cipherSuiteNames != null ? CipherSuiteSelector.fromNamesString((String)cipherSuiteNames) : null), (CipherSuiteSelector)CipherSuiteSelector.fromString((String)cipherSuiteFilter)));
                    if (!protocols.isEmpty()) {
                        ArrayList<Protocol> list = new ArrayList<Protocol>();
                        for (String protocol : protocols) {
                            Protocol forName = Protocol.forName((String)protocol);
                            list.add(forName);
                        }
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list)));
                    }
                    if (preRealmRewriter != null || postRealmRewriter != null || finalRewriter != null || realmMapper != null) {
                        MechanismConfiguration.Builder mechBuilder = MechanismConfiguration.builder();
                        if (preRealmRewriter != null) {
                            mechBuilder.setPreRealmRewriter((Function)preRealmRewriter);
                        }
                        if (postRealmRewriter != null) {
                            mechBuilder.setPostRealmRewriter((Function)postRealmRewriter);
                        }
                        if (finalRewriter != null) {
                            mechBuilder.setFinalRewriter((Function)finalRewriter);
                        }
                        if (realmMapper != null) {
                            mechBuilder.setRealmMapper(realmMapper);
                        }
                        builder.setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)mechBuilder.build()));
                    }
                    builder.setWantClientAuth(wantClientAuth).setNeedClientAuth(needClientAuth).setAuthenticationOptional(authenticationOptional).setUseCipherSuitesOrder(useCipherSuitesOrder).setSessionCacheSize(maximumSessionCacheSize).setSessionTimeout(sessionTimeout).setWrap(wrap);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ServerSSLContext supplying:  securityDomain = %s  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s  cipherSuiteNames = %s protocols = %s  wantClientAuth = %s  needClientAuth = %s  authenticationOptional = %s  maximumSessionCacheSize = %s  sessionTimeout = %s wrap = %s", new Object[]{securityDomain, keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, cipherSuiteNames, Arrays.toString(protocols.toArray()), wantClientAuth, needClientAuth, authenticationOptional, maximumSessionCacheSize, sessionTimeout, wrap});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), true);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        };
        return SSLDefinitions.createSSLContextDefinition("server-ssl-context", true, add, attributes, serverOrHostController);
    }

    static ResourceDefinition getServerSNISSLContextDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{DEFAULT_SSL_CONTEXT, HOST_CONTEXT_MAP};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Set keys;
                InjectedValue defaultContext = new InjectedValue();
                ModelNode defaultContextName = DEFAULT_SSL_CONTEXT.resolveModelAttribute(context, model);
                serviceBuilder.addDependency(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{defaultContextName.asString()}), SSLContext.class, (Injector)defaultContext);
                ModelNode hostContextMap = HOST_CONTEXT_MAP.resolveModelAttribute(context, model);
                if (hostContextMap.isDefined() && (keys = hostContextMap.keys()).size() > 0) {
                    HashMap<String, InjectedValue> sslContextMap = new HashMap<String, InjectedValue>(keys.size());
                    for (String host : keys) {
                        String sslContextName = hostContextMap.require(host).asString();
                        InjectedValue injector = new InjectedValue();
                        serviceBuilder.addDependency(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY.getCapabilityServiceName(new String[]{sslContextName}), SSLContext.class, (Injector)injector);
                        sslContextMap.put(host, injector);
                    }
                    return () -> {
                        SNIContextMatcher.Builder builder = new SNIContextMatcher.Builder();
                        for (Map.Entry e : sslContextMap.entrySet()) {
                            builder.addMatch((String)e.getKey(), (SSLContext)((InjectedValue)e.getValue()).getValue());
                        }
                        return new SNISSLContext(builder.setDefaultContext((SSLContext)defaultContext.getValue()).build());
                    };
                }
                return () -> (SSLContext)defaultContext.getValue();
            }
        };
        TrivialResourceDefinition.Builder builder = TrivialResourceDefinition.builder().setPathKey("server-ssl-sni-context").setAddHandler(add).setAttributes(attributes).setRuntimeCapabilities(Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY);
        return builder.build();
    }

    static ResourceDefinition getClientSSLContextDefinition(boolean serverOrHostController) {
        final SimpleAttributeDefinition providersDefinition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(PROVIDERS).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.ssl-context")).setAllowExpression(false)).setRestartAllServices()).build();
        AttributeDefinition[] attributes = new AttributeDefinition[]{CIPHER_SUITE_FILTER, CIPHER_SUITE_NAMES, PROTOCOLS, KEY_MANAGER, TRUST_MANAGER, providersDefinition, PROVIDER_NAME};
        TrivialAddHandler<SSLContext> add = new TrivialAddHandler<SSLContext>(SSLContext.class, attributes, Capabilities.SSL_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SSLContext> getValueSupplier(ServiceBuilder<SSLContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue keyManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.key-manager", KEY_MANAGER, KeyManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue trustManagerInjector = SSLDefinitions.addDependency("org.wildfly.security.trust-manager", TRUST_MANAGER, TrustManager.class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                InjectedValue providersInjector = SSLDefinitions.addDependency("org.wildfly.security.providers", providersDefinition, Provider[].class, (ServiceBuilder<SSLContext>)serviceBuilder, context, model);
                String providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                List protocols = PROTOCOLS.unwrap((ExpressionResolver)context, model);
                String cipherSuiteFilter = CIPHER_SUITE_FILTER.resolveModelAttribute(context, model).asString();
                String cipherSuiteNames = CIPHER_SUITE_NAMES.resolveModelAttribute(context, model).asStringOrNull();
                return () -> {
                    X509ExtendedKeyManager keyManager = SSLDefinitions.getX509KeyManager((KeyManager)keyManagerInjector.getOptionalValue());
                    X509ExtendedTrustManager trustManager = SSLDefinitions.getX509TrustManager((TrustManager)trustManagerInjector.getOptionalValue());
                    Object[] providers = SSLDefinitions.filterProviders((Provider[])providersInjector.getOptionalValue(), providerName);
                    SSLContextBuilder builder = new SSLContextBuilder();
                    if (keyManager != null) {
                        builder.setKeyManager(keyManager);
                    }
                    if (trustManager != null) {
                        builder.setTrustManager((X509TrustManager)trustManager);
                    }
                    if (providers != null) {
                        builder.setProviderSupplier(() -> 8.lambda$null$0((Provider[])providers));
                    }
                    builder.setCipherSuiteSelector(CipherSuiteSelector.aggregate((CipherSuiteSelector)(cipherSuiteNames != null ? CipherSuiteSelector.fromNamesString((String)cipherSuiteNames) : null), (CipherSuiteSelector)CipherSuiteSelector.fromString((String)cipherSuiteFilter)));
                    if (!protocols.isEmpty()) {
                        ArrayList<Protocol> list = new ArrayList<Protocol>();
                        for (String protocol : protocols) {
                            Protocol forName = Protocol.forName((String)protocol);
                            list.add(forName);
                        }
                        builder.setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list)));
                    }
                    builder.setClientMode(true).setWrap(false);
                    if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("ClientSSLContext supplying:  keyManager = %s  trustManager = %s  providers = %s  cipherSuiteFilter = %s cipherSuiteNames = %s protocols = %s", new Object[]{keyManager, trustManager, Arrays.toString(providers), cipherSuiteFilter, cipherSuiteNames, Arrays.toString(protocols.toArray())});
                    }
                    try {
                        return (SSLContext)builder.build().create();
                    }
                    catch (GeneralSecurityException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }

            protected Resource createResource(OperationContext context) {
                SSLContextResource resource = new SSLContextResource(Resource.Factory.create(), false);
                context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
                return resource;
            }

            @Override
            protected void installedForResource(ServiceController<SSLContext> serviceController, Resource resource) {
                ((SSLContextResource)resource).setSSLContextServiceController(serviceController);
            }

            private static /* synthetic */ Provider[] lambda$null$0(Provider[] providers) {
                return providers;
            }
        };
        return SSLDefinitions.createSSLContextDefinition("client-ssl-context", false, add, attributes, serverOrHostController);
    }

    private static Provider[] filterProviders(Provider[] all, String provider) {
        if (provider == null || all == null) {
            return all;
        }
        ArrayList<Provider> list = new ArrayList<Provider>();
        for (Provider current : all) {
            if (!provider.equals(current.getName())) continue;
            list.add(current);
        }
        return list.toArray(new Provider[0]);
    }

    private static X509ExtendedKeyManager getX509KeyManager(KeyManager keyManager) throws StartException {
        if (keyManager == null) {
            return null;
        }
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager x509KeyManager = (X509ExtendedKeyManager)keyManager;
            if (x509KeyManager instanceof DelegatingKeyManager && IS_FIPS.getAsBoolean()) {
                ElytronSubsystemMessages.ROOT_LOGGER.trace("FIPS enabled on JVM, unwrapping KeyManager");
                x509KeyManager = (X509ExtendedKeyManager)((DelegatingKeyManager)x509KeyManager).delegating.get();
            }
            return x509KeyManager;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidTypeInjected(X509ExtendedKeyManager.class.getSimpleName());
    }

    private static X509ExtendedTrustManager getX509TrustManager(TrustManager trustManager) throws StartException {
        if (trustManager == null) {
            return null;
        }
        if (trustManager instanceof X509ExtendedTrustManager) {
            X509ExtendedTrustManager x509TrustManager = (X509ExtendedTrustManager)trustManager;
            if (x509TrustManager instanceof DelegatingTrustManager && IS_FIPS.getAsBoolean()) {
                ElytronSubsystemMessages.ROOT_LOGGER.trace("FIPS enabled on JVM, unwrapping TrustManager");
                x509TrustManager = (X509ExtendedTrustManager)((DelegatingTrustManager)x509TrustManager).delegating.get();
            }
            return x509TrustManager;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidTypeInjected(X509ExtendedTrustManager.class.getSimpleName());
    }

    private static BooleanSupplier getFipsSupplier() {
        try {
            Class<?> providerClazz = SSLDefinitions.class.getClassLoader().loadClass("com.sun.net.ssl.internal.ssl.Provider");
            Method isFipsMethod = providerClazz.getMethod("isFIPS", new Class[0]);
            return () -> {
                Object isFips;
                try {
                    isFips = isFipsMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to invoke com.sun.net.ssl.internal.ssl.Provider.isFIPS() method.", e);
                    return false;
                }
                return isFips != null && isFips instanceof Boolean ? (Boolean)isFips : false;
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to find com.sun.net.ssl.internal.ssl.Provider.isFIPS() method.", e);
            return Boolean.FALSE::booleanValue;
        }
    }

    static ModifiableKeyStoreService getModifiableKeyStoreService(OperationContext context, String keyStoreName) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(keyStoreName);
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName();
        ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName, KeyStore.class);
        return (ModifiableKeyStoreService)serviceContainer.getService();
    }

    static abstract class SSLContextRuntimeHandler
    extends ElytronRuntimeOnlyHandler {
        SSLContextRuntimeHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName serviceName = this.getSSLContextServiceUtil().serviceName(operation);
            ServiceController<SSLContext> serviceController = ElytronExtension.getRequiredService(context.getServiceRegistry(false), serviceName, SSLContext.class);
            ServiceController.State serviceState = serviceController.getState();
            if (serviceState != ServiceController.State.UP) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
            }
            this.performRuntime(context.getResult(), operation, (SSLContext)serviceController.getService().getValue());
        }

        protected abstract void performRuntime(ModelNode var1, ModelNode var2, SSLContext var3) throws OperationFailedException;

        protected abstract ServiceUtil<SSLContext> getSSLContextServiceUtil();
    }

    private static class DelegatingTrustManager
    extends X509ExtendedTrustManager {
        private final AtomicReference<X509ExtendedTrustManager> delegating = new AtomicReference();

        private DelegatingTrustManager() {
        }

        public void setTrustManager(X509ExtendedTrustManager trustManager) {
            this.delegating.set(trustManager);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            this.delegating.get().checkClientTrusted(x509Certificates, s, socket);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            this.delegating.get().checkServerTrusted(x509Certificates, s, socket);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            this.delegating.get().checkClientTrusted(x509Certificates, s, sslEngine);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            this.delegating.get().checkServerTrusted(x509Certificates, s, sslEngine);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.delegating.get().checkClientTrusted(x509Certificates, s);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.delegating.get().checkServerTrusted(x509Certificates, s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegating.get().getAcceptedIssuers();
        }
    }

    private static class LazyDelegatingKeyManager
    extends DelegatingKeyManager {
        private ModifiableKeyStoreService keyStoreService;
        private char[] password;
        private KeyManagerFactory keyManagerFactory;
        private String generateSelfSignedCertificateHostName;
        private String aliasFilter;
        private volatile boolean init = false;

        private LazyDelegatingKeyManager(ModifiableKeyStoreService keyStoreService, char[] password, KeyManagerFactory keyManagerFactory, String generateSelfSignedCertificateHostName, String aliasFilter) {
            this.keyStoreService = keyStoreService;
            this.password = password;
            this.keyManagerFactory = keyManagerFactory;
            this.generateSelfSignedCertificateHostName = generateSelfSignedCertificateHostName;
            this.aliasFilter = aliasFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInit() {
            if (!this.init) {
                LazyDelegatingKeyManager lazyDelegatingKeyManager = this;
                synchronized (lazyDelegatingKeyManager) {
                    if (!this.init) {
                        try {
                            ((KeyStoreService)this.keyStoreService).generateAndSaveSelfSignedCertificate(this.generateSelfSignedCertificateHostName, this.password);
                            if (!SSLDefinitions.initKeyManagerFactory((KeyStore)this.keyStoreService.getValue(), this, this.aliasFilter, this.password, this.keyManagerFactory)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.noTypeFoundForLazyInitKeyManager(X509ExtendedKeyManager.class.getSimpleName());
                            }
                        }
                        catch (Exception e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToLazilyInitKeyManager(e);
                        }
                        finally {
                            this.init = true;
                        }
                    }
                }
            }
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            this.doInit();
            return super.getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            this.doInit();
            return super.chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            this.doInit();
            return super.getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            this.doInit();
            return super.chooseServerAlias(s, principals, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            this.doInit();
            return super.getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            this.doInit();
            return super.getPrivateKey(s);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            this.doInit();
            return super.chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            this.doInit();
            return super.chooseEngineServerAlias(keyType, issuers, engine);
        }
    }

    private static class DelegatingKeyManager
    extends X509ExtendedKeyManager {
        private final AtomicReference<X509ExtendedKeyManager> delegating = new AtomicReference();

        private DelegatingKeyManager() {
        }

        private void setKeyManager(X509ExtendedKeyManager keyManager) {
            this.delegating.set(keyManager);
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.delegating.get().getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.delegating.get().chooseClientAlias(strings, principals, socket);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.delegating.get().getServerAliases(s, principals);
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return this.delegating.get().chooseServerAlias(s, principals, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.delegating.get().getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.delegating.get().getPrivateKey(s);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegating.get().chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegating.get().chooseEngineServerAlias(keyType, issuers, engine);
        }
    }

    private static abstract class ReloadableX509ExtendedTrustManager
    extends X509ExtendedTrustManager {
        private ReloadableX509ExtendedTrustManager() {
        }

        abstract void reload();
    }

    static class CipherSuiteNamesValidator
    extends ModelTypeValidator {
        CipherSuiteNamesValidator() {
            super(ModelType.STRING, true, true, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                try {
                    CipherSuiteSelector.fromNamesString((String)value.asString());
                }
                catch (IllegalArgumentException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidCipherSuiteNames(e, e.getLocalizedMessage());
                }
            }
        }
    }

    static class HostContextMapValidator
    implements ParameterValidator {
        static Pattern hostnameRegexPattern = Pattern.compile("[0-9a-zA-Z\\[.*]([0-9a-zA-Z*.\\[\\]?-]|(?<!\\\\\\.)\\\\\\.)*[0-9a-zA-Z*.\\[\\]?]");

        HostContextMapValidator() {
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (value.isDefined()) {
                for (String hostname : value.keys()) {
                    if (!hostnameRegexPattern.matcher(hostname).matches()) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidHostContextMapValue(hostname);
                    }
                    try {
                        Pattern.compile(hostname);
                    }
                    catch (PatternSyntaxException exception) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidHostContextMapValue(hostname);
                    }
                }
            }
        }
    }

    static class CipherSuiteFilterValidator
    extends ModelTypeValidator {
        CipherSuiteFilterValidator() {
            super(ModelType.STRING, true, true, false);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                try {
                    CipherSuiteSelector.fromString((String)value.asString());
                }
                catch (IllegalArgumentException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidCipherSuiteFilter(e, e.getLocalizedMessage());
                }
            }
        }
    }

    static class StringValuesValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private List<ModelNode> allowedValues = new ArrayList<ModelNode>();

        StringValuesValidator(String ... values) {
            super(ModelType.STRING);
            for (String value : values) {
                this.allowedValues.add(new ModelNode().set(value));
            }
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined() && !this.allowedValues.contains(value)) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidValue(value.asString(), parameterName, this.allowedValues));
            }
        }

        public List<ModelNode> getAllowedValues() {
            return this.allowedValues;
        }
    }
}

