/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.AvailableMechanismsRuntimeResource;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;
import org.wildfly.security.sasl.util.FilterMechanismSaslServerFactory;
import org.wildfly.security.sasl.util.MechanismProviderFilteringSaslServerFactory;
import org.wildfly.security.sasl.util.PropertiesSaslServerFactory;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;
import org.wildfly.security.sasl.util.ServiceLoaderSaslServerFactory;
import org.wildfly.security.sasl.util.SetMechanismInformationSaslServerFactory;

class SaslServerDefinitions {
    static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING, true).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.sasl-authentication-factory")).build();
    static final SimpleAttributeDefinition SASL_SERVER_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-server-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.sasl-server-factory", "org.wildfly.security.sasl-server-factory")).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.sasl-server-factory")).build();
    static final SimpleAttributeDefinition ENABLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabling", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MECHANISM_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mechanism-name", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, false).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition PROVIDER_VERSION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-version", ModelType.DOUBLE, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition VERSION_COMPARISON = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("version-comparison", ModelType.STRING, false).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode("less-than"))).setRequires(new String[]{"provider-version"})).setAllowedValues(new String[]{"less-than", "greater-than"})).setValidator((ParameterValidator)EnumValidator.create(Comparison.class, (boolean)true, (boolean)true))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition MECH_PROVIDER_FILTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("filter", new AttributeDefinition[]{MECHANISM_NAME, PROVIDER_NAME, PROVIDER_VERSION, VERSION_COMPARISON}).setRequired(false)).setXmlName("filter")).build();
    static final ObjectListAttributeDefinition MECH_PROVIDER_FILTERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("filters", MECH_PROVIDER_FILTER).setMinSize(1)).setRequired(false)).setRestartAllServices()).setXmlName("filters")).build();
    static final SimpleAttributeDefinition PREDEFINED_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("predefined-filter", ModelType.STRING, false).setAllowExpression(true)).setXmlName("predefined")).setAllowedValues(NamePredicate.names())).setValidator((ParameterValidator)EnumValidator.create(NamePredicate.class, (boolean)true, (boolean)true))).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAlternatives(new String[]{"pattern-filter"})).build();
    static final SimpleAttributeDefinition PATTERN_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pattern-filter", RegexAttributeDefinitions.PATTERN).setAlternatives(new String[]{"predefined-filter"})).setXmlName("pattern")).build();
    static final ObjectTypeAttributeDefinition CONFIGURED_FILTER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("filter", new AttributeDefinition[]{PREDEFINED_FILTER, PATTERN_FILTER, ENABLING}).setXmlName("filter")).build();
    static final ObjectListAttributeDefinition CONFIGURED_FILTERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("filters", CONFIGURED_FILTER).setRequired(false)).setValidator((ParameterValidator)new FiltersValidator())).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<SaslServerFactory> AGGREGATE_SASL_SERVER_FACTORY = AggregateComponentDefinition.create(SaslServerFactory.class, "aggregate-sasl-server-factory", "sasl-server-factories", Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY, AggregateSaslServerFactory::new);

    SaslServerDefinitions() {
    }

    static AggregateComponentDefinition<SaslServerFactory> getRawAggregateSaslServerFactoryDefinition() {
        return AGGREGATE_SASL_SERVER_FACTORY;
    }

    static ResourceDefinition getAggregateSaslServerFactoryDefinition() {
        return AvailableMechanismsRuntimeResource.wrap(AGGREGATE_SASL_SERVER_FACTORY, SaslServerDefinitions::getSaslServerAvailableMechanisms);
    }

    static ResourceDefinition getConfigurableSaslServerFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{SASL_SERVER_FACTORY, SERVER_NAME, PROTOCOL, CommonAttributes.PROPERTIES, CONFIGURED_FILTERS};
        SaslServerAddHandler add = new SaslServerAddHandler(attributes){

            @Override
            protected ServiceBuilder<SaslServerFactory> installService(OperationContext context, ServiceName saslServerFactoryName, ModelNode model) throws OperationFailedException {
                Predicate<Object> finalFilter;
                HashMap<String, String> propertiesMap;
                String saslServerFactory = SASL_SERVER_FACTORY.resolveModelAttribute(context, model).asString();
                String protocol = PROTOCOL.resolveModelAttribute(context, model).asStringOrNull();
                String serverName = SERVER_NAME.resolveModelAttribute(context, model).asStringOrNull();
                ModelNode properties = CommonAttributes.PROPERTIES.resolveModelAttribute(context, model);
                if (properties.isDefined()) {
                    propertiesMap = new HashMap<String, String>();
                    for (String s2 : properties.keys()) {
                        propertiesMap.put(s2, properties.require(s2).asString());
                    }
                } else {
                    propertiesMap = null;
                }
                if (model.hasDefined("filters")) {
                    Predicate<Object> filter = null;
                    List nodes = model.require("filters").asList();
                    for (ModelNode current : nodes) {
                        Predicate<Object> currentFilter = s -> true;
                        String predefinedFilter = PREDEFINED_FILTER.resolveModelAttribute(context, current).asStringOrNull();
                        if (predefinedFilter != null) {
                            currentFilter = NamePredicate.valueOf(predefinedFilter).predicate;
                        } else {
                            String patternFilter = PATTERN_FILTER.resolveModelAttribute(context, current).asStringOrNull();
                            if (patternFilter != null) {
                                Pattern pattern = Pattern.compile(patternFilter);
                                currentFilter = s -> pattern.matcher((CharSequence)s).find();
                            }
                        }
                        currentFilter = ENABLING.resolveModelAttribute(context, current).asBoolean() ? currentFilter : currentFilter.negate();
                        filter = filter == null ? currentFilter : filter.or(currentFilter);
                    }
                    finalFilter = filter;
                } else {
                    finalFilter = null;
                }
                InjectedValue saslServerFactoryInjector = new InjectedValue();
                TrivialService<SaslServerFactory> saslServiceFactoryService = new TrivialService<SaslServerFactory>(() -> {
                    SaslServerFactory theFactory = (SaslServerFactory)saslServerFactoryInjector.getValue();
                    theFactory = new SetMechanismInformationSaslServerFactory(theFactory);
                    theFactory = protocol != null ? new ProtocolSaslServerFactory(theFactory, protocol) : theFactory;
                    theFactory = serverName != null ? new ServerNameSaslServerFactory(theFactory, serverName) : theFactory;
                    theFactory = propertiesMap != null ? new PropertiesSaslServerFactory(theFactory, propertiesMap) : theFactory;
                    theFactory = finalFilter != null ? new FilterMechanismSaslServerFactory(theFactory, finalFilter) : theFactory;
                    return theFactory;
                });
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(saslServerFactoryName, saslServiceFactoryService);
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.sasl-server-factory", (String)saslServerFactory), SaslServerFactory.class), SaslServerFactory.class, (Injector)saslServerFactoryInjector);
                return serviceBuilder;
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new SaslServerResourceDefinition("configurable-sasl-server-factory", add, attributes), SaslServerDefinitions::getSaslServerAvailableMechanisms);
    }

    static ResourceDefinition getProviderSaslServerFactoryDefinition() {
        SaslServerAddHandler add = new SaslServerAddHandler(new AttributeDefinition[]{PROVIDERS}){

            @Override
            protected ServiceBuilder<SaslServerFactory> installService(OperationContext context, ServiceName saslServerFactoryName, ModelNode model) throws OperationFailedException {
                String providers = PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
                InjectedValue providerInjector = new InjectedValue();
                Supplier<Provider[]> providerSupplier = providers != null ? () -> ((InjectedValue)providerInjector).getValue() : Security::getProviders;
                TrivialService<SaslServerFactory> saslServiceFactoryService = new TrivialService<SaslServerFactory>(() -> new SecurityProviderSaslServerFactory(providerSupplier));
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(saslServerFactoryName, saslServiceFactoryService);
                if (providers != null) {
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providers), Provider[].class), Provider[].class, (Injector)providerInjector);
                }
                return serviceBuilder;
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new SaslServerResourceDefinition("provider-sasl-server-factory", add, new AttributeDefinition[]{PROVIDERS}), SaslServerDefinitions::getSaslServerAvailableMechanisms);
    }

    static ResourceDefinition getServiceLoaderSaslServerFactoryDefinition() {
        SaslServerAddHandler add = new SaslServerAddHandler(new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE}){

            @Override
            protected TrivialService.ValueSupplier<SaslServerFactory> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
                String module = ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, model).asStringOrNull();
                return () -> this.getSaslServerFactory(module);
            }

            private SaslServerFactory getSaslServerFactory(String module) throws StartException {
                try {
                    ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                    return new ServiceLoaderSaslServerFactory(classLoader);
                }
                catch (Exception e) {
                    throw new StartException((Throwable)e);
                }
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new SaslServerResourceDefinition("service-loader-sasl-server-factory", add, new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE}), SaslServerDefinitions::getSaslServerAvailableMechanisms);
    }

    static ResourceDefinition getMechanismProviderFilteringSaslServerFactory() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{SASL_SERVER_FACTORY, ENABLING, MECH_PROVIDER_FILTERS};
        SaslServerAddHandler add = new SaslServerAddHandler(attributes){

            @Override
            protected ServiceBuilder<SaslServerFactory> installService(OperationContext context, ServiceName saslServerFactoryName, ModelNode model) throws OperationFailedException {
                String saslServerFactory = SASL_SERVER_FACTORY.resolveModelAttribute(context, model).asString();
                BiPredicate<String, Provider> predicate = null;
                if (model.hasDefined("filters")) {
                    List nodes = model.require("filters").asList();
                    for (ModelNode current : nodes) {
                        Predicate<Double> versionPredicate;
                        String mechanismName = MECHANISM_NAME.resolveModelAttribute(context, current).asStringOrNull();
                        String providerName = PROVIDER_NAME.resolveModelAttribute(context, current).asString();
                        Double providerVersion = PROVIDER_VERSION.resolveModelAttribute(context, current).asDoubleOrNull();
                        if (providerVersion != null) {
                            Comparison comparison = Comparison.getComparison(VERSION_COMPARISON.resolveModelAttribute(context, current).asString());
                            versionPredicate = d -> comparison.getPredicate().test((Double)d, providerVersion);
                        } else {
                            versionPredicate = null;
                        }
                        BiPredicate<String, Provider> thisPredicate = (s, p) -> !(mechanismName != null && !mechanismName.equals(s) || !providerName.equals(p.getName()) || providerVersion != null && !versionPredicate.test(p.getVersion()));
                        predicate = predicate == null ? thisPredicate : predicate.or(thisPredicate);
                    }
                    boolean enabling = ENABLING.resolveModelAttribute(context, model).asBoolean();
                    if (!enabling) {
                        predicate = predicate.negate();
                    }
                }
                BiPredicate<String, Provider> finalPredicate = predicate;
                InjectedValue saslServerFactoryInjector = new InjectedValue();
                TrivialService<SaslServerFactory> saslServiceFactoryService = new TrivialService<SaslServerFactory>(() -> {
                    SaslServerFactory theFactory = (SaslServerFactory)saslServerFactoryInjector.getValue();
                    theFactory = finalPredicate != null ? new MechanismProviderFilteringSaslServerFactory(theFactory, finalPredicate) : theFactory;
                    return theFactory;
                });
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceBuilder serviceBuilder = serviceTarget.addService(saslServerFactoryName, saslServiceFactoryService);
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.sasl-server-factory", (String)saslServerFactory), SaslServerFactory.class), SaslServerFactory.class, (Injector)saslServerFactoryInjector);
                return serviceBuilder;
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new SaslServerResourceDefinition("mechanism-provider-filtering-sasl-server-factory", add, attributes), SaslServerDefinitions::getSaslServerAvailableMechanisms);
    }

    private static String[] getSaslServerAvailableMechanisms(OperationContext context) {
        RuntimeCapability runtimeCapability = Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
        ServiceName saslServerFactoryName = runtimeCapability.getCapabilityServiceName(SaslServerFactory.class);
        ServiceController<SaslServerFactory> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), saslServerFactoryName, SaslServerFactory.class);
        if (serviceContainer.getState() != ServiceController.State.UP) {
            return null;
        }
        return ((SaslServerFactory)serviceContainer.getValue()).getMechanismNames(Collections.emptyMap());
    }

    private static enum Comparison {
        LESS_THAN("less-than", (left, right) -> left < right),
        GREATER_THAN("greater-than", (left, right) -> left > right);

        private final String name;
        private final BiPredicate<Double, Double> predicate;

        private Comparison(String name, BiPredicate<Double, Double> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        BiPredicate<Double, Double> getPredicate() {
            return this.predicate;
        }

        public String toString() {
            return this.name;
        }

        static Comparison getComparison(String value) {
            switch (value) {
                case "less-than": {
                    return LESS_THAN;
                }
                case "greater-than": {
                    return GREATER_THAN;
                }
            }
            throw new IllegalArgumentException("Invalid value");
        }
    }

    private static enum NamePredicate {
        HASH_MD5(SaslMechanismInformation.HASH_MD5),
        HASH_SHA(SaslMechanismInformation.HASH_SHA),
        HASH_SHA_256(SaslMechanismInformation.HASH_SHA_256),
        HASH_SHA_384(SaslMechanismInformation.HASH_SHA_384),
        HASH_SHA_512(SaslMechanismInformation.HASH_SHA_512),
        GS2(SaslMechanismInformation.GS2),
        SCRAM(SaslMechanismInformation.SCRAM),
        DIGEST(SaslMechanismInformation.DIGEST),
        IEC_ISO_9798(SaslMechanismInformation.IEC_ISO_9798),
        EAP(SaslMechanismInformation.EAP),
        MUTUAL(SaslMechanismInformation.MUTUAL),
        BINDING(SaslMechanismInformation.BINDING),
        RECOMMENDED(SaslMechanismInformation.RECOMMENDED);

        private final Predicate<String> predicate;

        private NamePredicate(Predicate<String> predicate) {
            this.predicate = predicate;
        }

        static String[] names() {
            NamePredicate[] namePredicates = NamePredicate.values();
            String[] names = new String[namePredicates.length];
            for (int i = 0; i < namePredicates.length; ++i) {
                names[i] = namePredicates[i].toString();
            }
            return names;
        }
    }

    private static class SaslServerAddHandler
    extends BaseAddHandler {
        private SaslServerAddHandler(AttributeDefinition ... attributes) {
            super(Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability runtimeCapability = Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName saslServerFactoryName = runtimeCapability.getCapabilityServiceName(SaslServerFactory.class);
            ElytronDefinition.commonDependencies(this.installService(context, saslServerFactoryName, model)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        protected ServiceBuilder<SaslServerFactory> installService(OperationContext context, ServiceName saslServerFactoryName, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            TrivialService<SaslServerFactory> saslServerFactoryService = new TrivialService<SaslServerFactory>(this.getValueSupplier(context, model));
            return serviceTarget.addService(saslServerFactoryName, saslServerFactoryService);
        }

        protected TrivialService.ValueSupplier<SaslServerFactory> getValueSupplier(OperationContext context, ModelNode model) throws OperationFailedException {
            return () -> null;
        }
    }

    private static class SaslServerResourceDefinition
    extends SimpleResourceDefinition {
        private final String pathKey;
        private final AttributeDefinition[] attributes;

        SaslServerResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition ... attributes) {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new TrivialCapabilityServiceRemoveHandler(add, Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SASL_SERVER_FACTORY_RUNTIME_CAPABILITY}));
            this.pathKey = pathKey;
            this.attributes = attributes;
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            if (this.attributes != null && this.attributes.length > 0) {
                ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(this.attributes);
                for (AttributeDefinition current : this.attributes) {
                    resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                }
            }
        }
    }

    private static class FiltersValidator
    extends ObjectTypeValidator {
        private FiltersValidator() {
            super(true, new AttributeDefinition[]{PREDEFINED_FILTER, PATTERN_FILTER, ENABLING});
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.hasDefined("predefined-filter") && value.hasDefined("pattern-filter")) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidDefinition("filters", "predefined-filter", "pattern-filter");
            }
        }
    }
}

