/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collection;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.ElytronOperationStepHandler;

class ElytronReloadRequiredWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler
implements ElytronOperationStepHandler {
    ElytronReloadRequiredWriteAttributeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    ElytronReloadRequiredWriteAttributeHandler(Collection<AttributeDefinition> definitions) {
        super(definitions);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals("credential-reference")) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        boolean requiresReload = false;
        if (attributeName.equals("credential-reference")) {
            requiresReload = CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
        }
        return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder) || requiresReload;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return this.isServerOrHostController(context);
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, Void handback) throws OperationFailedException {
        if (attributeName.equals("credential-reference")) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)this.getAttributeDefinition(attributeName), (OperationContext)context, (ModelNode)resolvedValue);
        }
    }
}

