/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.common.Assert;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CertificateChainAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.keystore.PasswordEntry;

class ModifiableKeyStoreDecorator
extends DelegatingResourceDefinition {
    static ResourceDefinition wrap(ResourceDefinition resourceDefinition) {
        return new ModifiableKeyStoreDecorator(resourceDefinition);
    }

    ModifiableKeyStoreDecorator(ResourceDefinition resourceDefinition) {
        this.setDelegate(resourceDefinition);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("modifiable-key-store");
        ReadAliasesHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        ReadAliasHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            RemoveAliasHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        }
    }

    static KeyStore getKeyStore(OperationContext context) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        PathAddress currentAddress = context.getCurrentAddress();
        RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(currentAddress.getLastElement().getValue());
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName();
        ServiceController<KeyStore> serviceController = ElytronExtension.getRequiredService(serviceRegistry, serviceName, KeyStore.class);
        return (KeyStore)Assert.assertNotNull((Object)((KeyStore)serviceController.getValue()));
    }

    static KeyStore getModifiableKeyStore(OperationContext context) throws OperationFailedException {
        return ModifiableKeyStoreDecorator.getModifiableKeyStoreService(context).getModifiableValue();
    }

    static ModifiableKeyStoreService getModifiableKeyStoreService(OperationContext context) throws OperationFailedException {
        PathAddress currentAddress;
        RuntimeCapability runtimeCapability;
        ServiceName serviceName;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName = (runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability((currentAddress = context.getCurrentAddress()).getLastElement().getValue())).getCapabilityServiceName(), KeyStore.class);
        ServiceController.State serviceState = serviceContainer.getState();
        if (serviceState != ServiceController.State.UP) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
        }
        return (ModifiableKeyStoreService)serviceContainer.getService();
    }

    static class RemoveAliasHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, false).setAllowExpression(false)).build();

        RemoveAliasHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove-alias", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS}).setRuntimeOnly().build(), (OperationStepHandler)new RemoveAliasHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            KeyStore keyStore = ModifiableKeyStoreDecorator.getModifiableKeyStore(context);
            try {
                keyStore.deleteEntry(alias);
            }
            catch (KeyStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    static class ReadAliasHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, false).setAllowExpression(false)).build();

        ReadAliasHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            SimpleOperationDefinition READ_ALIAS = new SimpleOperationDefinitionBuilder("read-alias", descriptionResolver).setParameters(new AttributeDefinition[]{ALIAS}).setReadOnly().setRuntimeOnly().build();
            resourceRegistration.registerOperationHandler((OperationDefinition)READ_ALIAS, (OperationStepHandler)new ReadAliasHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String alias = ALIAS.resolveModelAttribute(context, operation).asString();
            KeyStore keyStore = ModifiableKeyStoreDecorator.getKeyStore(context);
            try {
                Certificate[] chain;
                ModelNode result = context.getResult();
                if (!keyStore.containsAlias(alias)) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef("Alias [%s] does not exists in KeyStore", new Object[0]);
                    return;
                }
                result.get("alias").set(alias);
                result.get("entry-type").set(this.getEntryType(keyStore, alias));
                Date creationDate = keyStore.getCreationDate(alias);
                if (creationDate != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    result.get("creation-date").set(sdf.format(creationDate));
                }
                if ((chain = keyStore.getCertificateChain(alias)) == null) {
                    Certificate cert = keyStore.getCertificate(alias);
                    if (cert != null) {
                        CertificateChainAttributeDefinitions.writeCertificate(result.get("certificate"), cert);
                    }
                } else {
                    CertificateChainAttributeDefinitions.writeCertificates(result.get("certificate-chain"), chain);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        private String getEntryType(KeyStore keyStore, String alias) throws KeyStoreException {
            if (keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                return KeyStore.PrivateKeyEntry.class.getSimpleName();
            }
            if (keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                return KeyStore.SecretKeyEntry.class.getSimpleName();
            }
            if (keyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                return KeyStore.TrustedCertificateEntry.class.getSimpleName();
            }
            if (keyStore.entryInstanceOf(alias, PasswordEntry.class)) {
                return PasswordEntry.class.getSimpleName();
            }
            return "Other";
        }
    }

    static class ReadAliasesHandler
    extends ElytronRuntimeOnlyHandler {
        ReadAliasesHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            SimpleOperationDefinition READ_ALIASES = new SimpleOperationDefinitionBuilder("read-aliases", descriptionResolver).setReadOnly().setRuntimeOnly().build();
            resourceRegistration.registerOperationHandler((OperationDefinition)READ_ALIASES, (OperationStepHandler)new ReadAliasesHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            KeyStore keyStore = ModifiableKeyStoreDecorator.getKeyStore(context);
            try {
                ModelNode result = context.getResult();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    result.add(aliases.nextElement());
                }
            }
            catch (KeyStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }
}

