/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron._private;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Policy;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.x500.cert.acme.AcmeException;

public class ElytronSubsystemMessages_$logger
extends DelegatingBasicLogger
implements ElytronSubsystemMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronSubsystemMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronSubsystemMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String duplicateRealmInjection$str() {
        return "WFLYELY00002: Can not inject the same realm '%s' in a single security domain.";
    }

    @Override
    public final OperationFailedException duplicateRealmInjection(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.duplicateRealmInjection$str(), realmName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String operationAddressMissingKey$str() {
        return "WFLYELY00003: The operation did not contain an address with a value for '%s'.";
    }

    @Override
    public final IllegalArgumentException operationAddressMissingKey(String key) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.operationAddressMissingKey$str(), key));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToStartService$str() {
        return "WFLYELY00004: Unable to start the service.";
    }

    @Override
    public final StartException unableToStartService(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToStartService$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAccessKeyStore$str() {
        return "WFLYELY00005: Unable to access KeyStore to complete the requested operation.";
    }

    @Override
    public final OperationFailedException unableToAccessKeyStore(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToAccessKeyStore$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requiredServiceNotUp$str() {
        return "WFLYELY00007: The required service '%s' is not UP, it is currently '%s'.";
    }

    @Override
    public final OperationFailedException requiredServiceNotUp(ServiceName serviceName, ServiceController.State state) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredServiceNotUp$str(), serviceName, state));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidOperationName$str() {
        return "WFLYELY00008: Invalid operation name '%s', expected one of '%s'";
    }

    @Override
    public final OperationFailedException invalidOperationName(String actualName, String ... expectedNames) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidOperationName$str(), actualName, Arrays.toString(expectedNames)));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCompleteOperation$str() {
        return "WFLYELY00009: Unable to complete operation. '%s'";
    }

    @Override
    public final RuntimeException unableToCompleteOperation(Throwable cause, String causeMessage) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToCompleteOperation$str(), causeMessage), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cantSaveWithoutFile$str() {
        return "WFLYELY00010: Unable to save KeyStore - KeyStore file '%s' does not exist.";
    }

    @Override
    public final OperationFailedException cantSaveWithoutFile(String file) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cantSaveWithoutFile$str(), file));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuitableProvider$str() {
        return "WFLYELY00012: No suitable provider found for type '%s'";
    }

    @Override
    public final StartException noSuitableProvider(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noSuitableProvider$str(), type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String defaultRealmNotReferenced$str() {
        return "WFLYELY00013: The default-realm '%s' is not in the list of realms [%s] referenced by this domain.";
    }

    @Override
    public final OperationFailedException defaultRealmNotReferenced(String defaultRealm, String realms) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.defaultRealmNotReferenced$str(), defaultRealm, realms));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadPropertiesFiles$str() {
        return "WFLYELY00014: Unable to load the properties files required to start the properties file backed realm: Users file: '%s' Groups file: '%s'";
    }

    @Override
    public final StartException unableToLoadPropertiesFiles(Exception cause, String usersFile, String groupsFile) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLoadPropertiesFiles$str(), usersFile, groupsFile), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentNotConfigurable$str() {
        return "WFLYELY00015: The custom component implementation '%s' does not implement method initialize(Map<String, String>), however configuration has been supplied.";
    }

    @Override
    public final StartException componentNotConfigurable(String className, Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.componentNotConfigurable$str(), className), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRegularExpression$str() {
        return "WFLYELY00016: The supplied regular expression '%s' is invalid.";
    }

    @Override
    public final OperationFailedException invalidRegularExpression(String pattern, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidRegularExpression$str(), pattern), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyFilesDoesNotExist$str() {
        return "WFLYELY00017: Property file referenced in properties-realm does not exist: %s";
    }

    @Override
    public final StartException propertyFilesDoesNotExist(String file) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.propertyFilesDoesNotExist$str(), file));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateManagerFactory$str() {
        return "WFLYELY00018: Unable to create %s for algorithm '%s'.";
    }

    @Override
    public final StartException unableToCreateManagerFactory(String type, String algorithm) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToCreateManagerFactory$str(), type, algorithm));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noTypeFound$str() {
        return "WFLYELY00019: No '%s' found in injected value.";
    }

    @Override
    public final StartException noTypeFound(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.noTypeFound$str(), type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReLoadPropertiesFiles$str() {
        return "WFLYELY00020: Unable to reload the properties files required to by the properties file backed realm.";
    }

    @Override
    public final OperationFailedException unableToReLoadPropertiesFiles(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToReLoadPropertiesFiles$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String exceptionWhileCreatingPermission$str() {
        return "WFLYELY00021: Exception while creating the permission object for the permission mapping. Please check [class-name], [target-name] (name of permission) and [action] of [%s].";
    }

    @Override
    public final StartException exceptionWhileCreatingPermission(String permissionClassName, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.exceptionWhileCreatingPermission$str(), permissionClassName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreFileNotExists$str() {
        return "WFLYELY00022: KeyStore file '%s' does not exist and required.";
    }

    @Override
    public final StartException keyStoreFileNotExists(String file) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.keyStoreFileNotExists$str(), file));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void keyStoreFileNotExistsButIgnored(String file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.keyStoreFileNotExistsButIgnored$str(), (Object)file);
    }

    protected String keyStoreFileNotExistsButIgnored$str() {
        return "WFLYELY00023: KeyStore file '%s' does not exist. Used blank.";
    }

    @Override
    public final void certificateNotValid(String alias, Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.certificateNotValid$str(), (Object)alias);
    }

    protected String certificateNotValid$str() {
        return "WFLYELY00024: Certificate [%s] in KeyStore is not valid";
    }

    protected String propertyFileIsInvalid$str() {
        return "WFLYELY00025: Referenced property file is invalid: %s";
    }

    @Override
    public final StartException propertyFileIsInvalid(String message, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.propertyFileIsInvalid$str(), message), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainOidForX500Attribute$str() {
        return "WFLYELY00027: Unable to obtain OID for X.500 attribute '%s'";
    }

    @Override
    public final OperationFailedException unableToObtainOidForX500Attribute(String attribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainOidForX500Attribute$str(), attribute));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String x500AttributeMustBeDefined$str() {
        return "WFLYELY00028: The X.500 attribute must be defined by name or by OID";
    }

    @Override
    public final OperationFailedException x500AttributeMustBeDefined() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.x500AttributeMustBeDefined$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidURL$str() {
        return "WFLYELY00029: Failed to parse URL '%s'";
    }

    @Override
    public final OperationFailedException invalidURL(String url, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidURL$str(), url), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String realmDoesNotSupportCache$str() {
        return "WFLYELY00030: Realm '%s' does not support cache";
    }

    @Override
    public final StartException realmDoesNotSupportCache(String realmName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.realmDoesNotSupportCache$str(), realmName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAccessCRL$str() {
        return "WFLYELY00031: Unable to access CRL file.";
    }

    @Override
    public final StartException unableToAccessCRL(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToAccessCRL$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReloadCRL$str() {
        return "WFLYELY00032: Unable to reload CRL file.";
    }

    @Override
    public final RuntimeException unableToReloadCRL(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToReloadCRL$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAccessEntryFromKeyStore$str() {
        return "WFLYELY00033: Unable to access entry [%s] from key store [%s].";
    }

    @Override
    public final RuntimeException unableToAccessEntryFromKeyStore(String alias, String keyStore) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToAccessEntryFromKeyStore$str(), alias, keyStore));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jdbcRealmOnlySingleKeyMapperAllowed$str() {
        return "WFLYELY00034: A principal query can only have a single key mapper";
    }

    @Override
    public final OperationFailedException jdbcRealmOnlySingleKeyMapperAllowed() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jdbcRealmOnlySingleKeyMapperAllowed$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadModule$str() {
        return "WFLYELY00035: Unable to load module '%s'.";
    }

    @Override
    public final OperationFailedException unableToLoadModule(String module, Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadModule$str(), module), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String realmRefererencedTwice$str() {
        return "WFLYELY00036: Security realm '%s' has been referenced twice in the same security domain.";
    }

    @Override
    public final OperationFailedException realmRefererencedTwice(String realmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.realmRefererencedTwice$str(), realmName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeInjected$str() {
        return "WFLYELY00037: Injected value is not of '%s' type.";
    }

    @Override
    public final StartException invalidTypeInjected(String type) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidTypeInjected$str(), type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPermissionClass$str() {
        return "WFLYELY00038: Could not load permission class '%s'";
    }

    @Override
    public final StartException invalidPermissionClass(String className) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPermissionClass$str(), className));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReloadCRLNotReloadable$str() {
        return "WFLYELY00039: Unable to reload CRL file - TrustManager is not reloadable";
    }

    @Override
    public final OperationFailedException unableToReloadCRLNotReloadable() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToReloadCRLNotReloadable$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPermissionModule$str() {
        return "WFLYELY00040: Unable to load the permission module '%s' for the permission mapping";
    }

    @Override
    public final StartException invalidPermissionModule(String module, Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPermissionModule$str(), module), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToTransformTornAttribute$str() {
        return "WFLYELY00041: Unable to transform configuration to the target version - attribute '%s' is different from '%s'";
    }

    @Override
    public final String unableToTransformTornAttribute(String attribute1, String attribute2) {
        return String.format(this.getLoggingLocale(), this.unableToTransformTornAttribute$str(), attribute1, attribute2);
    }

    protected String unableToTransformMultipleRealms$str() {
        return "WFLYELY00042: Unable to transform multiple 'authorization-realms' to the single value";
    }

    @Override
    public final String unableToTransformMultipleRealms() {
        return String.format(this.getLoggingLocale(), this.unableToTransformMultipleRealms$str(), new Object[0]);
    }

    protected String cycleDetected$str() {
        return "WFLYELY00043: A cycle has been detected initialising the resources - %s";
    }

    @Override
    public final OperationFailedException cycleDetected(String cycle) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cycleDetected$str(), cycle));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidServiceNameParent$str() {
        return "WFLYELY00044: Unexpected name of servicename's parent - %s";
    }

    @Override
    public final IllegalStateException invalidServiceNameParent(String canonicalName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidServiceNameParent$str(), canonicalName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadCallbackhandlerFromProvidedModule$str() {
        return "WFLYELY00045: Failed to load CallbackHandler from the provided module.";
    }

    @Override
    public final IllegalStateException failedToLoadCallbackhandlerFromProvidedModule() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToLoadCallbackhandlerFromProvidedModule$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jaasFileDoesNotExist$str() {
        return "WFLYELY00046: Provided path '%s' to JAAS configuration file does not exist.";
    }

    @Override
    public final StartException jaasFileDoesNotExist(String path) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.jaasFileDoesNotExist$str(), path));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ldapRealmDirectVerificationAndUserPasswordMapper() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ldapRealmDirectVerificationAndUserPasswordMapper$str(), new Object[0]);
    }

    protected String ldapRealmDirectVerificationAndUserPasswordMapper$str() {
        return "WFLYELY00047: LDAP Realm is configured to use direct-verification and user-password-mapper which is invalid configuration.";
    }

    protected String representationOfX500IsRequired$str() {
        return "WFLYELY00048: A string representation of an X.500 distinguished name is required: %s";
    }

    @Override
    public final IllegalArgumentException representationOfX500IsRequired(String causeMessage) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.representationOfX500IsRequired$str(), causeMessage));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialStoreEntryTypeNotSupported$str() {
        return "WFLYELY00909: Credential store '%s' does not support given credential store entry type '%s'";
    }

    @Override
    public final OperationFailedException credentialStoreEntryTypeNotSupported(String credentialStoreName, String entryType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialStoreEntryTypeNotSupported$str(), credentialStoreName, entryType));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStorePasswordCannotBeResolved$str() {
        return "WFLYELY00910: Password cannot be resolved for key-store '%s'";
    }

    @Override
    public final IOException keyStorePasswordCannotBeResolved(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.keyStorePasswordCannotBeResolved$str(), path));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialStoreProtectionParameterCannotBeResolved$str() {
        return "WFLYELY00911: Credential store '%s' protection parameter cannot be resolved";
    }

    @Override
    public final IOException credentialStoreProtectionParameterCannotBeResolved(String name) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.credentialStoreProtectionParameterCannotBeResolved$str(), name));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialAlreadyExists$str() {
        return "WFLYELY00913: Credential alias '%s' of credential type '%s' already exists in the store";
    }

    @Override
    public final OperationFailedException credentialAlreadyExists(String alias, String credentialType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialAlreadyExists$str(), alias, credentialType));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String providerLoaderCannotSupplyProvider$str() {
        return "WFLYELY00914: Provider loader '%s' cannot supply Credential Store provider of type '%s'";
    }

    @Override
    public final NoSuchProviderException providerLoaderCannotSupplyProvider(String providerLoader, String type) {
        NoSuchProviderException result = new NoSuchProviderException(String.format(this.getLoggingLocale(), this.providerLoaderCannotSupplyProvider$str(), providerLoader, type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialCannotBeResolved$str() {
        return "WFLYELY00916: Credential cannot be resolved";
    }

    @Override
    public final IllegalStateException credentialCannotBeResolved() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.credentialCannotBeResolved$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String dirContextPasswordCannotBeResolved$str() {
        return "WFLYELY00917: Password cannot be resolved for dir-context";
    }

    @Override
    public final StartException dirContextPasswordCannotBeResolved(Exception cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.dirContextPasswordCannotBeResolved$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialDoesNotExist$str() {
        return "WFLYELY00920: Credential alias '%s' of credential type '%s' does not exist in the store";
    }

    @Override
    public final OperationFailedException credentialDoesNotExist(String alias, String credentialType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.credentialDoesNotExist$str(), alias, credentialType));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filebasedKeystoreLocationMissing$str() {
        return "WFLYELY00921: Location parameter is not specified for filebased keystore type '%s'";
    }

    @Override
    public final OperationFailedException filebasedKeystoreLocationMissing(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filebasedKeystoreLocationMissing$str(), type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String reloadDependantServices$str() {
        return "Reload dependent services which might already have cached the secret value";
    }

    @Override
    public final String reloadDependantServices() {
        return String.format(this.getLoggingLocale(), this.reloadDependantServices$str(), new Object[0]);
    }

    protected String updateDependantServices$str() {
        return "Update dependent resources as alias '%s' does not exist anymore";
    }

    @Override
    public final String updateDependantServices(String alias) {
        return String.format(this.getLoggingLocale(), this.updateDependantServices$str(), alias);
    }

    protected String unableToLoadCredential$str() {
        return "WFLYELY00922: Unable to load credential from credential store.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException unableToLoadCredential(Throwable cause) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.unableToLoadCredential$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToEncryptClearText$str() {
        return "WFLYELY00923: Unable to encrypt the supplied clear text.";
    }

    @Override
    public final OperationFailedException unableToEncryptClearText(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToEncryptClearText$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateCredentialStoreImmediately$str() {
        return "WFLYELY00924: Unable to create immediately available credential store.";
    }

    @Override
    public final OperationFailedException unableToCreateCredentialStoreImmediately(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToCreateCredentialStoreImmediately$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReloadCredentialStore$str() {
        return "WFLYELY00925: Unable to reload the credential store.";
    }

    @Override
    public final OperationFailedException unableToReloadCredentialStore(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToReloadCredentialStore$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInitialiseCredentialStore$str() {
        return "WFLYELY00926: Unable to initialize the credential store.";
    }

    @Override
    public final OperationFailedException unableToInitialiseCredentialStore(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToInitialiseCredentialStore$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String secretKeyOperationFailed$str() {
        return "WFLYELY00927: The secret key operation '%s' failed to complete due to '%s'.";
    }

    @Override
    public final OperationFailedException secretKeyOperationFailed(String operationName, String error, Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.secretKeyOperationFailed$str(), operationName, error), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String identityAlreadyExists$str() {
        return "WFLYELY01000: Identity with name [%s] already exists.";
    }

    @Override
    public final OperationFailedException identityAlreadyExists(String principalName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.identityAlreadyExists$str(), principalName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateIdentity$str() {
        return "WFLYELY01001: Could not create identity with name [%s].";
    }

    @Override
    public final RuntimeException couldNotCreateIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotCreateIdentity$str(), principalName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String identityNotFound$str() {
        return "WFLYELY01002: Identity with name [%s] not found.";
    }

    @Override
    public final String identityNotFound(String principalName) {
        return String.format(this.getLoggingLocale(), this.identityNotFound$str(), principalName);
    }

    protected String couldNotDeleteIdentity$str() {
        return "WFLYELY01003: Could not delete identity with name [%s].";
    }

    @Override
    public final RuntimeException couldNotDeleteIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotDeleteIdentity$str(), principalName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String identityNotAuthorized$str() {
        return "WFLYELY01004: Identity with name [%s] not authorized.";
    }

    @Override
    public final String identityNotAuthorized(String principalName) {
        return String.format(this.getLoggingLocale(), this.identityNotAuthorized$str(), principalName);
    }

    protected String couldNotReadIdentity2$str() {
        return "WFLYELY01005: Could not read identity [%s] from security domain [%s].";
    }

    @Override
    public final RuntimeException couldNotReadIdentity(String principalName, ServiceName domainServiceName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotReadIdentity2$str(), principalName, domainServiceName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotReadIdentity1$str() {
        return "WFLYELY01007: Could not read identity with name [%s].";
    }

    @Override
    public final RuntimeException couldNotReadIdentity(String principalName, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotReadIdentity1$str(), principalName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotObtainAuthorizationIdentity$str() {
        return "WFLYELY01008: Failed to obtain the authorization identity.";
    }

    @Override
    public final RuntimeException couldNotObtainAuthorizationIdentity(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainAuthorizationIdentity$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotAddAttribute$str() {
        return "WFLYELY01009: Failed to add attribute.";
    }

    @Override
    public final RuntimeException couldNotAddAttribute(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotAddAttribute$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotRemoveAttribute$str() {
        return "WFLYELY01010: Failed to remove attribute.";
    }

    @Override
    public final RuntimeException couldNotRemoveAttribute(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotRemoveAttribute$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreatePassword$str() {
        return "WFLYELY01011: Could not create password.";
    }

    @Override
    public final RuntimeException couldNotCreatePassword(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotCreatePassword$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedPasswordType$str() {
        return "WFLYELY01012: Unexpected password type [%s].";
    }

    @Override
    public final OperationFailedException unexpectedPasswordType(String passwordType) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unexpectedPasswordType$str(), passwordType));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String patternRequiresCaptureGroup$str() {
        return "WFLYELY01013: Pattern [%s] requires a capture group";
    }

    @Override
    public final OperationFailedException patternRequiresCaptureGroup(String pattern) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.patternRequiresCaptureGroup$str(), pattern));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDefinition$str() {
        return "WFLYELY01014: Invalid [%s] definition. Only one of '%s' or '%s' can be set in one Object in the list of filters.";
    }

    @Override
    public final OperationFailedException invalidDefinition(String property, String filterNameOne, String filterNameTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidDefinition$str(), property, filterNameOne, filterNameTwo));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToPerformOutflow$str() {
        return "WFLYELY01015: Unable to perform automatic outflow for '%s'";
    }

    @Override
    public final IllegalStateException unableToPerformOutflow(String identityName, Exception cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToPerformOutflow$str(), identityName), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverNotKnown$str() {
        return "WFLYELY01016: Server '%s' not known";
    }

    @Override
    public final OperationFailedException serverNotKnown(String server, UnknownHostException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.serverNotKnown$str(), server), (Throwable)e);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCipherSuiteFilter$str() {
        return "WFLYELY01017: Invalid value for cipher-suite-filter. %s";
    }

    @Override
    public final OperationFailedException invalidCipherSuiteFilter(Throwable cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCipherSuiteFilter$str(), causeMessage), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSize$str() {
        return "WFLYELY01018: Invalid size %s";
    }

    @Override
    public final OperationFailedException invalidSize(String size) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSize$str(), size));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String suffixContainsMillis$str() {
        return "WFLYELY01019: The suffix (%s) can not contain seconds or milliseconds.";
    }

    @Override
    public final OperationFailedException suffixContainsMillis(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.suffixContainsMillis$str(), suffix));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSuffix$str() {
        return "WFLYELY01020: The suffix (%s) is invalid. A suffix must be a valid date format.";
    }

    @Override
    public final OperationFailedException invalidSuffix(String suffix) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidSuffix$str(), suffix));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToSetPolicy$str() {
        return "WFLYELY01022: Failed to set policy [%s]";
    }

    @Override
    public final RuntimeException failedToSetPolicy(Policy policy, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToSetPolicy$str(), policy), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindPolicyProvider$str() {
        return "WFLYELY01023: Could not find policy provider with name [%s]";
    }

    @Override
    public final XMLStreamException cannotFindPolicyProvider(String policyProvider, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.cannotFindPolicyProvider$str(), policyProvider), location);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToRegisterPolicyHandlers$str() {
        return "WFLYELY01024: Failed to register policy context handlers";
    }

    @Override
    public final RuntimeException failedToRegisterPolicyHandlers(Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToRegisterPolicyHandlers$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreatePolicy$str() {
        return "WFLYELY01025: Failed to create policy [%s]";
    }

    @Override
    public final RuntimeException failedToCreatePolicy(String className, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreatePolicy$str(), className), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void discardingUnusedPolicy(String element, String attr, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.discardingUnusedPolicy$str(), (Object)element, (Object)attr, (Object)name);
    }

    protected String discardingUnusedPolicy$str() {
        return "WFLYELY01026: Element '%s' with attribute '%s' set to '%s' is unused. Since unused policy configurations can no longer be stored in the configuration model this item is being discarded.";
    }

    protected String keyPasswordCannotBeResolved$str() {
        return "WFLYELY01027: Key password cannot be resolved for key-store '%s'";
    }

    @Override
    public final IOException keyPasswordCannotBeResolved(String path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.keyPasswordCannotBeResolved$str(), path));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNotBefore$str() {
        return "WFLYELY01028: Invalid value for not-before. %s";
    }

    @Override
    public final OperationFailedException invalidNotBefore(Throwable cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidNotBefore$str(), causeMessage), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreAliasDoesNotExist$str() {
        return "WFLYELY01029: Alias '%s' does not exist in KeyStore";
    }

    @Override
    public final OperationFailedException keyStoreAliasDoesNotExist(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasDoesNotExist$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str() {
        return "WFLYELY01030: Alias '%s' does not identify a PrivateKeyEntry in KeyStore";
    }

    @Override
    public final OperationFailedException keyStoreAliasDoesNotIdentifyPrivateKeyEntry(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasDoesNotIdentifyPrivateKeyEntry$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainPrivateKey$str() {
        return "WFLYELY01031: Unable to obtain PrivateKey for alias '%s'";
    }

    @Override
    public final OperationFailedException unableToObtainPrivateKey(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainPrivateKey$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainCertificate$str() {
        return "WFLYELY01032: Unable to obtain Certificate for alias '%s'";
    }

    @Override
    public final OperationFailedException unableToObtainCertificate(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainCertificate$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noCertificatesFoundInCertificateReply$str() {
        return "WFLYELY01033: No certificates found in certificate reply";
    }

    @Override
    public final OperationFailedException noCertificatesFoundInCertificateReply() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noCertificatesFoundInCertificateReply$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String publicKeyFromCertificateReplyDoesNotMatchKeyStore$str() {
        return "WFLYELY01034: Public key from certificate reply does not match public key from certificate in KeyStore";
    }

    @Override
    public final OperationFailedException publicKeyFromCertificateReplyDoesNotMatchKeyStore() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.publicKeyFromCertificateReplyDoesNotMatchKeyStore$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateReplySameAsCertificateFromKeyStore$str() {
        return "WFLYELY01035: Certificate reply is the same as the certificate from PrivateKeyEntry in KeyStore";
    }

    @Override
    public final OperationFailedException certificateReplySameAsCertificateFromKeyStore() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateReplySameAsCertificateFromKeyStore$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreAliasAlreadyExists$str() {
        return "WFLYELY01036: Alias '%s' already exists in KeyStore";
    }

    @Override
    public final OperationFailedException keyStoreAliasAlreadyExists(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.keyStoreAliasAlreadyExists$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String topMostCertificateFromCertificateReplyNotTrusted$str() {
        return "WFLYELY01037: Top-most certificate from certificate reply is not trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    }

    @Override
    public final OperationFailedException topMostCertificateFromCertificateReplyNotTrusted() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.topMostCertificateFromCertificateReplyNotTrusted$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String trustedCertificateAlreadyInKeyStore$str() {
        return "WFLYELY01038: Trusted certificate is already in KeyStore under alias '%s'";
    }

    @Override
    public final OperationFailedException trustedCertificateAlreadyInKeyStore(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.trustedCertificateAlreadyInKeyStore$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String trustedCertificateAlreadyInCacertsKeyStore$str() {
        return "WFLYELY01039: Trusted certificate is already in cacerts KeyStore under alias '%s'";
    }

    @Override
    public final OperationFailedException trustedCertificateAlreadyInCacertsKeyStore(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.trustedCertificateAlreadyInCacertsKeyStore$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetermineIfCertificateIsTrusted$str() {
        return "WFLYELY01040: Unable to determine if the certificate is trusted. Inspect the certificate carefully and if it is valid, execute import-certificate again with validate set to false.";
    }

    @Override
    public final OperationFailedException unableToDetermineIfCertificateIsTrusted() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToDetermineIfCertificateIsTrusted$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateFileDoesNotExist$str() {
        return "WFLYELY01041: Certificate file does not exist";
    }

    @Override
    public final OperationFailedException certificateFileDoesNotExist(Exception cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateFileDoesNotExist$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainEntry$str() {
        return "WFLYELY01042: Unable to obtain Entry for alias '%s'";
    }

    @Override
    public final OperationFailedException unableToObtainEntry(String alias) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToObtainEntry$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateAccountWithCertificateAuthority$str() {
        return "WFLYELY01043: Unable to create an account with the certificate authority: %s";
    }

    @Override
    public final OperationFailedException unableToCreateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToCreateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToChangeAccountKeyWithCertificateAuthority$str() {
        return "WFLYELY01044: Unable to change the account key associated with the certificate authority: %s";
    }

    @Override
    public final OperationFailedException unableToChangeAccountKeyWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToChangeAccountKeyWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDeactivateAccountWithCertificateAuthority$str() {
        return "WFLYELY01045: Unable to deactivate the account associated with the certificate authority: %s";
    }

    @Override
    public final OperationFailedException unableToDeactivateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToDeactivateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainCertificateAuthorityAccountCertificate$str() {
        return "WFLYELY01046: Unable to obtain certificate authority account Certificate for alias '%s'";
    }

    @Override
    public final StartException unableToObtainCertificateAuthorityAccountCertificate(String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToObtainCertificateAuthorityAccountCertificate$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToObtainCertificateAuthorityAccountPrivateKey$str() {
        return "WFLYELY01047: Unable to obtain certificate authority account PrivateKey for alias '%s'";
    }

    @Override
    public final StartException unableToObtainCertificateAuthorityAccountPrivateKey(String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToObtainCertificateAuthorityAccountPrivateKey$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToUpdateCertificateAuthorityAccountKeyStore$str() {
        return "WFLYELY01048: Unable to update certificate authority account key store: %s";
    }

    @Override
    public final OperationFailedException unableToUpdateCertificateAuthorityAccountKeyStore(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToUpdateCertificateAuthorityAccountKeyStore$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToRespondToCertificateAuthorityChallenge$str() {
        return "WFLYELY01049: Unable to respond to challenge from certificate authority: %s";
    }

    @Override
    public final AcmeException unableToRespondToCertificateAuthorityChallenge(Exception cause, String causeMessage) {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.unableToRespondToCertificateAuthorityChallenge$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCertificateAuthorityChallenge$str() {
        return "WFLYELY01050: Invalid certificate authority challenge";
    }

    @Override
    public final AcmeException invalidCertificateAuthorityChallenge() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.invalidCertificateAuthorityChallenge$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCertificateRevocationReason$str() {
        return "WFLYELY01051: Invalid certificate revocation reason '%s'";
    }

    @Override
    public final OperationFailedException invalidCertificateRevocationReason(String reason) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCertificateRevocationReason$str(), reason));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstatiateAcmeClientSpiImplementation$str() {
        return "WFLYELY01052: Unable to instantiate AcmeClientSpi implementation";
    }

    @Override
    public final IllegalStateException unableToInstatiateAcmeClientSpiImplementation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToInstatiateAcmeClientSpiImplementation$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToUpdateAccountWithCertificateAuthority$str() {
        return "WFLYELY01053: Unable to update the account with the certificate authority: %s";
    }

    @Override
    public final OperationFailedException unableToUpdateAccountWithCertificateAuthority(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToUpdateAccountWithCertificateAuthority$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToGetCertificateAuthorityMetadata$str() {
        return "WFLYELY01054: Unable to get the metadata associated with the certificate authority: %s";
    }

    @Override
    public final OperationFailedException unableToGetCertificateAuthorityMetadata(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToGetCertificateAuthorityMetadata$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKeySize$str() {
        return "WFLYELY01055: Invalid key size: %d";
    }

    @Override
    public final OperationFailedException invalidKeySize(int keySize) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidKeySize$str(), keySize));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateAuthorityAccountAlreadyExists$str() {
        return "WFLYELY01056: A certificate authority account with this account key already exists. To update the contact information associated with this existing account, use %s. To change the key associated with this existing account, use %s.";
    }

    @Override
    public final OperationFailedException certificateAuthorityAccountAlreadyExists(String updateAccount, String changeAccountKey) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.certificateAuthorityAccountAlreadyExists$str(), updateAccount, changeAccountKey));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreateServerAuthModule$str() {
        return "WFLYELY01057: Failed to create ServerAuthModule [%s] using module '%s'";
    }

    @Override
    public final RuntimeException failedToCreateServerAuthModule(String className, String module, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToCreateServerAuthModule$str(), className, module), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParsePEMPublicKey$str() {
        return "WFLYELY01058: Failed to parse PEM public key with kid: %s";
    }

    @Override
    public final OperationFailedException failedToParsePEMPublicKey(String kid) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToParsePEMPublicKey$str(), kid));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDetectKeyStore$str() {
        return "WFLYELY01059: Unable to detect KeyStore '%s'";
    }

    @Override
    public final StartException unableToDetectKeyStore(String path) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToDetectKeyStore$str(), path));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filelessKeyStoreMissingType$str() {
        return "WFLYELY01060: Fileless KeyStore needs to have a defined type.";
    }

    @Override
    public final OperationFailedException filelessKeyStoreMissingType() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filelessKeyStoreMissingType$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHostContextMapValue$str() {
        return "WFLYELY01061: Invalid value of host context map: '%s' is not valid hostname pattern.";
    }

    @Override
    public final OperationFailedException invalidHostContextMapValue(String hostname) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidHostContextMapValue$str(), hostname));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAttributeValue$str() {
        return "WFLYELY01062: Value for attribute '%s' is invalid.";
    }

    @Override
    public final OperationFailedException invalidAttributeValue(String attributeName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidAttributeValue$str(), attributeName));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String letsEncryptNameNotAllowed$str() {
        return "WFLYELY01063: LetsEncrypt certificate authority is configured by default.";
    }

    @Override
    public final OperationFailedException letsEncryptNameNotAllowed() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.letsEncryptNameNotAllowed$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLoadResponderCert$str() {
        return "WFLYELY01064: Failed to load OCSP responder certificate '%s'.";
    }

    @Override
    public final StartException failedToLoadResponderCert(String alias, Exception exception) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToLoadResponderCert$str(), alias), (Throwable)exception);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleMaximumCertPathDefinitions$str() {
        return "WFLYELY01065: Multiple maximum-cert-path definitions found.";
    }

    @Override
    public final OperationFailedException multipleMaximumCertPathDefinitions() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.multipleMaximumCertPathDefinitions$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCipherSuiteNames$str() {
        return "WFLYELY01066: Invalid value for cipher-suite-names. %s";
    }

    @Override
    public final OperationFailedException invalidCipherSuiteNames(Throwable cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCipherSuiteNames$str(), causeMessage), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRegex$str() {
        return "WFLYELY01067: Value '%s' is not valid regex.";
    }

    @Override
    public final OperationFailedException invalidRegex(String regex) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidRegex$str(), regex));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicatePolicyContextHandler$str() {
        return "WFLYELY01068: Duplicate PolicyContextHandler found for key '%s'.";
    }

    @Override
    public final IllegalStateException duplicatePolicyContextHandler(String key) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.duplicatePolicyContextHandler$str(), key));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidImplementationLoaded$str() {
        return "WFLYELY01069: Invalid %s loaded, expected %s but received %s.";
    }

    @Override
    public final IllegalStateException invalidImplementationLoaded(String type, String expected, String actual) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidImplementationLoaded$str(), type, expected, actual));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadModuleRuntime$str() {
        return "WFLYELY01079: Unable to load module '%s'.";
    }

    @Override
    public final RuntimeException unableToLoadModuleRuntime(String module, Exception cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToLoadModuleRuntime$str(), module), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonexistingKeyStoreMissingType$str() {
        return "WFLYELY01080: Non existing key store needs to have defined type.";
    }

    @Override
    public final OperationFailedException nonexistingKeyStoreMissingType() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nonexistingKeyStoreMissingType$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToLazilyInitKeyManager$str() {
        return "WFLYELY01081: Failed to lazily initialize key manager";
    }

    @Override
    public final RuntimeException failedToLazilyInitKeyManager(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLazilyInitKeyManager$str(), new Object[0]), e);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToStoreGeneratedSelfSignedCertificate$str() {
        return "WFLYELY01082: Failed to store generated self-signed certificate";
    }

    @Override
    public final RuntimeException failedToStoreGeneratedSelfSignedCertificate(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToStoreGeneratedSelfSignedCertificate$str(), new Object[0]), e);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noTypeFoundForLazyInitKeyManager$str() {
        return "WFLYELY01083: No '%s' found in injected value.";
    }

    @Override
    public final RuntimeException noTypeFoundForLazyInitKeyManager(String type) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.noTypeFoundForLazyInitKeyManager$str(), type));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void selfSignedCertificateWillBeCreated(String file, String host) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.selfSignedCertificateWillBeCreated$str(), (Object)file, (Object)host);
    }

    protected String selfSignedCertificateWillBeCreated$str() {
        return "WFLYELY01084: KeyStore %s not found, it will be auto generated on first use with a self-signed certificate for host %s";
    }

    @Override
    public final void selfSignedCertificateHasBeenCreated(String file, String sha1, String sha256) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.selfSignedCertificateHasBeenCreated$str(), (Object)file, (Object)sha1, (Object)sha256);
    }

    protected String selfSignedCertificateHasBeenCreated$str() {
        return "WFLYELY01085: Generated self-signed certificate at %s. Please note that self-signed certificates are not secure and should only be used for testing purposes. Do not use this self-signed certificate in production.\nSHA-1 fingerprint of the generated key is %s\nSHA-256 fingerprint of the generated key is %s";
    }

    protected String unableToEnableJaccSupport$str() {
        return "WFLYELY01086: Unable to initialize Elytron JACC support while legacy JACC support is enabled.";
    }

    @Override
    public final IllegalStateException unableToEnableJaccSupport() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToEnableJaccSupport$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostContextMapHostnameContainsCaret$str() {
        return "WFLYELY01087: Hostname in SNI mapping cannot contain ^ character.";
    }

    @Override
    public final OperationFailedException hostContextMapHostnameContainsCaret() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.hostContextMapHostnameContainsCaret$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCertificateAuthorityChallenge$str() {
        return "WFLYELY01088: Missing certificate authority challenge";
    }

    @Override
    public final AcmeException missingCertificateAuthorityChallenge() {
        AcmeException result = new AcmeException(String.format(this.getLoggingLocale(), this.missingCertificateAuthorityChallenge$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noResolverSpecifiedAndNoDefault$str() {
        return "WFLYELY01200: The name of the resolver to use was not specified and no default-resolver has been defined.";
    }

    @Override
    public final OperationFailedException noResolverSpecifiedAndNoDefault() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noResolverSpecifiedAndNoDefault$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noResolverWithSpecifiedName$str() {
        return "WFLYELY01201: No expression resolver has been defined with the name '%s'.";
    }

    @Override
    public final OperationFailedException noResolverWithSpecifiedName(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noResolverWithSpecifiedName$str(), name));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cycleDetectedInitialisingExpressionResolver$str() {
        return "WFLYELY01202: A cycle has been detected initialising the expression resolver for '%s' and '%s'.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException cycleDetectedInitialisingExpressionResolver(String firstExpression, String secondExpression) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.cycleDetectedInitialisingExpressionResolver$str(), firstExpression, secondExpression));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expressionResolverInitialisationAlreadyFailed$str() {
        return "WFLYELY01203: Expression resolver initialisation has already failed.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException expressionResolverInitialisationAlreadyFailed(Throwable cause) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.expressionResolverInitialisationAlreadyFailed$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expressionResolutionWithoutResolver$str() {
        return "WFLYELY01204: The expression '%s' does not specify a resolver and no default is defined.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException expressionResolutionWithoutResolver(String expression) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.expressionResolutionWithoutResolver$str(), expression));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidResolver$str() {
        return "WFLYELY01205: The expression '%s' specifies a resolver configuration which does not exist.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException invalidResolver(String expression) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.invalidResolver$str(), expression));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDecryptExpression$str() {
        return "WFLYELY01206: Unable to decrypt expression '%s'.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException unableToDecryptExpression(String expression, Throwable cause) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.unableToDecryptExpression$str(), expression), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String modelStageResolutionNotSupported$str() {
        return "WFLYELY01207: Resolution of credential store expressions is not supported in the MODEL stage of operation execution.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionServerException modelStageResolutionNotSupported(IllegalStateException cause) {
        ExpressionResolver.ExpressionResolutionServerException result = new ExpressionResolver.ExpressionResolutionServerException(String.format(this.getLoggingLocale(), this.modelStageResolutionNotSupported$str(), new Object[0]), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToResolveCredentialStore$str() {
        return "WFLYELY01208: Unable to resolve CredentialStore %s -- %s";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionServerException unableToResolveCredentialStore(String storeName, String details, Exception cause) {
        ExpressionResolver.ExpressionResolutionServerException result = new ExpressionResolver.ExpressionResolutionServerException(String.format(this.getLoggingLocale(), this.unableToResolveCredentialStore$str(), storeName, details), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitializeCredentialStore$str() {
        return "WFLYELY01209: Unable to initialize CredentialStore %s -- %s";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionUserException unableToInitializeCredentialStore(String storeName, String details, Exception cause) {
        ExpressionResolver.ExpressionResolutionUserException result = new ExpressionResolver.ExpressionResolutionUserException(String.format(this.getLoggingLocale(), this.unableToInitializeCredentialStore$str(), storeName, details), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalNonManagementInitialization$str() {
        return "WFLYELY01210: Initialisation of an %s without an active management OperationContext is not allowed.";
    }

    @Override
    public final ExpressionResolver.ExpressionResolutionServerException illegalNonManagementInitialization(Class<?> initialzingClass) {
        ExpressionResolver.ExpressionResolutionServerException result = new ExpressionResolver.ExpressionResolutionServerException(String.format(this.getLoggingLocale(), this.illegalNonManagementInitialization$str(), initialzingClass));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadCredentialStore$str() {
        return "WFLYELY01211: Unable to load the credential store.";
    }

    @Override
    public final OperationFailedException unableToLoadCredentialStore(Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadCredentialStore$str(), new Object[0]), cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPrivateKey$str() {
        return "WFLYELY01212: KeyStore does not contain a PrivateKey for KeyStore: [%s] and alias: [%s].";
    }

    @Override
    public final StartException missingPrivateKey(String keyStore, String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.missingPrivateKey$str(), keyStore, alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPublicKey$str() {
        return "WFLYELY01213: KeyStore does not contain a PublicKey for KeyStore: [%s] and alias: [%s].";
    }

    @Override
    public final StartException missingPublicKey(String keyStore, String alias) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.missingPublicKey$str(), keyStore, alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToVerifyIntegrity$str() {
        return "WFLYELY01214: Unable to verify the integrity of the filesystem realm: %s";
    }

    @Override
    public final OperationFailedException unableToVerifyIntegrity(Exception cause, String causeMessage) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToVerifyIntegrity$str(), causeMessage), (Throwable)cause);
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filesystemMissingKeypair$str() {
        return "WFLYELY01215: Filesystem realm is missing key pair configuration, integrity checking is not enabled";
    }

    @Override
    public final OperationFailedException filesystemMissingKeypair() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filesystemMissingKeypair$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToGetKeyStorePassword$str() {
        return "WFLYELY01216: Filesystem realm is unable to obtain key store password";
    }

    @Override
    public final RuntimeException unableToGetKeyStorePassword() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToGetKeyStorePassword$str(), new Object[0]));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filesystemIntegrityInvalid$str() {
        return "WFLYELY01217: Realm verification failed, invalid signatures for the identities: %s";
    }

    @Override
    public final OperationFailedException filesystemIntegrityInvalid(String identities) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filesystemIntegrityInvalid$str(), identities));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreMissingAlias$str() {
        return "WFLYELY01218: Keystore used by filesystem realm does not contain the alias: %s";
    }

    @Override
    public final KeyStoreException keyStoreMissingAlias(String alias) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.keyStoreMissingAlias$str(), alias));
        ElytronSubsystemMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

