/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

class AggregateRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "aggregate-realm", SecurityRealm.class);
    static final SimpleAttributeDefinition AUTHENTICATION_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-realm", ModelType.STRING, false).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHORIZATION_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authorization-realm", ModelType.STRING, false).setMinSize(1)).setAlternatives(new String[]{"authorization-realms"})).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final StringListAttributeDefinition AUTHORIZATION_REALMS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("authorization-realms").setAlternatives(new String[]{"authorization-realm"})).setMinSize(1)).setCapabilityReference("org.wildfly.security.security-realm", "org.wildfly.security.security-realm")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-transformer", ModelType.STRING, true).setMinSize(1)).setCapabilityReference("org.wildfly.security.principal-transformer", "org.wildfly.security.security-realm")).setRestartAllServices()).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{AUTHENTICATION_REALM, AUTHORIZATION_REALM};
    static final AttributeDefinition[] ATTRIBUTES_8_0 = new AttributeDefinition[]{AUTHENTICATION_REALM, AUTHORIZATION_REALM, AUTHORIZATION_REALMS, PRINCIPAL_TRANSFORMER};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    AggregateRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"aggregate-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("aggregate-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES_8_0);
        for (AttributeDefinition current : ATTRIBUTES_8_0) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES_8_0);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            String authenticationRealm = AUTHENTICATION_REALM.resolveModelAttribute(context, model).asString();
            InjectedValue authenticationRealmValue = new InjectedValue();
            ArrayList<InjectedValue> authorizationRealmValues = new ArrayList<InjectedValue>();
            ModelNode authorizationRealmNode = AUTHORIZATION_REALM.resolveModelAttribute(context, model);
            String principalTransformer = PRINCIPAL_TRANSFORMER.resolveModelAttribute(context, model).asStringOrNull();
            InjectedValue principalTransformerValue = null;
            ServiceName principalTransformerServiceName = null;
            if (principalTransformer != null) {
                principalTransformerValue = new InjectedValue();
                String principalTransformerRuntimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.principal-transformer", (String)principalTransformer);
                principalTransformerServiceName = context.getCapabilityServiceName(principalTransformerRuntimeCapability, PrincipalTransformer.class);
            }
            InjectedValue finalPrincipalTransformerValue = principalTransformerValue;
            TrivialService<SecurityRealm> aggregateRealmService = new TrivialService<SecurityRealm>(() -> {
                SecurityRealm[] authorizationRealms = new SecurityRealm[authorizationRealmValues.size()];
                for (int i = 0; i < authorizationRealms.length; ++i) {
                    authorizationRealms[i] = (SecurityRealm)((InjectedValue)authorizationRealmValues.get(i)).getValue();
                }
                if (finalPrincipalTransformerValue != null) {
                    return new AggregateSecurityRealm((SecurityRealm)authenticationRealmValue.getValue(), (Function)finalPrincipalTransformerValue.getValue(), authorizationRealms);
                }
                return new AggregateSecurityRealm((SecurityRealm)authenticationRealmValue.getValue(), authorizationRealms);
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, aggregateRealmService);
            this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, authenticationRealm, (Injector<SecurityRealm>)authenticationRealmValue);
            if (principalTransformer != null) {
                serviceBuilder.addDependency(principalTransformerServiceName, PrincipalTransformer.class, (Injector)principalTransformerValue);
            }
            if (authorizationRealmNode.isDefined()) {
                String authorizationRealm = authorizationRealmNode.asString();
                InjectedValue authorizationRealmValue = new InjectedValue();
                this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, authorizationRealm, (Injector<SecurityRealm>)authorizationRealmValue);
                authorizationRealmValues.add(authorizationRealmValue);
            } else {
                List authorizationRealms = AUTHORIZATION_REALMS.unwrap((ExpressionResolver)context, model);
                for (String authorizationRealm : authorizationRealms) {
                    InjectedValue authorizationRealmValue = new InjectedValue();
                    this.addRealmDependency(context, (ServiceBuilder<SecurityRealm>)serviceBuilder, authorizationRealm, (Injector<SecurityRealm>)authorizationRealmValue);
                    authorizationRealmValues.add(authorizationRealmValue);
                }
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void addRealmDependency(OperationContext context, ServiceBuilder<SecurityRealm> serviceBuilder, String realmName, Injector<SecurityRealm> securityRealmInjector) {
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-realm", (String)realmName);
            ServiceName realmServiceName = context.getCapabilityServiceName(runtimeCapability, SecurityRealm.class);
            REALM_SERVICE_UTIL.addInjection(serviceBuilder, securityRealmInjector, realmServiceName);
        }
    }
}

