/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.ElytronOperationStepHandler;

class BaseAddHandler
extends AbstractAddStepHandler
implements ElytronOperationStepHandler {
    private final Set<RuntimeCapability<?>> runtimeCapabilities;

    BaseAddHandler() {
        this.runtimeCapabilities = Collections.emptySet();
    }

    BaseAddHandler(RuntimeCapability<?> runtimeCapability) {
        this.runtimeCapabilities = Collections.singleton(runtimeCapability);
    }

    BaseAddHandler(Set<RuntimeCapability<?>> capabilities) {
        this.runtimeCapabilities = capabilities;
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String pathValue = context.getCurrentAddressValue();
        for (RuntimeCapability<?> r : this.runtimeCapabilities) {
            context.registerAdditionalCapabilityRequirement("org.wildfly.security.elytron", r.isDynamicallyNamed() ? r.getDynamicName(pathValue) : r.getName(), null);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return this.isServerOrHostController(context);
    }
}

