/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities._private.CredentialSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.auth.util.GSSCredentialSecurityFactory;
import org.wildfly.security.credential.Credential;

class KerberosSecurityFactoryDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).build();
    static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MINIMUM_REMAINING_LIFETIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("minimum-remaining-lifetime", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REQUEST_LIFETIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-lifetime", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Integer.MAX_VALUE))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition OBTAIN_KERBEROS_TICKET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("obtain-kerberos-ticket", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition DEBUG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("debug", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    private static final ModelNode mechanismsDefault = new ModelNode();
    static final StringListAttributeDefinition MECHANISM_NAMES;
    static final StringListAttributeDefinition MECHANISM_OIDS;
    static final SimpleMapAttributeDefinition OPTIONS;

    KerberosSecurityFactoryDefinition() {
    }

    static ResourceDefinition getKerberosSecurityFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PRINCIPAL, FileAttributeDefinitions.RELATIVE_TO, PATH, MINIMUM_REMAINING_LIFETIME, REQUEST_LIFETIME, SERVER, OBTAIN_KERBEROS_TICKET, DEBUG, MECHANISM_NAMES, MECHANISM_OIDS, OPTIONS};
        TrivialAddHandler<CredentialSecurityFactory> add = new TrivialAddHandler<CredentialSecurityFactory>(CredentialSecurityFactory.class, attributes, new RuntimeCapability[]{Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<CredentialSecurityFactory> getValueSupplier(ServiceBuilder<CredentialSecurityFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                HashMap<String, ModelNode> options;
                ModelNode optionsNode;
                String principal = PRINCIPAL.resolveModelAttribute(context, model).asString();
                int minimumRemainingLifetime = MINIMUM_REMAINING_LIFETIME.resolveModelAttribute(context, model).asInt();
                int requestLifetime = REQUEST_LIFETIME.resolveModelAttribute(context, model).asInt();
                boolean server = SERVER.resolveModelAttribute(context, model).asBoolean();
                boolean obtainKerberosTicket = OBTAIN_KERBEROS_TICKET.resolveModelAttribute(context, model).asBoolean();
                boolean debug = DEBUG.resolveModelAttribute(context, model).asBoolean();
                Stream<String> oidsFromNames = MECHANISM_NAMES.unwrap((ExpressionResolver)context, model).stream().map(name -> OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.GSS, (String)name));
                Stream directOids = MECHANISM_OIDS.unwrap((ExpressionResolver)context, model).stream();
                List mechanismOids = Stream.concat(oidsFromNames, directOids).map(s -> {
                    try {
                        return new Oid((String)s);
                    }
                    catch (GSSException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).collect(Collectors.toList());
                InjectedValue pathManager = new InjectedValue();
                String path = PATH.resolveModelAttribute(context, model).asString();
                String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                if ((optionsNode = OPTIONS.resolveModelAttribute(context, model)).isDefined()) {
                    options = new HashMap<String, ModelNode>();
                    for (Property option : optionsNode.asPropertyList()) {
                        options.put(option.getName(), option.getValue());
                    }
                } else {
                    options = null;
                }
                return () -> {
                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                    pathResolver.path(path);
                    if (relativeTo != null) {
                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                    }
                    File resolvedPath = pathResolver.resolve();
                    GSSCredentialSecurityFactory.Builder builder = GSSCredentialSecurityFactory.builder().setPrincipal(principal).setKeyTab(resolvedPath).setMinimumRemainingLifetime(minimumRemainingLifetime).setRequestLifetime(requestLifetime).setIsServer(server).setObtainKerberosTicket(obtainKerberosTicket).setDebug(debug).setOptions(options);
                    mechanismOids.forEach(arg_0 -> ((GSSCredentialSecurityFactory.Builder)builder).addMechanismOid(arg_0));
                    try {
                        return CredentialSecurityFactory.from((SecurityFactory<? extends Credential>)builder.build());
                    }
                    catch (IOException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }
        };
        return new TrivialResourceDefinition("kerberos-security-factory", add, attributes, Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY);
    }

    static {
        mechanismsDefault.add("KRB5");
        mechanismsDefault.add("SPNEGO");
        MECHANISM_NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("mechanism-names").setAllowExpression(true)).setRequired(false)).setDefaultValue(mechanismsDefault)).setAllowedValues(new String[]{"KRB5LEGACY", "GENERIC", "KRB5", "KRB5V2", "SPNEGO"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        MECHANISM_OIDS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("mechanism-oids").setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        OPTIONS = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("options", ModelType.STRING, true).setAttributeMarshaller(new AttributeMarshaller(){

            public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                if ((resourceModel = resourceModel.get(attribute.getName())).isDefined()) {
                    for (ModelNode property : resourceModel.asList()) {
                        writer.writeEmptyElement("option");
                        writer.writeAttribute("key", property.asProperty().getName());
                        writer.writeAttribute("value", property.asProperty().getValue().asString());
                    }
                }
            }
        })).build();
    }
}

