/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.naming.InvalidNameException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRestartParentWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.LdapKeyStoreService;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities._private.DirContextSupplier;

final class LdapKeyStoreDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<KeyStore> LDAP_KEY_STORE_UTIL = ServiceUtil.newInstance(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, "ldap-key-store", KeyStore.class);
    static final SimpleAttributeDefinition DIR_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dir-context", ModelType.STRING, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.dir-context", "org.wildfly.security.key-store", true)).build();
    static final SimpleAttributeDefinition SEARCH_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-path", ModelType.STRING, false).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SEARCH_RECURSIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-recursive", ModelType.BOOLEAN, true).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition SEARCH_TIME_LIMIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-time-limit", ModelType.INT, true).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FILTER_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-alias", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FILTER_CERTIFICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-certificate", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition FILTER_ITERATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-iterate", ModelType.STRING, true).setAttributeGroup("search")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALIAS_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CERTIFICATE_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CERTIFICATE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-type", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CERTIFICATE_CHAIN_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-chain-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CERTIFICATE_CHAIN_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-chain-encoding", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-attribute", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition KEY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-type", ModelType.STRING, true).setAttributeGroup("attribute-mapping")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("ldap-key-store");
    static final SimpleAttributeDefinition SIZE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("size", ModelType.INT).setStorageRuntime()).build();
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{DIR_CONTEXT, SEARCH_PATH, SEARCH_RECURSIVE, SEARCH_TIME_LIMIT, FILTER_ALIAS, FILTER_CERTIFICATE, FILTER_ITERATE, NewItemTemplateObjectDefinition.OBJECT_DEFINITION, ALIAS_ATTRIBUTE, CERTIFICATE_ATTRIBUTE, CERTIFICATE_TYPE, CERTIFICATE_CHAIN_ATTRIBUTE, CERTIFICATE_CHAIN_ENCODING, KEY_ATTRIBUTE, KEY_TYPE};
    private static final KeyStoreAddHandler ADD = new KeyStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    private static final WriteAttributeHandler WRITE = new WriteAttributeHandler();

    LdapKeyStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ldap-key-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName keyStoreName = LDAP_KEY_STORE_UTIL.serviceName(operation);
                ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(keyStoreName);
                ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SIZE, (OperationStepHandler)new LdapKeyStoreRuntimeOnlyHandler(false){

            @Override
            protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
                try {
                    result.set(keyStoreService.getValue().size());
                }
                catch (KeyStoreException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToAccessKeyStore(e);
                }
            }
        });
    }

    static abstract class LdapKeyStoreRuntimeOnlyHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        LdapKeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        LdapKeyStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName ldapKeyStoreName = LDAP_KEY_STORE_UTIL.serviceName(operation);
            ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(this.writeAccess), ldapKeyStoreName, KeyStore.class);
            ServiceController.State serviceState = serviceContainer.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(ldapKeyStoreName, serviceState);
                }
                return;
            }
            this.performRuntime(context.getResult(), context, operation, (LdapKeyStoreService)serviceContainer.getService());
        }

        protected void performRuntime(ModelNode result, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
        }

        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, LdapKeyStoreService keyStoreService) throws OperationFailedException {
            this.performRuntime(result, operation, keyStoreService);
        }
    }

    static class NewItemTemplateAttributeObjectDefinition {
        static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final StringListAttributeDefinition VALUE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("value").setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NAME, VALUE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("attribute", ATTRIBUTES).setRequired(false)).build();

        NewItemTemplateAttributeObjectDefinition() {
        }
    }

    private static class WriteAttributeHandler
    extends ElytronRestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("ldap-key-store", CONFIG_ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName(KeyStore.class);
        }
    }

    private static class KeyStoreAddHandler
    extends BaseAddHandler {
        private KeyStoreAddHandler() {
            super(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            String dirContextName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)DIR_CONTEXT, model);
            String searchPath = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SEARCH_PATH, model);
            String filterAlias = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FILTER_ALIAS, model);
            String filterCertificate = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FILTER_CERTIFICATE, model);
            String filterIterate = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FILTER_ITERATE, model);
            String aliasAttribute = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALIAS_ATTRIBUTE, model);
            String certificateAttribute = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CERTIFICATE_ATTRIBUTE, model);
            String certificateType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CERTIFICATE_TYPE, model);
            String certificateChainAttribute = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CERTIFICATE_CHAIN_ATTRIBUTE, model);
            String certificateChainEncoding = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)CERTIFICATE_CHAIN_ENCODING, model);
            String keyAttribute = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)KEY_ATTRIBUTE, model);
            String keyType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)KEY_TYPE, model);
            LdapName createPathLdapName = null;
            String createRdn = null;
            BasicAttributes createAttributes = null;
            ModelNode newNode = NewItemTemplateObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model);
            if (newNode.isDefined()) {
                ModelNode createAttributesNode;
                String createPath = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)NewItemTemplateObjectDefinition.NEW_ITEM_PATH, newNode);
                createRdn = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)NewItemTemplateObjectDefinition.NEW_ITEM_RDN, newNode);
                if (createPath != null) {
                    try {
                        createPathLdapName = new LdapName(createPath);
                    }
                    catch (InvalidNameException e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                }
                if ((createAttributesNode = NewItemTemplateObjectDefinition.NEW_ITEM_ATTRIBUTES.resolveModelAttribute(context, newNode)).isDefined()) {
                    createAttributes = new BasicAttributes(true);
                    for (ModelNode attributeNode : createAttributesNode.asList()) {
                        ModelNode nameNode = NewItemTemplateAttributeObjectDefinition.NAME.resolveModelAttribute(context, attributeNode);
                        ModelNode valuesNode = NewItemTemplateAttributeObjectDefinition.VALUE.resolveModelAttribute(context, attributeNode);
                        if (valuesNode.getType() == ModelType.LIST) {
                            BasicAttribute listAttribute = new BasicAttribute(nameNode.asString());
                            for (ModelNode valueNode : valuesNode.asList()) {
                                listAttribute.add(valueNode.asString());
                            }
                            createAttributes.put(listAttribute);
                            continue;
                        }
                        createAttributes.put(new BasicAttribute(nameNode.asString(), valuesNode.asString()));
                    }
                }
            }
            LdapKeyStoreService keyStoreService = new LdapKeyStoreService(searchPath, filterAlias, filterCertificate, filterIterate, createPathLdapName, createRdn, createAttributes, aliasAttribute, certificateAttribute, certificateType, certificateChainAttribute, certificateChainEncoding, keyAttribute, keyType);
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(KeyStore.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)keyStoreService).setInitialMode(ServiceController.Mode.ACTIVE);
            String dirContextCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.dir-context", (String)dirContextName);
            ServiceName dirContextServiceName = context.getCapabilityServiceName(dirContextCapability, DirContextSupplier.class);
            serviceBuilder.addDependency(dirContextServiceName, DirContextSupplier.class, keyStoreService.getDirContextSupplierInjector());
            ElytronDefinition.commonDependencies(serviceBuilder).install();
        }
    }

    static class NewItemTemplateObjectDefinition {
        static final SimpleAttributeDefinition NEW_ITEM_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-item-path", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setRequires(new String[]{"new-item-rdn", "new-item-attributes"})).build();
        static final SimpleAttributeDefinition NEW_ITEM_RDN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-item-rdn", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setRequires(new String[]{"new-item-path", "new-item-attributes"})).build();
        static final ObjectListAttributeDefinition NEW_ITEM_ATTRIBUTES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("new-item-attributes", NewItemTemplateAttributeObjectDefinition.OBJECT_DEFINITION).setRequired(true)).setMinSize(1)).setAllowDuplicates(true)).setRequires(new String[]{"new-item-path", "new-item-rdn"})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NEW_ITEM_PATH, NEW_ITEM_RDN, NEW_ITEM_ATTRIBUTES};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("new-item-template", ATTRIBUTES).build();

        NewItemTemplateObjectDefinition() {
        }
    }
}

