/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRestartParentWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities._private.DirContextSupplier;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.SecurityRealm;

class LdapRealmDefinition
extends SimpleResourceDefinition {
    static List<CredentialMappingObjectDefinition> CREDENTIAL_MAPPERS = Arrays.asList(new UserPasswordCredentialMappingObjectDefinition(), new OtpCredentialMappingObjectDefinition(), new X509CredentialMappingObjectDefinition());
    static final SimpleAttributeDefinition DIR_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dir-context", ModelType.STRING, false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.dir-context", "org.wildfly.security.security-realm", true)).build();
    static final SimpleAttributeDefinition DIRECT_VERIFICATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("direct-verification", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition ALLOW_BLANK_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allow-blank-password", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setRequires(new String[]{"direct-verification"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{IdentityMappingObjectDefinition.OBJECT_DEFINITION, DIR_CONTEXT, DIRECT_VERIFICATION, ALLOW_BLANK_PASSWORD};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    private static final OperationStepHandler WRITE = new WriteAttributeHandler();

    LdapRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"ldap-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("ldap-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, WRITE);
        }
    }

    private static class WriteAttributeHandler
    extends ElytronRestartParentWriteAttributeHandler {
        WriteAttributeHandler() {
            super("ldap-realm", ATTRIBUTES);
        }

        protected ServiceName getParentServiceName(PathAddress pathAddress) {
            return Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(pathAddress.getLastElement().getValue()).getCapabilityServiceName();
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(new HashSet<RuntimeCapability>(Arrays.asList(Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)), ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            LdapSecurityRealmBuilder builder = LdapSecurityRealmBuilder.builder();
            if (DIRECT_VERIFICATION.resolveModelAttribute(context, model).asBoolean()) {
                boolean allowBlankPassword = ALLOW_BLANK_PASSWORD.resolveModelAttribute(context, model).asBoolean();
                builder.addDirectEvidenceVerification(allowBlankPassword);
            }
            TrivialService<SecurityRealm> ldapRealmService = new TrivialService<SecurityRealm>(() -> ((LdapSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, ldapRealmService).addAliases(new ServiceName[]{aliasServiceName});
            ElytronDefinition.commonDependencies(serviceBuilder);
            this.configureIdentityMapping(context, model, builder);
            this.configureDirContext(context, model, builder, (ServiceBuilder<SecurityRealm>)serviceBuilder);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private void configureDirContext(OperationContext context, ModelNode model, LdapSecurityRealmBuilder realmBuilder, ServiceBuilder<SecurityRealm> serviceBuilder) throws OperationFailedException {
            String dirContextName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)DIR_CONTEXT, model);
            String runtimeCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.dir-context", (String)dirContextName);
            ServiceName dirContextServiceName = context.getCapabilityServiceName(runtimeCapability, DirContextSupplier.class);
            InjectedValue dirContextInjector = new InjectedValue();
            serviceBuilder.addDependency(dirContextServiceName, DirContextSupplier.class, (Injector)dirContextInjector);
            realmBuilder.setDirContextSupplier(() -> {
                ExceptionSupplier supplier = (ExceptionSupplier)dirContextInjector.getValue();
                return (DirContext)supplier.get();
            });
        }

        private void configureIdentityMapping(OperationContext context, ModelNode model, LdapSecurityRealmBuilder builder) throws OperationFailedException {
            ModelNode newIdentityAttributesNode;
            ModelNode newIdentityParentDnNode;
            ModelNode iteratorFilterNode;
            ModelNode modelNode;
            ModelNode useRecursiveSearchNode;
            ModelNode identityMappingNode = IdentityMappingObjectDefinition.OBJECT_DEFINITION.resolveModelAttribute(context, model);
            LdapSecurityRealmBuilder.IdentityMappingBuilder identityMappingBuilder = builder.identityMapping();
            ModelNode nameAttributeNode = IdentityMappingObjectDefinition.RDN_IDENTIFIER.resolveModelAttribute(context, identityMappingNode);
            identityMappingBuilder.setRdnIdentifier(nameAttributeNode.asString());
            ModelNode searchDnNode = IdentityMappingObjectDefinition.SEARCH_BASE_DN.resolveModelAttribute(context, identityMappingNode);
            if (searchDnNode.isDefined()) {
                identityMappingBuilder.setSearchDn(searchDnNode.asString());
            }
            if ((useRecursiveSearchNode = IdentityMappingObjectDefinition.USE_RECURSIVE_SEARCH.resolveModelAttribute(context, identityMappingNode)).asBoolean()) {
                identityMappingBuilder.searchRecursive();
            }
            for (CredentialMappingObjectDefinition credentialMappingObjectDefinition : CREDENTIAL_MAPPERS) {
                credentialMappingObjectDefinition.configure(builder, context, identityMappingNode);
            }
            ModelNode attributeMappingNode = IdentityMappingObjectDefinition.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, identityMappingNode);
            if (attributeMappingNode.isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode recursiveSearch;
                    ModelNode searchDn;
                    ModelNode rdn;
                    ModelNode to;
                    ModelNode filter = AttributeMappingObjectDefinition.FILTER.resolveModelAttribute(context, attributeNode);
                    ModelNode reference = AttributeMappingObjectDefinition.REFERENCE.resolveModelAttribute(context, attributeNode);
                    AttributeMapping.Builder b = filter.isDefined() ? AttributeMapping.fromFilter((String)filter.asString()) : (reference.isDefined() ? AttributeMapping.fromReference((String)reference.asString()) : AttributeMapping.fromIdentity());
                    ModelNode from = AttributeMappingObjectDefinition.FROM.resolveModelAttribute(context, attributeNode);
                    if (from.isDefined()) {
                        b.from(from.asString());
                    }
                    if ((to = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode)).isDefined()) {
                        b.to(to.asString());
                    }
                    if ((rdn = AttributeMappingObjectDefinition.EXTRACT_RDN.resolveModelAttribute(context, attributeNode)).isDefined()) {
                        b.extractRdn(rdn.asString());
                    }
                    if ((searchDn = AttributeMappingObjectDefinition.FILTER_BASE_DN.resolveModelAttribute(context, attributeNode)).isDefined() && filter.isDefined()) {
                        b.searchDn(searchDn.asString());
                    }
                    if ((recursiveSearch = AttributeMappingObjectDefinition.RECURSIVE_SEARCH.resolveModelAttribute(context, attributeNode)).isDefined() && filter.isDefined()) {
                        b.searchRecursively(recursiveSearch.asBoolean());
                    }
                    ModelNode roleRecursion = AttributeMappingObjectDefinition.ROLE_RECURSION.resolveModelAttribute(context, attributeNode);
                    ModelNode roleRecursionName = AttributeMappingObjectDefinition.ROLE_RECURSION_NAME.resolveModelAttribute(context, attributeNode);
                    if (roleRecursion.isDefined() && (filter.isDefined() || reference.isDefined())) {
                        b.roleRecursion(roleRecursion.asInt());
                        if (roleRecursionName.isDefined()) {
                            b.roleRecursionName(roleRecursionName.asString());
                        }
                    }
                    identityMappingBuilder.map(new AttributeMapping[]{b.build()});
                }
            }
            if ((modelNode = IdentityMappingObjectDefinition.FILTER_NAME.resolveModelAttribute(context, identityMappingNode)).isDefined()) {
                identityMappingBuilder.setFilterName(modelNode.asString());
            }
            if ((iteratorFilterNode = IdentityMappingObjectDefinition.ITERATOR_FILTER.resolveModelAttribute(context, identityMappingNode)).isDefined()) {
                identityMappingBuilder.setIteratorFilter(iteratorFilterNode.asString());
            }
            if ((newIdentityParentDnNode = IdentityMappingObjectDefinition.NEW_IDENTITY_PARENT_DN.resolveModelAttribute(context, identityMappingNode)).isDefined()) {
                try {
                    identityMappingBuilder.setNewIdentityParent(new LdapName(newIdentityParentDnNode.asString()));
                }
                catch (InvalidNameException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            if ((newIdentityAttributesNode = IdentityMappingObjectDefinition.NEW_IDENTITY_ATTRIBUTES.resolveModelAttribute(context, identityMappingNode)).isDefined()) {
                BasicAttributes attributes = new BasicAttributes(true);
                for (ModelNode attributeNode : newIdentityAttributesNode.asList()) {
                    ModelNode nameNode = NewIdentityAttributeObjectDefinition.NAME.resolveModelAttribute(context, attributeNode);
                    ModelNode valuesNode = NewIdentityAttributeObjectDefinition.VALUE.resolveModelAttribute(context, attributeNode);
                    if (valuesNode.getType() == ModelType.LIST) {
                        BasicAttribute listAttribute = new BasicAttribute(nameNode.asString());
                        for (ModelNode valueNode : valuesNode.asList()) {
                            listAttribute.add(valueNode.asString());
                        }
                        attributes.put(listAttribute);
                        continue;
                    }
                    attributes.put(new BasicAttribute(nameNode.asString(), valuesNode.asString()));
                }
                identityMappingBuilder.setNewIdentityAttributes((Attributes)attributes);
            }
            identityMappingBuilder.build();
        }
    }

    static class IdentityMappingObjectDefinition {
        static final SimpleAttributeDefinition RDN_IDENTIFIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rdn-identifier", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition USE_RECURSIVE_SEARCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-recursive-search", ModelType.BOOLEAN, true).setRequires(new String[]{"search-base-dn"})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEARCH_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-base-dn", ModelType.STRING, true).setRequires(new String[]{"rdn-identifier"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setRequired(false)).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static final ObjectListAttributeDefinition NEW_IDENTITY_ATTRIBUTES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("new-identity-attributes", NewIdentityAttributeObjectDefinition.OBJECT_DEFINITION).setRequired(false)).setAllowDuplicates(true)).build();
        static final SimpleAttributeDefinition FILTER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-name", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATOR_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iterator-filter", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition NEW_IDENTITY_PARENT_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("new-identity-parent-dn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RDN_IDENTIFIER, USE_RECURSIVE_SEARCH, SEARCH_BASE_DN, ATTRIBUTE_MAPPINGS, FILTER_NAME, ITERATOR_FILTER, NEW_IDENTITY_PARENT_DN, NEW_IDENTITY_ATTRIBUTES};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("identity-mapping", new AttributeDefinition[]{RDN_IDENTIFIER, USE_RECURSIVE_SEARCH, SEARCH_BASE_DN, ATTRIBUTE_MAPPINGS, FILTER_NAME, ITERATOR_FILTER, NEW_IDENTITY_PARENT_DN, NEW_IDENTITY_ATTRIBUTES, UserPasswordCredentialMappingObjectDefinition.OBJECT_DEFINITION, OtpCredentialMappingObjectDefinition.OBJECT_DEFINITION, X509CredentialMappingObjectDefinition.OBJECT_DEFINITION}).setRequired(true)).build();

        IdentityMappingObjectDefinition() {
        }
    }

    static class NewIdentityAttributeObjectDefinition {
        static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final StringListAttributeDefinition VALUE = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("value").setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{NAME, VALUE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", ATTRIBUTES).build();

        NewIdentityAttributeObjectDefinition() {
        }
    }

    static class X509CredentialMappingObjectDefinition
    implements CredentialMappingObjectDefinition {
        static final SimpleAttributeDefinition DIGEST_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("digest-from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition DIGEST_ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("digest-algorithm", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("SHA-1"))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition CERTIFICATE_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SERIAL_NUMBER_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("serial-number-from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SUBJECT_DN_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("subject-dn-from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DIGEST_FROM, DIGEST_ALGORITHM, CERTIFICATE_FROM, SERIAL_NUMBER_FROM, SUBJECT_DN_FROM};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("x509-credential-mapper", ATTRIBUTES).build();

        X509CredentialMappingObjectDefinition() {
        }

        @Override
        public void configure(LdapSecurityRealmBuilder builder, OperationContext context, ModelNode identityMapping) throws OperationFailedException {
            ModelNode serialNumberFrom;
            ModelNode certificateFrom;
            ModelNode model = OBJECT_DEFINITION.resolveModelAttribute(context, identityMapping);
            if (!model.isDefined()) {
                return;
            }
            LdapSecurityRealmBuilder.X509EvidenceVerifierBuilder b = builder.x509EvidenceVerifier();
            ModelNode digestFrom = DIGEST_FROM.resolveModelAttribute(context, model);
            ModelNode digestAlgorithmFrom = DIGEST_ALGORITHM.resolveModelAttribute(context, model);
            if (digestFrom.isDefined()) {
                b.addDigestCertificateVerifier(digestFrom.asString(), digestAlgorithmFrom.asString());
            }
            if ((certificateFrom = CERTIFICATE_FROM.resolveModelAttribute(context, model)).isDefined()) {
                b.addEncodedCertificateVerifier(certificateFrom.asString());
            }
            if ((serialNumberFrom = SERIAL_NUMBER_FROM.resolveModelAttribute(context, model)).isDefined()) {
                b.addSerialNumberCertificateVerifier(serialNumberFrom.asString());
            }
            ModelNode subjectDnFrom = SUBJECT_DN_FROM.resolveModelAttribute(context, model);
            b.addSubjectDnCertificateVerifier(subjectDnFrom.asString());
            b.build();
        }
    }

    static class OtpCredentialMappingObjectDefinition
    implements CredentialMappingObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition HASH_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEED_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("seed-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SEQUENCE_FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sequence-from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ALGORITHM_FROM, HASH_FROM, SEED_FROM, SEQUENCE_FROM};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("otp-credential-mapper", ATTRIBUTES).build();

        OtpCredentialMappingObjectDefinition() {
        }

        @Override
        public void configure(LdapSecurityRealmBuilder builder, OperationContext context, ModelNode identityMapping) throws OperationFailedException {
            ModelNode model = OBJECT_DEFINITION.resolveModelAttribute(context, identityMapping);
            if (!model.isDefined()) {
                return;
            }
            String algorithmFrom = ALGORITHM_FROM.resolveModelAttribute(context, model).asString();
            String hashFrom = HASH_FROM.resolveModelAttribute(context, model).asString();
            String seedFrom = SEED_FROM.resolveModelAttribute(context, model).asString();
            String sequenceFrom = SEQUENCE_FROM.resolveModelAttribute(context, model).asString();
            LdapSecurityRealmBuilder.OtpCredentialLoaderBuilder b = builder.otpCredentialLoader();
            if (algorithmFrom != null) {
                b.setOtpAlgorithmAttribute(algorithmFrom);
            }
            if (hashFrom != null) {
                b.setOtpHashAttribute(hashFrom);
            }
            if (seedFrom != null) {
                b.setOtpSeedAttribute(seedFrom);
            }
            if (sequenceFrom != null) {
                b.setOtpSequenceAttribute(sequenceFrom);
            }
            b.build();
        }
    }

    static class UserPasswordCredentialMappingObjectDefinition
    implements CredentialMappingObjectDefinition {
        static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition WRITABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("writable", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition VERIFIABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verifiable", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FROM, WRITABLE, VERIFIABLE};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("user-password-mapper", ATTRIBUTES).build();

        UserPasswordCredentialMappingObjectDefinition() {
        }

        @Override
        public void configure(LdapSecurityRealmBuilder builder, OperationContext context, ModelNode identityMapping) throws OperationFailedException {
            ModelNode model = OBJECT_DEFINITION.resolveModelAttribute(context, identityMapping);
            if (!model.isDefined()) {
                return;
            }
            String from = FROM.resolveModelAttribute(context, model).asString();
            boolean writable = WRITABLE.resolveModelAttribute(context, model).asBoolean();
            boolean verifiable = VERIFIABLE.resolveModelAttribute(context, model).asBoolean();
            LdapSecurityRealmBuilder.UserPasswordCredentialLoaderBuilder b = builder.userPasswordCredentialLoader();
            if (from != null) {
                b.setUserPasswordAttribute(from);
            }
            if (writable) {
                b.enablePersistence();
            }
            if (!verifiable) {
                b.disableVerification();
            }
            b.build();
        }
    }

    static interface CredentialMappingObjectDefinition {
        public void configure(LdapSecurityRealmBuilder var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition REFERENCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("reference", ModelType.STRING, true).setAlternatives(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter", ModelType.STRING, true).setRequires(new String[]{"to"})).setAlternatives(new String[]{"reference"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition FILTER_BASE_DN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("filter-base-dn", ModelType.STRING, true).setRequires(new String[]{"filter"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition RECURSIVE_SEARCH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("search-recursive", ModelType.BOOLEAN, true).setRequires(new String[]{"filter"})).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ROLE_RECURSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-recursion", ModelType.INT, true).setDefaultValue(new ModelNode(0))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ROLE_RECURSION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role-recursion-name", ModelType.STRING, true).setDefaultValue(new ModelNode("cn"))).setRequires(new String[]{"role-recursion"})).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition EXTRACT_RDN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extract-rdn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{FROM, TO, REFERENCE, FILTER, FILTER_BASE_DN, RECURSIVE_SEARCH, ROLE_RECURSION, ROLE_RECURSION_NAME, EXTRACT_RDN};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).build();

        AttributeMappingObjectDefinition() {
        }
    }
}

