/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.RealmDefinitions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

class ModifiableRealmDecorator
extends DelegatingResourceDefinition {
    static ResourceDefinition wrap(ResourceDefinition resourceDefinition) {
        return new ModifiableRealmDecorator(resourceDefinition);
    }

    private ModifiableRealmDecorator(ResourceDefinition resourceDefinition) {
        this.setDelegate(resourceDefinition);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("modifiable-security-realm");
        AddIdentityHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        RemoveIdentityHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        ReadIdentityHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        AddIdentityAttributeHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        RemoveIdentityAttributeHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        SetPasswordHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
    }

    static ModifiableSecurityRealm getModifiableSecurityRealm(OperationContext context) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        PathAddress currentAddress = context.getCurrentAddress();
        RuntimeCapability runtimeCapability = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(currentAddress.getLastElement().getValue());
        ServiceName realmName = runtimeCapability.getCapabilityServiceName();
        ServiceController<ModifiableSecurityRealm> serviceController = ElytronExtension.getRequiredService(serviceRegistry, realmName, ModifiableSecurityRealm.class);
        return (ModifiableSecurityRealm)serviceController.getValue();
    }

    static ModifiableRealmIdentity getRealmIdentity(OperationContext context, String principalName) throws OperationFailedException {
        ModifiableSecurityRealm modifiableRealm = ModifiableRealmDecorator.getModifiableSecurityRealm(context);
        ModifiableRealmIdentity realmIdentity = null;
        try {
            realmIdentity = modifiableRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(principalName));
            if (!realmIdentity.exists()) {
                throw new OperationFailedException(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
            }
            ModifiableRealmIdentity modifiableRealmIdentity = realmIdentity;
            return modifiableRealmIdentity;
        }
        catch (RealmUnavailableException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotReadIdentity(principalName, (Exception)((Object)e));
        }
        finally {
            if (realmIdentity != null) {
                realmIdentity.dispose();
            }
        }
    }

    static class SetPasswordHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();
        static AttributeDefinition[] SUPPORTED_PASSWORDS = new AttributeDefinition[]{Bcrypt.OBJECT_DEFINITION, Clear.OBJECT_DEFINITION, SimpleDigest.OBJECT_DEFINITION, SaltedSimpleDigest.OBJECT_DEFINITION, Digest.OBJECT_DEFINITION};
        static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{IDENTITY, Bcrypt.OBJECT_DEFINITION, Clear.OBJECT_DEFINITION, SimpleDigest.OBJECT_DEFINITION, SaltedSimpleDigest.OBJECT_DEFINITION, Digest.OBJECT_DEFINITION};

        SetPasswordHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("set-password", descriptionResolver).setParameters(ATTRIBUTES).setRuntimeOnly().build(), (OperationStepHandler)new SetPasswordHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableRealmIdentity realmIdentity = ModifiableRealmDecorator.getRealmIdentity(context, principalName);
            ArrayList<PasswordCredential> passwords = new ArrayList<PasswordCredential>();
            try {
                for (AttributeDefinition passwordDef : SUPPORTED_PASSWORDS) {
                    String passwordType = passwordDef.getName();
                    if (!operation.hasDefined(passwordType)) continue;
                    passwords.add(new PasswordCredential(this.createPassword(context, principalName, passwordType, operation.get(passwordType))));
                }
                realmIdentity.setCredentials(passwords);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotCreatePassword((Exception)e);
            }
        }

        private Password createPassword(OperationContext parentContext, String principalName, String passwordType, ModelNode passwordNode) throws OperationFailedException, NoSuchAlgorithmException, InvalidKeySpecException {
            String algorithm;
            ClearPasswordSpec passwordSpec;
            String password = Bcrypt.PASSWORD.resolveModelAttribute(parentContext, passwordNode).asString();
            if (passwordType.equals("bcrypt")) {
                byte[] salt = Bcrypt.SALT.resolveModelAttribute(parentContext, passwordNode).asBytes();
                int iterationCount = Bcrypt.ITERATION_COUNT.resolveModelAttribute(parentContext, passwordNode).asInt();
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(iterationCount, salt));
                algorithm = Bcrypt.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("clear")) {
                passwordSpec = new ClearPasswordSpec(password.toCharArray());
                algorithm = Clear.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("simple-digest")) {
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), null);
                algorithm = SimpleDigest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("salted-simple-digest")) {
                byte[] salt = SaltedSimpleDigest.SALT.resolveModelAttribute(parentContext, passwordNode).asBytes();
                SaltedPasswordAlgorithmSpec spec = new SaltedPasswordAlgorithmSpec(salt);
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)spec);
                algorithm = SaltedSimpleDigest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
            } else if (passwordType.equals("digest")) {
                String realm = Digest.REALM.resolveModelAttribute(parentContext, passwordNode).asString();
                algorithm = Digest.ALGORITHM.resolveModelAttribute(parentContext, passwordNode).asString();
                DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec(principalName, realm);
                passwordSpec = new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)dpas);
            } else {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unexpectedPasswordType(passwordType);
            }
            return PasswordFactory.getInstance((String)algorithm).generatePassword((KeySpec)passwordSpec);
        }

        static class Digest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("digest-sha-512"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"digest-md5", "digest-sha", "digest-sha-256", "digest-sha-512"}))).build();
            static final SimpleAttributeDefinition PASSWORD = new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).build();
            static final SimpleAttributeDefinition REALM = new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, false).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("digest", new AttributeDefinition[]{ALGORITHM, PASSWORD, REALM}).setRequired(false)).build();

            Digest() {
            }
        }

        static class SaltedSimpleDigest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("password-salt-digest-sha-512"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"password-salt-digest-md5", "password-salt-digest-sha-1", "password-salt-digest-sha-256", "password-salt-digest-sha-384", "password-salt-digest-sha-512", "salt-password-digest-md5", "salt-password-digest-sha-1", "salt-password-digest-sha-256", "salt-password-digest-sha-384", "salt-password-digest-sha-512"}))).build();
            static final SimpleAttributeDefinition PASSWORD = new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).build();
            static final SimpleAttributeDefinition SALT = new SimpleAttributeDefinitionBuilder("salt", ModelType.BYTES, false).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("salted-simple-digest", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT}).setRequired(false)).build();

            SaltedSimpleDigest() {
            }
        }

        static class SimpleDigest {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("simple-digest-sha-512"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"simple-digest-md2", "simple-digest-md5", "simple-digest-sha-1", "simple-digest-sha-256", "simple-digest-sha-384", "simple-digest-sha-512"}))).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("simple-digest", new AttributeDefinition[]{ALGORITHM, PASSWORD}).setRequired(false)).build();

            SimpleDigest() {
            }
        }

        static class Clear {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("clear"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"clear"}))).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("clear", new AttributeDefinition[]{PASSWORD}).setRequired(false)).build();

            Clear() {
            }
        }

        static class Bcrypt {
            static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("bcrypt"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"bcrypt"}))).build();
            static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING, false).setMinSize(1)).build();
            static final SimpleAttributeDefinition ITERATION_COUNT = new SimpleAttributeDefinitionBuilder("iteration-count", ModelType.INT, false).build();
            static final SimpleAttributeDefinition SALT = new SimpleAttributeDefinitionBuilder("salt", ModelType.BYTES, false).build();
            static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("bcrypt", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT}).setRequired(false)).build();

            Bcrypt() {
            }
        }
    }

    static class RemoveIdentityAttributeHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();
        public static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).build();
        static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).build();
        static final SimpleListAttributeDefinition VALUES = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("value", (AttributeDefinition)VALUE).setRequired(false)).setMinSize(0).build();

        RemoveIdentityAttributeHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove-identity-attribute", descriptionResolver).setParameters(new AttributeDefinition[]{IDENTITY, NAME, VALUES}).setRuntimeOnly().build(), (OperationStepHandler)new RemoveIdentityAttributeHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AuthorizationIdentity authorizationIdentity;
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableRealmIdentity realmIdentity = ModifiableRealmDecorator.getRealmIdentity(context, principalName);
            try {
                authorizationIdentity = realmIdentity.getAuthorizationIdentity();
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotObtainAuthorizationIdentity((Exception)((Object)e));
            }
            try {
                MapAttributes attributes = new MapAttributes(authorizationIdentity.getAttributes());
                String name = NAME.resolveModelAttribute(context, operation).asString();
                ModelNode valuesNode = VALUES.resolveModelAttribute(context, operation);
                if (valuesNode.isDefined()) {
                    for (ModelNode valueNode : valuesNode.asList()) {
                        attributes.removeAll(name, valueNode.asString());
                    }
                } else {
                    attributes.remove(name);
                }
                realmIdentity.setAttributes((Attributes)attributes);
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotRemoveAttribute((Exception)((Object)e));
            }
        }
    }

    static class AddIdentityAttributeHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();
        static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).build();
        static final SimpleAttributeDefinition VALUE = new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).build();
        static final SimpleListAttributeDefinition VALUES = new SimpleListAttributeDefinition.Builder("value", (AttributeDefinition)VALUE).setMinSize(1).build();

        AddIdentityAttributeHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("add-identity-attribute", descriptionResolver).setParameters(new AttributeDefinition[]{IDENTITY, NAME, VALUES}).setRuntimeOnly().build(), (OperationStepHandler)new AddIdentityAttributeHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AuthorizationIdentity authorizationIdentity;
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableRealmIdentity realmIdentity = ModifiableRealmDecorator.getRealmIdentity(context, principalName);
            try {
                authorizationIdentity = realmIdentity.getAuthorizationIdentity();
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotObtainAuthorizationIdentity((Exception)((Object)e));
            }
            try {
                MapAttributes attributes = new MapAttributes(authorizationIdentity.getAttributes());
                String name = NAME.resolveModelAttribute(context, operation).asString();
                VALUES.resolveModelAttribute(context, operation).asList().forEach(arg_0 -> AddIdentityAttributeHandler.lambda$executeRuntimeStep$0((Attributes)attributes, name, arg_0));
                realmIdentity.setAttributes((Attributes)attributes);
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotAddAttribute((Exception)((Object)e));
            }
        }

        private static /* synthetic */ void lambda$executeRuntimeStep$0(Attributes attributes, String name, ModelNode modelNode) {
            attributes.addLast(name, modelNode.asString());
        }
    }

    static class ReadIdentityHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();

        ReadIdentityHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("read-identity", descriptionResolver).setParameters(new AttributeDefinition[]{IDENTITY}).setRuntimeOnly().build(), (OperationStepHandler)new ReadIdentityHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableRealmIdentity realmIdentity = ModifiableRealmDecorator.getRealmIdentity(context, principalName);
            try {
                AuthorizationIdentity identity = realmIdentity.getAuthorizationIdentity();
                ModelNode result = context.getResult();
                result.get("name").set(principalName);
                ModelNode attributesNode = result.get("attributes");
                identity.getAttributes().entries().forEach(entry -> {
                    ModelNode entryNode = attributesNode.get(entry.getKey()).setEmptyList();
                    entry.forEach(arg_0 -> ((ModelNode)entryNode).add(arg_0));
                });
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotReadIdentity(principalName, (Exception)((Object)e));
            }
        }
    }

    static class RemoveIdentityHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();

        RemoveIdentityHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove-identity", descriptionResolver).setParameters(new AttributeDefinition[]{IDENTITY}).setRuntimeOnly().build(), (OperationStepHandler)new RemoveIdentityHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableSecurityRealm modifiableRealm = ModifiableRealmDecorator.getModifiableSecurityRealm(context);
            ModifiableRealmIdentity identity = null;
            try {
                identity = modifiableRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(principalName));
                if (!identity.exists()) {
                    throw new OperationFailedException(ElytronSubsystemMessages.ROOT_LOGGER.identityNotFound(principalName));
                }
                identity.delete();
                identity.dispose();
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotDeleteIdentity(principalName, (Exception)((Object)e));
            }
            finally {
                if (identity != null) {
                    identity.dispose();
                }
            }
        }
    }

    static class AddIdentityHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition IDENTITY = new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).build();

        AddIdentityHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("add-identity", descriptionResolver).setParameters(new AttributeDefinition[]{IDENTITY}).setRuntimeOnly().build(), (OperationStepHandler)new AddIdentityHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String principalName = IDENTITY.resolveModelAttribute(context, operation).asString();
            ModifiableSecurityRealm modifiableRealm = ModifiableRealmDecorator.getModifiableSecurityRealm(context);
            ModifiableRealmIdentity identity = null;
            try {
                identity = modifiableRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(principalName));
                if (identity.exists()) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.identityAlreadyExists(principalName);
                }
                identity.create();
            }
            catch (RealmUnavailableException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.couldNotCreateIdentity(principalName, (Exception)((Object)e));
            }
            finally {
                if (identity != null) {
                    identity.dispose();
                }
            }
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String principalName;
            if (!RealmDefinitions.CASE_SENSITIVE.resolveModelAttribute(context, context.readResourceFromRoot(context.getCurrentAddress(), false).getModel()).asBoolean(false) && !(principalName = IDENTITY.resolveModelAttribute(context, operation).asString()).equals(principalName.toLowerCase(Locale.ROOT))) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidUsername(principalName, context.getCurrentAddress().getLastElement().getValue());
            }
            super.execute(context, operation);
        }
    }
}

