/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FilteringKeyStoreService;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;

class FilteringKeyStoreDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<KeyStore> FILTERING_KEY_STORE_UTIL = ServiceUtil.newInstance(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, "filtering-key-store", KeyStore.class);
    static final SimpleAttributeDefinition KEY_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.key-store", true)).build();
    static final SimpleAttributeDefinition ALIAS_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias-filter", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("filtering-key-store");
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES = new AttributeDefinition[]{KEY_STORE, ALIAS_FILTER};
    private static final KeyStoreAddHandler ADD = new KeyStoreAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.KEY_STORE_RUNTIME_CAPABILITY);
    private static final AbstractWriteAttributeHandler WRITE = new ElytronReloadRequiredWriteAttributeHandler(CONFIG_ATTRIBUTES);

    FilteringKeyStoreDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"filtering-key-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.KEY_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

            protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName keyStoreName = FILTERING_KEY_STORE_UTIL.serviceName(operation);
                ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(keyStoreName);
                ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
            }
        });
    }

    private static class KeyStoreAddHandler
    extends BaseAddHandler {
        private KeyStoreAddHandler() {
            super(Capabilities.KEY_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            String sourceKeyStoreName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)KEY_STORE, model);
            String aliasFilter = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALIAS_FILTER, model);
            String sourceKeyStoreCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)sourceKeyStoreName);
            ServiceName sourceKeyStoreServiceName = context.getCapabilityServiceName(sourceKeyStoreCapability, KeyStore.class);
            InjectedValue keyStore = new InjectedValue();
            FilteringKeyStoreService filteringKeyStoreService = new FilteringKeyStoreService((InjectedValue<KeyStore>)keyStore, aliasFilter);
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(KeyStore.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)filteringKeyStoreService).setInitialMode(ServiceController.Mode.ACTIVE);
            FILTERING_KEY_STORE_UTIL.addInjection(serviceBuilder, (Injector<KeyStore>)keyStore, sourceKeyStoreServiceName);
            ElytronDefinition.commonDependencies(serviceBuilder).install();
        }
    }
}

