/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

public class SizeValidator
extends ModelTypeValidator {
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");

    public SizeValidator() {
        this(false);
    }

    public SizeValidator(boolean nullable) {
        super(ModelType.STRING, nullable);
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            SizeValidator.parseSize(value);
        }
    }

    public static long parseSize(ModelNode value) throws OperationFailedException {
        Matcher matcher = SIZE_PATTERN.matcher(value.asString());
        if (!matcher.matches()) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSize(value.asString());
        }
        long qty = Long.parseLong(matcher.group(1), 10);
        String chr = matcher.group(2);
        if (chr != null) {
            switch (chr.charAt(0)) {
                case 'B': 
                case 'b': {
                    break;
                }
                case 'K': 
                case 'k': {
                    qty <<= 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    qty <<= 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    qty <<= 30;
                    break;
                }
                case 'T': 
                case 't': {
                    qty <<= 40;
                    break;
                }
                default: {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSize(value.asString());
                }
            }
        }
        return qty;
    }
}

