/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.DirContextDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;

class DirContextParser {
    private final PersistentResourceXMLDescription dirContextParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"dir-context"), null).addAttributes(DirContextDefinition.ATTRIBUTES).build();

    DirContextParser() {
    }

    void readDirContexts(ModelNode parentAddressNode, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            PathAddress parentAddress = PathAddress.pathAddress((ModelNode)parentAddressNode);
            if ("dir-context".equals(localName)) {
                this.dirContextParser.parse(reader, parentAddress, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void writeDirContexts(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("dir-context")) {
            writer.writeStartElement("dir-contexts");
            this.dirContextParser.persist(writer, subsystem);
            writer.writeEndElement();
        }
    }
}

