/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryParser;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.SaslServerDefinitions;

class SaslParser {
    private final AuthenticationFactoryParser authenticationFactoryParser = new AuthenticationFactoryParser();
    private PersistentResourceXMLDescription aggregateSaslServerMechanismFactory = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"aggregate-sasl-server-factory")).addAttribute((AttributeDefinition)SaslServerDefinitions.getRawAggregateSaslServerFactoryDefinition().getReferencesAttribute(), (AttributeParser)new CommonAttributes.AggregateAttributeParser("sasl-server-factory"), (AttributeMarshaller)new CommonAttributes.AggregateAttributeMarshaller("sasl-server-factory")).build();
    private PersistentResourceXMLDescription configurableSaslServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"configurable-sasl-server-factory")).addAttribute((AttributeDefinition)SaslServerDefinitions.SASL_SERVER_FACTORY).addAttribute((AttributeDefinition)SaslServerDefinitions.PROTOCOL).addAttribute((AttributeDefinition)SaslServerDefinitions.SERVER_NAME).addAttribute((AttributeDefinition)CommonAttributes.PROPERTIES).addAttribute((AttributeDefinition)SaslServerDefinitions.CONFIGURED_FILTERS).build();
    private PersistentResourceXMLDescription mechanismProviderFilteringSaslServerFactoryElement = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"mechanism-provider-filtering-sasl-server-factory")).addAttribute((AttributeDefinition)SaslServerDefinitions.SASL_SERVER_FACTORY).addAttribute((AttributeDefinition)SaslServerDefinitions.ENABLING).addAttribute((AttributeDefinition)SaslServerDefinitions.MECH_PROVIDER_FILTERS).build();
    private PersistentResourceXMLDescription providerSaslServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"provider-sasl-server-factory")).addAttribute((AttributeDefinition)SaslServerDefinitions.PROVIDERS).build();
    private PersistentResourceXMLDescription serviceLoaderSaslServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"service-loader-sasl-server-factory")).setUseElementsForGroups(false).addAttribute((AttributeDefinition)ClassLoadingAttributeDefinitions.MODULE).build();

    SaslParser() {
    }

    void readSasl(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "sasl-authentication-factory": {
                    this.authenticationFactoryParser.readSaslAuthenticationFactoryElement(parentAddress, reader, operations);
                    continue block16;
                }
                case "aggregate-sasl-server-factory": {
                    this.aggregateSaslServerMechanismFactory.parse(reader, parentAddress, operations);
                    continue block16;
                }
                case "configurable-sasl-server-factory": {
                    this.configurableSaslServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block16;
                }
                case "mechanism-provider-filtering-sasl-server-factory": {
                    this.mechanismProviderFilteringSaslServerFactoryElement.parse(reader, parentAddress, operations);
                    continue block16;
                }
                case "provider-sasl-server-factory": {
                    this.providerSaslServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block16;
                }
                case "service-loader-sasl-server-factory": {
                    this.serviceLoaderSaslServerMechanismFactoryParser.parse(reader, parentAddress, operations);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void startSasl(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("sasl");
        }
    }

    private boolean writeAggregateSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-sasl-server-factory")) {
            this.startSasl(started, writer);
            this.aggregateSaslServerMechanismFactory.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeConfigurableSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("configurable-sasl-server-factory")) {
            this.startSasl(started, writer);
            this.configurableSaslServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeMechanismProviderFilteringSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("mechanism-provider-filtering-sasl-server-factory")) {
            this.startSasl(started, writer);
            this.mechanismProviderFilteringSaslServerFactoryElement.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeProviderSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("provider-sasl-server-factory")) {
            this.startSasl(started, writer);
            this.providerSaslServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeServiceLoaderSaslServerFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("service-loader-sasl-server-factory")) {
            this.startSasl(started, writer);
            this.serviceLoaderSaslServerMechanismFactoryParser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    void writeSasl(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean saslStarted = false;
        saslStarted |= this.authenticationFactoryParser.writeSaslAuthenticationFactory(saslStarted, subsystem, writer, b -> this.startSasl(b, writer));
        saslStarted |= this.writeAggregateSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeConfigurableSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeMechanismProviderFilteringSaslServerFactory(saslStarted, subsystem, writer);
        saslStarted |= this.writeProviderSaslServerFactory(saslStarted, subsystem, writer);
        if (saslStarted |= this.writeServiceLoaderSaslServerFactory(saslStarted, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

