/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.AvailableMechanismsRuntimeResource;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismInformation;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.SortedServerMechanismFactory;
import org.wildfly.security.sasl.util.FilterMechanismSaslServerFactory;
import org.wildfly.security.sasl.util.SortedMechanismSaslServerFactory;

class AuthenticationFactoryDefinitions {
    static final SimpleAttributeDefinition BASE_SECURITY_DOMAIN_REF = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HTTP_SERVER_MECHANISM_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-server-mechanism-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-server-mechanism-factory", "org.wildfly.security.http-authentication-factory", true)).build();
    static final SimpleAttributeDefinition SASL_SERVER_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-server-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.sasl-server-factory", "org.wildfly.security.sasl-authentication-factory", true)).build();
    static final SimpleAttributeDefinition MECHANISM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mechanism-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAttributeGroup("selection-criteria")).build();
    static final SimpleAttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAttributeGroup("selection-criteria")).build();
    static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAttributeGroup("selection-criteria")).build();
    static final SimpleAttributeDefinition BASE_CREDENTIAL_SECURITY_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("credential-security-factory", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition BASE_PRE_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("pre-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition BASE_POST_REALM_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("post-realm-principal-transformer", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition BASE_FINAL_PRINCIPAL_TRANSFORMER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("final-principal-transformer", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition BASE_REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-mapper", ModelType.STRING, true).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-name", ModelType.STRING, false).setMinSize(1)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    AuthenticationFactoryDefinitions() {
    }

    static AttributeDefinition getMechanismConfiguration(String forCapability) {
        SimpleAttributeDefinition preRealmPrincipalTransformerAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_PRE_REALM_PRINCIPAL_TRANSFORMER).setCapabilityReference("org.wildfly.security.principal-transformer", forCapability, true)).build();
        SimpleAttributeDefinition postRealmPrincipalTransformerAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_POST_REALM_PRINCIPAL_TRANSFORMER).setCapabilityReference("org.wildfly.security.principal-transformer", forCapability, true)).build();
        SimpleAttributeDefinition finalprincipalTransformerAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_FINAL_PRINCIPAL_TRANSFORMER).setCapabilityReference("org.wildfly.security.principal-transformer", forCapability, true)).build();
        SimpleAttributeDefinition realmMapperAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_REALM_MAPPER).setCapabilityReference("org.wildfly.security.realm-mapper", forCapability, true)).build();
        ObjectTypeAttributeDefinition mechanismRealmConfiguration = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("mechanism-realm-configuration", new AttributeDefinition[]{REALM_NAME, preRealmPrincipalTransformerAttribute, postRealmPrincipalTransformerAttribute, finalprincipalTransformerAttribute, realmMapperAttribute}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setXmlName("mechanism-realm")).build();
        ObjectListAttributeDefinition mechanismRealmConfigurations = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("mechanism-realm-configurations", mechanismRealmConfiguration).setRequired(false)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAttributeParser(AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER)).setAttributeMarshaller(AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER)).build();
        SimpleAttributeDefinition credentialSecurityFactoryAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_CREDENTIAL_SECURITY_FACTORY).setCapabilityReference("org.wildfly.security.security-factory.credential", forCapability, true)).build();
        ObjectTypeAttributeDefinition mechanismConfiguration = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("mechanism-configuration", new AttributeDefinition[]{MECHANISM_NAME, HOST_NAME, PROTOCOL, preRealmPrincipalTransformerAttribute, postRealmPrincipalTransformerAttribute, finalprincipalTransformerAttribute, realmMapperAttribute, mechanismRealmConfigurations, credentialSecurityFactoryAttribute}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setXmlName("mechanism")).build();
        return ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("mechanism-configurations", mechanismConfiguration).setRequired(false)).setRestartAllServices()).setXmlName("mechanism-configuration")).build();
    }

    static Set<String> getConfiguredMechanismNames(AttributeDefinition mechanismConfigurationAttribute, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode mechanismConfiguration = mechanismConfigurationAttribute.resolveModelAttribute(context, model);
        if (!mechanismConfiguration.isDefined()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> mechanismNames = new LinkedHashSet<String>();
        for (ModelNode current : mechanismConfiguration.asList()) {
            String mechanismName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)MECHANISM_NAME, current);
            if (mechanismName == null) {
                return Collections.emptySet();
            }
            mechanismNames.add(mechanismName);
        }
        return mechanismNames;
    }

    static List<ResolvedMechanismConfiguration> getResolvedMechanismConfiguration(AttributeDefinition mechanismConfigurationAttribute, ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode mechanismConfiguration = mechanismConfigurationAttribute.resolveModelAttribute(context, model);
        if (!mechanismConfiguration.isDefined()) {
            return Collections.emptyList();
        }
        List mechanismConfigurations = mechanismConfiguration.asList();
        ArrayList<ResolvedMechanismConfiguration> resolvedMechanismConfigurations = new ArrayList<ResolvedMechanismConfiguration>(mechanismConfigurations.size());
        for (ModelNode currentMechanismConfiguration : mechanismConfigurations) {
            String mechanismName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)MECHANISM_NAME, currentMechanismConfiguration);
            String hostName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)HOST_NAME, currentMechanismConfiguration);
            String protocol = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROTOCOL, currentMechanismConfiguration);
            Predicate<MechanismInformation> selectionPredicate = null;
            if (mechanismName != null) {
                selectionPredicate = i -> mechanismName.equalsIgnoreCase(i.getMechanismName());
            }
            if (hostName != null) {
                Predicate<MechanismInformation> hostPredicate = i -> hostName.equalsIgnoreCase(i.getHostName());
                Predicate<MechanismInformation> predicate = selectionPredicate = selectionPredicate != null ? selectionPredicate.and(hostPredicate) : hostPredicate;
            }
            if (protocol != null) {
                Predicate<MechanismInformation> protocolPredicate = i -> protocol.equalsIgnoreCase(i.getProtocol());
                Predicate<MechanismInformation> predicate = selectionPredicate = selectionPredicate != null ? selectionPredicate.and(protocolPredicate) : protocolPredicate;
            }
            if (selectionPredicate == null) {
                selectionPredicate = i -> true;
            }
            ResolvedMechanismConfiguration resolvedMechanismConfiguration = new ResolvedMechanismConfiguration(selectionPredicate);
            AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_PRE_REALM_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismConfiguration, (Injector<PrincipalTransformer>)resolvedMechanismConfiguration.preRealmPrincipalTranformer);
            AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_POST_REALM_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismConfiguration, (Injector<PrincipalTransformer>)resolvedMechanismConfiguration.postRealmPrincipalTransformer);
            AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_FINAL_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismConfiguration, (Injector<PrincipalTransformer>)resolvedMechanismConfiguration.finalPrincipalTransformer);
            AuthenticationFactoryDefinitions.injectRealmMapper(BASE_REALM_MAPPER, serviceBuilder, context, currentMechanismConfiguration, (Injector<RealmMapper>)resolvedMechanismConfiguration.realmMapper);
            AuthenticationFactoryDefinitions.injectSecurityFactory(BASE_CREDENTIAL_SECURITY_FACTORY, serviceBuilder, context, currentMechanismConfiguration, resolvedMechanismConfiguration.securityFactory);
            if (currentMechanismConfiguration.hasDefined("mechanism-realm-configurations")) {
                for (ModelNode currentMechanismRealm : currentMechanismConfiguration.require("mechanism-realm-configurations").asList()) {
                    String realmName = REALM_NAME.resolveModelAttribute(context, currentMechanismRealm).asString();
                    ResolvedMechanismRealmConfiguration resolvedMechanismRealmConfiguration = new ResolvedMechanismRealmConfiguration();
                    AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_PRE_REALM_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismRealm, resolvedMechanismRealmConfiguration.preRealmPrincipalTranformer);
                    AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_POST_REALM_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismRealm, resolvedMechanismRealmConfiguration.postRealmPrincipalTransformer);
                    AuthenticationFactoryDefinitions.injectPrincipalTransformer(BASE_FINAL_PRINCIPAL_TRANSFORMER, serviceBuilder, context, currentMechanismRealm, resolvedMechanismRealmConfiguration.finalPrincipalTransformer);
                    AuthenticationFactoryDefinitions.injectRealmMapper(BASE_REALM_MAPPER, serviceBuilder, context, currentMechanismRealm, resolvedMechanismRealmConfiguration.realmMapper);
                    resolvedMechanismConfiguration.mechanismRealms.put(realmName, resolvedMechanismRealmConfiguration);
                }
            }
            resolvedMechanismConfigurations.add(resolvedMechanismConfiguration);
        }
        return resolvedMechanismConfigurations;
    }

    static void buildMechanismConfiguration(List<ResolvedMechanismConfiguration> resolvedMechanismConfigurations, MechanismAuthenticationFactory.Builder factoryBuilder) {
        ArrayList<MechanismConfigurationSelector> mechanismConfigurationSelectors = new ArrayList<MechanismConfigurationSelector>(resolvedMechanismConfigurations.size());
        for (ResolvedMechanismConfiguration resolvedMechanismConfiguration : resolvedMechanismConfigurations) {
            MechanismConfiguration.Builder builder = MechanismConfiguration.builder();
            AuthenticationFactoryDefinitions.setPrincipalTransformer((InjectedValue<PrincipalTransformer>)resolvedMechanismConfiguration.preRealmPrincipalTranformer, arg_0 -> ((MechanismConfiguration.Builder)builder).setPreRealmRewriter(arg_0));
            AuthenticationFactoryDefinitions.setPrincipalTransformer((InjectedValue<PrincipalTransformer>)resolvedMechanismConfiguration.postRealmPrincipalTransformer, arg_0 -> ((MechanismConfiguration.Builder)builder).setPostRealmRewriter(arg_0));
            AuthenticationFactoryDefinitions.setPrincipalTransformer((InjectedValue<PrincipalTransformer>)resolvedMechanismConfiguration.finalPrincipalTransformer, arg_0 -> ((MechanismConfiguration.Builder)builder).setFinalRewriter(arg_0));
            AuthenticationFactoryDefinitions.setRealmMapper((InjectedValue<RealmMapper>)resolvedMechanismConfiguration.realmMapper, arg_0 -> ((MechanismConfiguration.Builder)builder).setRealmMapper(arg_0));
            AuthenticationFactoryDefinitions.setSecurityFactory(resolvedMechanismConfiguration.securityFactory, arg_0 -> ((MechanismConfiguration.Builder)builder).setServerCredential(arg_0));
            for (Map.Entry<String, ResolvedMechanismRealmConfiguration> currentMechRealmEntry : resolvedMechanismConfiguration.mechanismRealms.entrySet()) {
                MechanismRealmConfiguration.Builder mechRealmBuilder = MechanismRealmConfiguration.builder();
                mechRealmBuilder.setRealmName(currentMechRealmEntry.getKey());
                ResolvedMechanismRealmConfiguration resolvedMechanismRealmConfiguration = currentMechRealmEntry.getValue();
                AuthenticationFactoryDefinitions.setPrincipalTransformer(resolvedMechanismRealmConfiguration.preRealmPrincipalTranformer, arg_0 -> ((MechanismRealmConfiguration.Builder)mechRealmBuilder).setPreRealmRewriter(arg_0));
                AuthenticationFactoryDefinitions.setPrincipalTransformer(resolvedMechanismRealmConfiguration.postRealmPrincipalTransformer, arg_0 -> ((MechanismRealmConfiguration.Builder)mechRealmBuilder).setPostRealmRewriter(arg_0));
                AuthenticationFactoryDefinitions.setPrincipalTransformer(resolvedMechanismRealmConfiguration.finalPrincipalTransformer, arg_0 -> ((MechanismRealmConfiguration.Builder)mechRealmBuilder).setFinalRewriter(arg_0));
                AuthenticationFactoryDefinitions.setRealmMapper(resolvedMechanismRealmConfiguration.realmMapper, arg_0 -> ((MechanismRealmConfiguration.Builder)mechRealmBuilder).setRealmMapper(arg_0));
                builder.addMechanismRealm(mechRealmBuilder.build());
            }
            mechanismConfigurationSelectors.add(MechanismConfigurationSelector.predicateSelector(resolvedMechanismConfiguration.selectionPredicate, (MechanismConfiguration)builder.build()));
        }
        factoryBuilder.setMechanismConfigurationSelector(MechanismConfigurationSelector.aggregate((MechanismConfigurationSelector[])mechanismConfigurationSelectors.toArray(new MechanismConfigurationSelector[mechanismConfigurationSelectors.size()])));
    }

    private static void setPrincipalTransformer(InjectedValue<PrincipalTransformer> injectedValue, Consumer<Function<Principal, Principal>> principalTransformerConsumer) {
        PrincipalTransformer principalTransformer = (PrincipalTransformer)injectedValue.getOptionalValue();
        if (principalTransformer != null) {
            principalTransformerConsumer.accept(principalTransformer);
        }
    }

    private static void injectPrincipalTransformer(SimpleAttributeDefinition principalTransformerAttribute, ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model, Injector<PrincipalTransformer> principalTransformer) throws OperationFailedException {
        String principalTransformerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)principalTransformerAttribute, model);
        if (principalTransformerName != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.principal-transformer", (String)principalTransformerName), PrincipalTransformer.class), PrincipalTransformer.class, principalTransformer);
        }
    }

    private static void setSecurityFactory(InjectedValue<SecurityFactory> injectedValue, Consumer<SecurityFactory> securityFactoryConsumer) {
        SecurityFactory securityFactory = (SecurityFactory)injectedValue.getOptionalValue();
        if (securityFactory != null) {
            securityFactoryConsumer.accept(securityFactory);
        }
    }

    private static void injectSecurityFactory(SimpleAttributeDefinition securityFactoryAttribute, ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model, Injector<SecurityFactory> securityFactoryInjector) throws OperationFailedException {
        String securityFactory = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)securityFactoryAttribute, model);
        if (securityFactory != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-factory.credential", (String)securityFactory), SecurityFactory.class), SecurityFactory.class, securityFactoryInjector);
        }
    }

    private static void setRealmMapper(InjectedValue<RealmMapper> injectedValue, Consumer<RealmMapper> realmMapperConsumer) {
        RealmMapper realmMapper = (RealmMapper)injectedValue.getOptionalValue();
        if (realmMapper != null) {
            realmMapperConsumer.accept(realmMapper);
        }
    }

    private static void injectRealmMapper(SimpleAttributeDefinition realmMapperAttribute, ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model, Injector<RealmMapper> realmMapperInjector) throws OperationFailedException {
        String realmMapper = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)realmMapperAttribute, model);
        if (realmMapper != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)realmMapper), RealmMapper.class), RealmMapper.class, realmMapperInjector);
        }
    }

    static ResourceDefinition getHttpAuthenticationFactory() {
        final SimpleAttributeDefinition securityDomainAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_SECURITY_DOMAIN_REF).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.http-authentication-factory", true)).setRestartAllServices()).build();
        final AttributeDefinition mechanismConfigurationAttribute = AuthenticationFactoryDefinitions.getMechanismConfiguration("org.wildfly.security.http-authentication-factory");
        AttributeDefinition[] attributes = new AttributeDefinition[]{securityDomainAttribute, HTTP_SERVER_MECHANISM_FACTORY, mechanismConfigurationAttribute};
        TrivialAddHandler<HttpAuthenticationFactory> add = new TrivialAddHandler<HttpAuthenticationFactory>(HttpAuthenticationFactory.class, attributes, new RuntimeCapability[]{Capabilities.HTTP_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<HttpAuthenticationFactory> getValueSupplier(ServiceBuilder<HttpAuthenticationFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InjectedValue securityDomainInjector = new InjectedValue();
                InjectedValue mechanismFactoryInjector = new InjectedValue();
                String securityDomain = securityDomainAttribute.resolveModelAttribute(context, model).asString();
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-domain", (String)securityDomain), SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
                String httpServerFactory = HTTP_SERVER_MECHANISM_FACTORY.resolveModelAttribute(context, model).asString();
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.http-server-mechanism-factory", (String)httpServerFactory), HttpServerAuthenticationMechanismFactory.class), HttpServerAuthenticationMechanismFactory.class, (Injector)mechanismFactoryInjector);
                Set<String> supportedMechanisms = AuthenticationFactoryDefinitions.getConfiguredMechanismNames(mechanismConfigurationAttribute, context, model);
                List<ResolvedMechanismConfiguration> resolvedMechanismConfigurations = AuthenticationFactoryDefinitions.getResolvedMechanismConfiguration(mechanismConfigurationAttribute, serviceBuilder, context, model);
                return () -> {
                    HttpServerAuthenticationMechanismFactory serverFactory = (HttpServerAuthenticationMechanismFactory)mechanismFactoryInjector.getValue();
                    if (!supportedMechanisms.isEmpty()) {
                        serverFactory = new FilterServerMechanismFactory(serverFactory, true, (Collection)supportedMechanisms);
                        String[] mechanisms = supportedMechanisms.toArray(new String[supportedMechanisms.size()]);
                        serverFactory = new SortedServerMechanismFactory(serverFactory, (a, b) -> {
                            for (String definedMech : mechanisms) {
                                if (a.equals(definedMech)) {
                                    return -1;
                                }
                                if (!b.equals(definedMech)) continue;
                                return 1;
                            }
                            return 0;
                        });
                    } else {
                        serverFactory = new SortedServerMechanismFactory(serverFactory, (x$0, x$1) -> AuthenticationFactoryDefinitions.compareHttp(x$0, x$1));
                    }
                    HttpAuthenticationFactory.Builder builder = HttpAuthenticationFactory.builder().setSecurityDomain((SecurityDomain)securityDomainInjector.getValue()).setFactory(serverFactory);
                    AuthenticationFactoryDefinitions.buildMechanismConfiguration(resolvedMechanismConfigurations, (MechanismAuthenticationFactory.Builder)builder);
                    return builder.build();
                };
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new TrivialResourceDefinition("http-authentication-factory", add, attributes, Capabilities.HTTP_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY), AuthenticationFactoryDefinitions::getAvailableHttpMechanisms);
    }

    private static String[] getAvailableHttpMechanisms(OperationContext context) {
        RuntimeCapability runtimeCapability = Capabilities.HTTP_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
        ServiceName securityDomainHttpConfigurationName = runtimeCapability.getCapabilityServiceName(HttpAuthenticationFactory.class);
        ServiceController<HttpAuthenticationFactory> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), securityDomainHttpConfigurationName, HttpAuthenticationFactory.class);
        if (serviceContainer.getState() != ServiceController.State.UP) {
            return null;
        }
        Collection mechanismNames = ((HttpAuthenticationFactory)serviceContainer.getValue()).getMechanismNames();
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    static ResourceDefinition getSaslAuthenticationFactory() {
        final SimpleAttributeDefinition securityDomainAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(BASE_SECURITY_DOMAIN_REF).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.security.sasl-authentication-factory", true)).setRestartAllServices()).build();
        final AttributeDefinition mechanismConfigurationAttribute = AuthenticationFactoryDefinitions.getMechanismConfiguration("org.wildfly.security.sasl-authentication-factory");
        AttributeDefinition[] attributes = new AttributeDefinition[]{securityDomainAttribute, SASL_SERVER_FACTORY, mechanismConfigurationAttribute};
        TrivialAddHandler<SaslAuthenticationFactory> add = new TrivialAddHandler<SaslAuthenticationFactory>(SaslAuthenticationFactory.class, attributes, new RuntimeCapability[]{Capabilities.SASL_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY}){

            @Override
            protected TrivialService.ValueSupplier<SaslAuthenticationFactory> getValueSupplier(ServiceBuilder<SaslAuthenticationFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String securityDomain = securityDomainAttribute.resolveModelAttribute(context, model).asString();
                String saslServerFactory = SASL_SERVER_FACTORY.resolveModelAttribute(context, model).asString();
                InjectedValue securityDomainInjector = new InjectedValue();
                InjectedValue saslServerFactoryInjector = new InjectedValue();
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.security-domain", (String)securityDomain), SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.sasl-server-factory", (String)saslServerFactory), SaslServerFactory.class), SaslServerFactory.class, (Injector)saslServerFactoryInjector);
                Set<String> supportedMechanisms = AuthenticationFactoryDefinitions.getConfiguredMechanismNames(mechanismConfigurationAttribute, context, model);
                List<ResolvedMechanismConfiguration> resolvedMechanismConfigurations = AuthenticationFactoryDefinitions.getResolvedMechanismConfiguration(mechanismConfigurationAttribute, serviceBuilder, context, model);
                return () -> {
                    SaslServerFactory serverFactory = (SaslServerFactory)saslServerFactoryInjector.getValue();
                    if (!supportedMechanisms.isEmpty()) {
                        serverFactory = new FilterMechanismSaslServerFactory(serverFactory, true, (Collection)supportedMechanisms);
                        serverFactory = new SortedMechanismSaslServerFactory(serverFactory, supportedMechanisms.toArray(new String[supportedMechanisms.size()]));
                    } else {
                        serverFactory = new SortedMechanismSaslServerFactory(serverFactory, (x$0, x$1) -> AuthenticationFactoryDefinitions.compareSasl(x$0, x$1));
                    }
                    SaslAuthenticationFactory.Builder builder = SaslAuthenticationFactory.builder().setSecurityDomain((SecurityDomain)securityDomainInjector.getValue()).setFactory(serverFactory);
                    AuthenticationFactoryDefinitions.buildMechanismConfiguration(resolvedMechanismConfigurations, (MechanismAuthenticationFactory.Builder)builder);
                    return builder.build();
                };
            }
        };
        return AvailableMechanismsRuntimeResource.wrap((ResourceDefinition)new TrivialResourceDefinition("sasl-authentication-factory", add, attributes, Capabilities.SASL_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY), AuthenticationFactoryDefinitions::getAvailableSaslMechanisms);
    }

    private static String[] getAvailableSaslMechanisms(OperationContext context) {
        RuntimeCapability runtimeCapability = Capabilities.SASL_AUTHENTICATION_FACTORY_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
        ServiceName securityDomainSaslConfigurationName = runtimeCapability.getCapabilityServiceName(SaslAuthenticationFactory.class);
        ServiceController<SaslAuthenticationFactory> serviceContainer = ElytronExtension.getRequiredService(context.getServiceRegistry(false), securityDomainSaslConfigurationName, SaslAuthenticationFactory.class);
        if (serviceContainer.getState() != ServiceController.State.UP) {
            return null;
        }
        Collection mechanismNames = ((SaslAuthenticationFactory)serviceContainer.getValue()).getMechanismNames();
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    private static int compareSasl(String nameOne, String nameTwo) {
        return AuthenticationFactoryDefinitions.toPrioritySasl(nameTwo) - AuthenticationFactoryDefinitions.toPrioritySasl(nameOne);
    }

    private static int toPrioritySasl(String name) {
        switch (name) {
            case "EXTERNAL": {
                return 30;
            }
            case "GSSAPI": {
                return 20;
            }
            case "JBOSS-LOCAL-USER": {
                return 10;
            }
            case "PLAIN": {
                return -10;
            }
            case "ANONYMOUS": {
                return -20;
            }
        }
        return 0;
    }

    private static int compareHttp(String nameOne, String nameTwo) {
        return AuthenticationFactoryDefinitions.toPriorityHttp(nameTwo) - AuthenticationFactoryDefinitions.toPriorityHttp(nameOne);
    }

    private static int toPriorityHttp(String name) {
        switch (name) {
            case "CLIENT_CERT": {
                return 30;
            }
            case "SPNEGO": {
                return 20;
            }
            case "BEARER_TOKEN": {
                return 10;
            }
            case "BASIC": {
                return -10;
            }
        }
        return 0;
    }

    private static class ResolvedMechanismConfiguration
    extends ResolvedMechanismRealmConfiguration {
        final Predicate<MechanismInformation> selectionPredicate;
        final Map<String, ResolvedMechanismRealmConfiguration> mechanismRealms = new HashMap<String, ResolvedMechanismRealmConfiguration>();
        final InjectedValue<SecurityFactory> securityFactory = new InjectedValue();

        ResolvedMechanismConfiguration(Predicate<MechanismInformation> selectionPredicate) {
            this.selectionPredicate = selectionPredicate;
        }
    }

    private static class ResolvedMechanismRealmConfiguration {
        final InjectedValue<PrincipalTransformer> preRealmPrincipalTranformer = new InjectedValue();
        final InjectedValue<PrincipalTransformer> postRealmPrincipalTransformer = new InjectedValue();
        final InjectedValue<PrincipalTransformer> finalPrincipalTransformer = new InjectedValue();
        final InjectedValue<RealmMapper> realmMapper = new InjectedValue();

        private ResolvedMechanismRealmConfiguration() {
        }
    }
}

