/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.authz.jacc.DelegatingPolicyContextHandler;
import org.wildfly.security.authz.jacc.ElytronPolicyConfigurationFactory;
import org.wildfly.security.authz.jacc.ElytronPolicyContextHandlerFactory;
import org.wildfly.security.authz.jacc.PolicyUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

class PolicyDefinitions {
    static final SimpleAttributeDefinition RESOURCE_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setMinSize(1)).build();
    static final SimpleAttributeDefinition DEFAULT_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-policy", ModelType.STRING).setRequired(false)).setCorrector(new ParameterCorrector(){

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            return new ModelNode();
        }
    })).setDeprecated(ElytronExtension.ELYTRON_1_2_0)).build();

    PolicyDefinitions() {
    }

    static ResourceDefinition getPolicy() {
        final AttributeDefinition[] attributes = new AttributeDefinition[]{DEFAULT_POLICY, JaccPolicyDefinition.POLICY, CustomPolicyDefinition.POLICY};
        BaseAddHandler add = new BaseAddHandler((RuntimeCapability)Capabilities.POLICY_RUNTIME_CAPABILITY){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                resource.getModel().get(DEFAULT_POLICY.getName()).clear();
            }

            @Override
            protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.recordCapabilitiesAndRequirements(context, operation, resource);
                if (resource.getModel().hasDefined("jacc-policy")) {
                    context.registerCapability(Capabilities.JACC_POLICY_RUNTIME_CAPABILITY);
                }
            }

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                CapabilityServiceSupport capabilitySupport = context.getCapabilityServiceSupport();
                boolean legacyJacc = capabilitySupport.hasCapability("org.wildfly.legacy-security.jacc");
                boolean legacyJaccTombstone = capabilitySupport.hasCapability("org.wildfly.legacy-security.jacc.tombstone");
                if (legacyJacc) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToEnableJaccSupport();
                }
                if (legacyJaccTombstone) {
                    context.restartRequired();
                } else {
                    ServiceName serviceName = Capabilities.POLICY_RUNTIME_CAPABILITY.getCapabilityServiceName(Policy.class);
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    Consumer<Consumer<Policy>> policyConsumer = PolicyDefinitions.getPolicyProvider(context, model);
                    ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, this.createPolicyService(policyConsumer));
                    if (model.get("jacc-policy").isDefined()) {
                        serviceBuilder.addAliases(new ServiceName[]{Capabilities.JACC_POLICY_RUNTIME_CAPABILITY.getCapabilityServiceName()});
                    }
                    serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                    if (!context.isBooting()) {
                        context.reloadRequired();
                    }
                }
            }

            private Service<Policy> createPolicyService(final Consumer<Consumer<Policy>> policyProvider) {
                return new Service<Policy>(){
                    volatile Policy original;

                    public void start(StartContext context) throws StartException {
                        this.original = this.getPolicy();
                        try {
                            policyProvider.accept(this::setPolicy);
                        }
                        catch (Exception cause) {
                            this.setPolicy(this.original);
                            throw new StartException((Throwable)cause);
                        }
                    }

                    public void stop(StopContext context) {
                        this.setPolicy(this.original);
                    }

                    public Policy getValue() throws IllegalStateException, IllegalArgumentException {
                        return this.getPolicy();
                    }

                    private void setPolicy(Policy policy) {
                        if (policy != null) {
                            policy.refresh();
                        }
                        try {
                            if (WildFlySecurityManager.isChecking()) {
                                AccessController.doPrivileged(this.setPolicyAction(policy));
                            } else {
                                this.setPolicyAction(policy).run();
                            }
                        }
                        catch (Exception e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToSetPolicy(policy, e);
                        }
                    }

                    private PrivilegedAction<Void> setPolicyAction(Policy policy) {
                        return () -> {
                            PolicyUtil.setPolicy((Policy)policy);
                            return null;
                        };
                    }

                    private Policy getPolicy() {
                        if (WildFlySecurityManager.isChecking()) {
                            return AccessController.doPrivileged(this.getPolicyAction());
                        }
                        return this.getPolicyAction().run();
                    }

                    private PrivilegedAction<Policy> getPolicyAction() {
                        return PolicyUtil::getPolicy;
                    }
                };
            }
        };
        return new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"policy"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("policy")).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new AbstractRemoveStepHandler(){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                super.performRuntime(context, operation, model);
                if (model.get("jacc-policy").isDefined()) {
                    context.restartRequired();
                } else {
                    context.reloadRequired();
                }
            }

            protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.recordCapabilitiesAndRequirements(context, operation, resource);
                context.deregisterCapability("org.wildfly.security.jacc-policy");
            }

            protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                if (model.get("jacc-policy").isDefined()) {
                    context.revertRestartRequired();
                } else {
                    context.revertReloadRequired();
                }
            }
        }).setAddRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.POLICY_RUNTIME_CAPABILITY}).setMaxOccurs(1)){

            public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
                ReloadRequiredWriteAttributeHandler write = new ReloadRequiredWriteAttributeHandler(){

                    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
                        super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
                        if ("jacc-policy".equals(attributeDefinition.getName())) {
                            if (!newValue.isDefined()) {
                                context.deregisterCapability("org.wildfly.security.jacc-policy");
                            } else if (!oldValue.isDefined()) {
                                context.registerCapability(Capabilities.JACC_POLICY_RUNTIME_CAPABILITY);
                            }
                        }
                    }
                };
                for (AttributeDefinition current : attributes) {
                    if (current != DEFAULT_POLICY) {
                        resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                        continue;
                    }
                    resourceRegistration.registerReadWriteAttribute(current, null, ModelOnlyWriteAttributeHandler.INSTANCE);
                }
            }
        };
    }

    private static Consumer<Consumer<Policy>> getPolicyProvider(OperationContext context, ModelNode model) throws OperationFailedException {
        Consumer<Consumer<Policy>> result = PolicyDefinitions.configureJaccPolicy(context, model);
        if (result == null) {
            result = PolicyDefinitions.configureCustomPolicy(context, model);
        }
        return result;
    }

    private static Consumer<Consumer<Policy>> configureCustomPolicy(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode policyModel = model.get("custom-policy");
        if (policyModel.isDefined()) {
            String className = CustomPolicyDefinition.CLASS_NAME.resolveModelAttribute(context, policyModel).asString();
            String module = CustomPolicyDefinition.MODULE.resolveModelAttribute(context, policyModel).asStringOrNull();
            return t -> {
                try {
                    t.accept(PolicyDefinitions.newPolicy(className, ClassLoadingAttributeDefinitions.resolveClassLoader(module)));
                }
                catch (ModuleLoadException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadModuleRuntime(module, (Exception)((Object)e));
                }
            };
        }
        return null;
    }

    private static Consumer<Consumer<Policy>> configureJaccPolicy(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode policyModel = model.get("jacc-policy");
        if (policyModel.isDefined()) {
            final String policyProvider = JaccPolicyDefinition.POLICY_PROVIDER.resolveModelAttribute(context, policyModel).asString();
            final String configurationFactory = JaccPolicyDefinition.CONFIGURATION_FACTORY.resolveModelAttribute(context, policyModel).asString();
            final boolean defaultConfigurationFactory = configurationFactory.equals(JaccPolicyDefinition.CONFIGURATION_FACTORY.getDefaultValue().asString());
            final String module = JaccPolicyDefinition.MODULE.resolveModelAttribute(context, policyModel).asStringOrNull();
            return new Consumer<Consumer<Policy>>(){

                @Override
                public void accept(Consumer<Policy> policyConsumer) {
                    try {
                        ClassLoader configuredClassLoader = ClassLoadingAttributeDefinitions.resolveClassLoader(module);
                        Policy policy = PolicyDefinitions.newPolicy(policyProvider, configuredClassLoader);
                        policyConsumer.accept(policy);
                        SecurityActions.doPrivileged(() -> PolicyDefinitions.newPolicyConfigurationFactory(configurationFactory, defaultConfigurationFactory ? PolicyDefinitions.class.getClassLoader() : configuredClassLoader));
                        Map<String, PolicyContextHandler> discoveredHandlers = this.discoverPolicyContextHandlers();
                        List supportedPolicyContextHandlers = ElytronPolicyContextHandlerFactory.getPolicyContextHandlers();
                        for (PolicyContextHandler policyContextHandler : supportedPolicyContextHandlers) {
                            this.registerHandler(discoveredHandlers, policyContextHandler);
                        }
                        for (Map.Entry entry : discoveredHandlers.entrySet()) {
                            PolicyContext.registerHandler((String)((String)entry.getKey()), (PolicyContextHandler)((PolicyContextHandler)entry.getValue()), (boolean)true);
                        }
                    }
                    catch (Exception cause) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.failedToRegisterPolicyHandlers(cause);
                    }
                }

                private void registerHandler(Map<String, PolicyContextHandler> discoveredHandlers, PolicyContextHandler handler) throws PolicyContextException {
                    for (String key : handler.getKeys()) {
                        PolicyContextHandler discovered = discoveredHandlers.remove(key);
                        if (discovered != null) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("Registering DelegatingPolicyContextHandler for key '%s'.", key);
                            PolicyContext.registerHandler((String)key, (PolicyContextHandler)new DelegatingPolicyContextHandler(key, handler, discovered), (boolean)true);
                            continue;
                        }
                        PolicyContext.registerHandler((String)key, (PolicyContextHandler)handler, (boolean)true);
                    }
                }

                private Map<String, PolicyContextHandler> discoverPolicyContextHandlers() throws PolicyContextException {
                    HashMap<String, PolicyContextHandler> handlerMap = new HashMap<String, PolicyContextHandler>();
                    ServiceLoader<PolicyContextHandler> serviceLoader = ServiceLoader.load(PolicyContextHandler.class, PolicyDefinitions.class.getClassLoader());
                    for (PolicyContextHandler handler : serviceLoader) {
                        for (String key : handler.getKeys()) {
                            if (handlerMap.put(key, handler) != null) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.duplicatePolicyContextHandler(key);
                            }
                            if (!ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) continue;
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("Discovered PolicyContextHandler '%s' for key '%s'.", handler.getClass().getName(), key);
                        }
                    }
                    return handlerMap;
                }
            };
        }
        return null;
    }

    private static Policy newPolicy(String className, ClassLoader classLoader) {
        try {
            Object policy = classLoader.loadClass(className).newInstance();
            return (Policy)Policy.class.cast(policy);
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.failedToCreatePolicy(className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyConfigurationFactory newPolicyConfigurationFactory(String className, ClassLoader classLoader) throws PolicyContextException, ClassNotFoundException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            System.setProperty(PolicyConfigurationFactory.class.getName() + ".provider", className);
            PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            String loadedClassName = policyConfigurationFactory.getClass().getName();
            if (!className.equals(loadedClassName)) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidImplementationLoaded(PolicyConfigurationFactory.class.getCanonicalName(), className, loadedClassName);
            }
            PolicyConfigurationFactory policyConfigurationFactory2 = policyConfigurationFactory;
            return policyConfigurationFactory2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    static class JaccPolicyDefinition {
        static final SimpleAttributeDefinition NAME = RESOURCE_NAME;
        static final SimpleAttributeDefinition POLICY_PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("policy", ModelType.STRING, true).setDefaultValue(new ModelNode("org.wildfly.security.authz.jacc.JaccDelegatingPolicy"))).setMinSize(1)).build();
        static final SimpleAttributeDefinition CONFIGURATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("configuration-factory", ModelType.STRING, true).setDefaultValue(new ModelNode(ElytronPolicyConfigurationFactory.class.getName()))).setMinSize(1)).build();
        static final SimpleAttributeDefinition MODULE = ClassLoadingAttributeDefinitions.MODULE;
        static final ObjectTypeAttributeDefinition POLICY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("jacc-policy", new AttributeDefinition[]{POLICY_PROVIDER, CONFIGURATION_FACTORY, MODULE}).setRequired(true)).setRestartJVM()).setAlternatives(new String[]{"custom-policy"})).setCorrector((ParameterCorrector)ListToObjectCorrector.INSTANCE)).build();

        JaccPolicyDefinition() {
        }
    }

    static class CustomPolicyDefinition {
        static final SimpleAttributeDefinition NAME = RESOURCE_NAME;
        static final SimpleAttributeDefinition CLASS_NAME = ClassLoadingAttributeDefinitions.CLASS_NAME;
        static final SimpleAttributeDefinition MODULE = ClassLoadingAttributeDefinitions.MODULE;
        static final ObjectTypeAttributeDefinition POLICY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("custom-policy", new AttributeDefinition[]{CLASS_NAME, MODULE}).setRequired(true)).setAlternatives(new String[]{"jacc-policy"})).setCorrector((ParameterCorrector)ListToObjectCorrector.INSTANCE)).build();

        CustomPolicyDefinition() {
        }
    }

    private static class ListToObjectCorrector
    implements ParameterCorrector {
        private static final ListToObjectCorrector INSTANCE = new ListToObjectCorrector();

        private ListToObjectCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = newValue;
            if (newValue.getType() == ModelType.LIST && newValue.asInt() == 1 && (result = newValue.get(0)).has("name")) {
                result.remove("name");
            }
            return result;
        }
    }
}

