/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron.capabilities.CredentialSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.auth.util.GSSCredentialSecurityFactory;
import org.wildfly.security.credential.Credential;

class KerberosSecurityFactoryDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PRINCIPAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MINIMUM_REMAINING_LIFETIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("minimum-remaining-lifetime", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REQUEST_LIFETIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-lifetime", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Integer.MAX_VALUE))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SERVER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition OBTAIN_KERBEROS_TICKET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("obtain-kerberos-ticket", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEBUG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("debug", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WRAP_GSS_CREDENTIAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("wrap-gss-credential", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REQUIRED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("required", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).setRestartAllServices()).build();
    private static final ModelNode mechanismsDefault = new ModelNode();
    private static final String[] mechanismAllowedValues = new String[]{"KRB5LEGACY", "GENERIC", "KRB5", "KRB5V2", "SPNEGO"};
    static final StringListAttributeDefinition MECHANISM_NAMES;
    static final StringListAttributeDefinition MECHANISM_OIDS;
    static final PropertiesAttributeDefinition OPTIONS;

    KerberosSecurityFactoryDefinition() {
    }

    static ResourceDefinition getKerberosSecurityFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PRINCIPAL, FileAttributeDefinitions.RELATIVE_TO, PATH, MINIMUM_REMAINING_LIFETIME, REQUEST_LIFETIME, SERVER, OBTAIN_KERBEROS_TICKET, DEBUG, MECHANISM_NAMES, MECHANISM_OIDS, WRAP_GSS_CREDENTIAL, REQUIRED, OPTIONS};
        TrivialAddHandler<CredentialSecurityFactory> add = new TrivialAddHandler<CredentialSecurityFactory>(CredentialSecurityFactory.class, attributes, Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<CredentialSecurityFactory> getValueSupplier(ServiceBuilder<CredentialSecurityFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                HashMap<String, String> options;
                ModelNode optionsNode;
                String principal = PRINCIPAL.resolveModelAttribute(context, model).asString();
                int minimumRemainingLifetime = MINIMUM_REMAINING_LIFETIME.resolveModelAttribute(context, model).asInt();
                int requestLifetime = REQUEST_LIFETIME.resolveModelAttribute(context, model).asInt();
                boolean server = SERVER.resolveModelAttribute(context, model).asBoolean();
                boolean obtainKerberosTicket = OBTAIN_KERBEROS_TICKET.resolveModelAttribute(context, model).asBoolean();
                boolean debug = DEBUG.resolveModelAttribute(context, model).asBoolean();
                boolean wrapGssCredential = WRAP_GSS_CREDENTIAL.resolveModelAttribute(context, model).asBoolean();
                boolean required = REQUIRED.resolveModelAttribute(context, model).asBoolean();
                Stream<String> oidsFromNames = MECHANISM_NAMES.unwrap((ExpressionResolver)context, model).stream().map(name -> OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.GSS, (String)name));
                Stream directOids = MECHANISM_OIDS.unwrap((ExpressionResolver)context, model).stream();
                Set mechanismOids = Stream.concat(oidsFromNames, directOids).map(s -> {
                    try {
                        return new Oid((String)s);
                    }
                    catch (GSSException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).collect(Collectors.toSet());
                InjectedValue pathManager = new InjectedValue();
                String path = PATH.resolveModelAttribute(context, model).asString();
                String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                if ((optionsNode = OPTIONS.resolveModelAttribute(context, model)).isDefined()) {
                    options = new HashMap<String, String>();
                    for (Property option : optionsNode.asPropertyList()) {
                        options.put(option.getName(), option.getValue().asString());
                    }
                } else {
                    options = null;
                }
                return () -> {
                    FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                    pathResolver.path(path);
                    if (relativeTo != null) {
                        pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                    }
                    File resolvedPath = pathResolver.resolve();
                    GSSCredentialSecurityFactory.Builder builder = GSSCredentialSecurityFactory.builder().setPrincipal(principal).setKeyTab(resolvedPath).setMinimumRemainingLifetime(minimumRemainingLifetime).setRequestLifetime(requestLifetime).setIsServer(server).setObtainKerberosTicket(obtainKerberosTicket).setDebug(debug).setWrapGssCredential(wrapGssCredential).setCheckKeyTab(required).setOptions(options);
                    mechanismOids.forEach(arg_0 -> ((GSSCredentialSecurityFactory.Builder)builder).addMechanismOid(arg_0));
                    try {
                        return CredentialSecurityFactory.from((SecurityFactory<? extends Credential>)builder.build());
                    }
                    catch (IOException e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }
        };
        return new TrivialResourceDefinition("kerberos-security-factory", add, attributes, Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY);
    }

    static {
        mechanismsDefault.add("KRB5");
        mechanismsDefault.add("SPNEGO");
        MECHANISM_NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("mechanism-names").setAllowExpression(true)).setRequired(false)).setDefaultValue(mechanismsDefault)).setAllowedValues(new String[]{"KRB5LEGACY", "GENERIC", "KRB5", "KRB5V2", "SPNEGO"})).setMinSize(1)).setMaxSize(mechanismAllowedValues.length)).setValidator((ParameterValidator)new StringAllowedValuesValidator(mechanismAllowedValues))).setRestartAllServices()).build();
        MECHANISM_OIDS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("mechanism-oids").setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
        OPTIONS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("options", true).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, "option", false))).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(null, "option", false))).setRestartAllServices()).build();
    }
}

