/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_0;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_1;
import org.wildfly.extension.elytron.ElytronSubsystemParser1_2;
import org.wildfly.extension.elytron.ElytronSubsystemParser2_0;
import org.wildfly.security.auth.client.AuthenticationContext;

public class ElytronExtension
implements Extension {
    static final String NAMESPACE_1_0 = "urn:wildfly:elytron:1.0";
    static final String NAMESPACE_1_1 = "urn:wildfly:elytron:1.1";
    static final String NAMESPACE_1_2 = "urn:wildfly:elytron:1.2";
    static final String NAMESPACE_2_0 = "urn:wildfly:elytron:2.0";
    public static final String SUBSYSTEM_NAME = "elytron";
    public static final AttachmentKey<AuthenticationContext> AUTHENTICATION_CONTEXT_KEY = AttachmentKey.create(AuthenticationContext.class);
    static final ModelVersion ELYTRON_1_2_0 = ModelVersion.create((int)1, (int)2);
    private static final ModelVersion ELYTRON_2_0_0;
    private static final ModelVersion ELYTRON_CURRENT;
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final PathElement SUBSYSTEM_PATH;
    private static final String RESOURCE_NAME;
    static final ServiceName BASE_SERVICE_NAME;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder(SUBSYSTEM_NAME);
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, ElytronExtension.class.getClassLoader(), true, false);
    }

    static boolean isServerOrHostController(ImmutableManagementResourceRegistration resourceRegistration) {
        return resourceRegistration.getProcessType().isServer() || !"profile".equals(resourceRegistration.getPathAddress().getElement(0).getKey());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_0, ElytronSubsystemParser1_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_1, ElytronSubsystemParser1_1::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_1_2, ElytronSubsystemParser1_2::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE_2_0, ElytronSubsystemParser2_0::new);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, ELYTRON_CURRENT);
        subsystemRegistration.setHostCapable();
        ManagementResourceRegistration registration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)ElytronDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystemRegistration.registerXMLElementWriter(ElytronSubsystemParser2_0::new);
    }

    static <T> ServiceController<T> getRequiredService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getRequiredService(serviceName);
        return controller;
    }

    static String asStringIfDefined(OperationContext context, AttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asString();
        }
        return null;
    }

    static String[] asStringArrayIfDefined(OperationContext context, StringListAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode resolved = attributeDefinition.resolveModelAttribute(context, model);
        if (resolved.isDefined()) {
            List values = resolved.asList();
            String[] response = new String[values.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = ((ModelNode)values.get(i)).asString();
            }
            return response;
        }
        return null;
    }

    static Double asDoubleIfDefined(OperationContext context, SimpleAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asDouble();
        }
        return null;
    }

    static int asIntIfDefined(OperationContext context, SimpleAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asInt();
        }
        return -1;
    }

    static {
        ELYTRON_CURRENT = ELYTRON_2_0_0 = ModelVersion.create((int)2);
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
        RESOURCE_NAME = ElytronExtension.class.getPackage().getName() + ".LocalDescriptions";
        BASE_SERVICE_NAME = ServiceName.of((String[])new String[]{SUBSYSTEM_NAME});
    }
}

