/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.jdbc.ColumnMapper;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.realm.jdbc.KeyMapper;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.realm.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.SecurityRealm;

class JdbcRealmDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<SecurityRealm> REALM_SERVICE_UTIL = ServiceUtil.newInstance(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, "jdbc-realm", SecurityRealm.class);
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PrincipalQueryAttributes.PRINCIPAL_QUERIES};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    private static final OperationStepHandler WRITE = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);

    JdbcRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"jdbc-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("jdbc-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, WRITE);
        }
    }

    private static KeyMapper resolveKeyMappers(OperationContext context, ModelNode authenticationQueryNode) throws OperationFailedException {
        PasswordKeyMapper keyMapper = null;
        for (String name : authenticationQueryNode.keys()) {
            PasswordMapperObjectDefinition mapperResource;
            ModelNode propertyNode = authenticationQueryNode.require(name);
            if (!propertyNode.isDefined() || (mapperResource = PrincipalQueryAttributes.SUPPORTED_PASSWORD_MAPPERS.get(name)) == null) continue;
            if (keyMapper != null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.jdbcRealmOnlySingleKeyMapperAllowed();
            }
            try {
                keyMapper = mapperResource.toPasswordKeyMapper(context, propertyNode);
            }
            catch (InvalidKeyException e) {
                throw new OperationFailedException("Invalid key type.", (Throwable)e);
            }
        }
        return keyMapper;
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            ModelNode principalQueries = PrincipalQueryAttributes.PRINCIPAL_QUERIES.resolveModelAttribute(context, operation);
            JdbcSecurityRealmBuilder builder = JdbcSecurityRealm.builder();
            TrivialService<SecurityRealm> service = new TrivialService<SecurityRealm>(() -> ((JdbcSecurityRealmBuilder)builder).build());
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, service);
            for (ModelNode query : principalQueries.asList()) {
                String authenticationQuerySql = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PrincipalQueryAttributes.SQL, query);
                final QueryBuilder queryBuilder = builder.principalQuery(authenticationQuerySql).withMapper((ColumnMapper[])this.resolveAttributeMappers(context, query)).withMapper(new ColumnMapper[]{JdbcRealmDefinition.resolveKeyMappers(context, query)});
                String dataSourceName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PrincipalQueryAttributes.DATA_SOURCE, query);
                String capabilityName = "org.wildfly.data-source." + dataSourceName;
                ServiceName dataSourceServiceName = context.getCapabilityServiceName(capabilityName, DataSource.class);
                serviceBuilder.addDependency(dataSourceServiceName, DataSource.class, (Injector)new Injector<DataSource>(){

                    public void inject(DataSource value) throws InjectionException {
                        queryBuilder.from(value);
                    }

                    public void uninject() {
                    }
                });
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private AttributeMapper[] resolveAttributeMappers(OperationContext context, ModelNode principalQueryNode) throws OperationFailedException {
            ArrayList<AttributeMapper> attributeMappers = new ArrayList<AttributeMapper>();
            ModelNode attributeMappingNode = PrincipalQueryAttributes.ATTRIBUTE_MAPPINGS.resolveModelAttribute(context, principalQueryNode);
            if (attributeMappingNode.isDefined()) {
                for (ModelNode attributeNode : attributeMappingNode.asList()) {
                    ModelNode indexNode = AttributeMappingObjectDefinition.INDEX.resolveModelAttribute(context, attributeNode);
                    ModelNode nameNode = AttributeMappingObjectDefinition.TO.resolveModelAttribute(context, attributeNode);
                    attributeMappers.add(new AttributeMapper(indexNode.asInt(), nameNode.asString()));
                }
            }
            return attributeMappers.toArray(new AttributeMapper[attributeMappers.size()]);
        }
    }

    static class PrincipalQueryAttributes {
        static final SimpleAttributeDefinition SQL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sql", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("data-source", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.data-source", "org.wildfly.security.security-realm", true)).build();
        static final ObjectListAttributeDefinition ATTRIBUTE_MAPPINGS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("attribute-mapping", AttributeMappingObjectDefinition.OBJECT_DEFINITION).setRequired(false)).setAttributeGroup("attribute")).setAllowDuplicates(true)).build();
        static Map<String, PasswordMapperObjectDefinition> SUPPORTED_PASSWORD_MAPPERS;
        static final ObjectTypeAttributeDefinition PRINCIPAL_QUERY;
        static final ObjectListAttributeDefinition PRINCIPAL_QUERIES;

        PrincipalQueryAttributes() {
        }

        static {
            HashMap<String, PasswordMapperObjectDefinition> supportedMappers = new HashMap<String, PasswordMapperObjectDefinition>();
            supportedMappers.put("clear-password-mapper", new ClearPasswordObjectDefinition());
            supportedMappers.put("bcrypt-mapper", new BcryptPasswordObjectDefinition());
            supportedMappers.put("salted-simple-digest-mapper", new SaltedSimpleDigestObjectDefinition());
            supportedMappers.put("simple-digest-mapper", new SimpleDigestMapperObjectDefinition());
            supportedMappers.put("scram-mapper", new ScramMapperObjectDefinition());
            SUPPORTED_PASSWORD_MAPPERS = Collections.unmodifiableMap(supportedMappers);
            PRINCIPAL_QUERY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("principal-query", new AttributeDefinition[]{SQL, DATA_SOURCE, ATTRIBUTE_MAPPINGS, ClearPasswordObjectDefinition.OBJECT_DEFINITION, BcryptPasswordObjectDefinition.OBJECT_DEFINITION, SaltedSimpleDigestObjectDefinition.OBJECT_DEFINITION, SimpleDigestMapperObjectDefinition.OBJECT_DEFINITION, ScramMapperObjectDefinition.OBJECT_DEFINITION}).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
            PRINCIPAL_QUERIES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("principal-query", PRINCIPAL_QUERY).setMinSize(1)).setAllowDuplicates(true)).setRestartAllServices()).build();
        }
    }

    static class AttributeMappingObjectDefinition {
        static final SimpleAttributeDefinition INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("index", ModelType.INT, false).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("to", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{TO, INDEX};
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = new ObjectTypeAttributeDefinition.Builder("attribute", (AttributeDefinition[])ATTRIBUTES).build();

        AttributeMappingObjectDefinition() {
        }
    }

    static interface PasswordMapperObjectDefinition {
        public ObjectTypeAttributeDefinition getObjectDefinition();

        public SimpleAttributeDefinition[] getAttributes();

        public PasswordKeyMapper toPasswordKeyMapper(OperationContext var1, ModelNode var2) throws OperationFailedException, InvalidKeyException;
    }

    static class ScramMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("scram-sha-256"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"scram-sha-1", "scram-sha-256"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("scram-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ScramMapperObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD, SALT, ITERATION_COUNT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            int iterationCount = ElytronExtension.asIntIfDefined(context, ITERATION_COUNT, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).build();
        }
    }

    static class SimpleDigestMapperObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("simple-digest-md5"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"simple-digest-md2", "simple-digest-md5", "simple-digest-sha-1", "simple-digest-sha-256", "simple-digest-sha-384", "simple-digest-sha-512"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SimpleDigestMapperObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).build();
        }
    }

    static class SaltedSimpleDigestObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("password-salt-digest-md5"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"password-salt-digest-md5", "password-salt-digest-sha-1", "password-salt-digest-sha-256", "password-salt-digest-sha-384", "password-salt-digest-sha-512", "salt-password-digest-md5", "salt-password-digest-sha-1", "salt-password-digest-sha-256", "salt-password-digest-sha-384", "salt-password-digest-sha-512"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("salted-simple-digest-mapper", new AttributeDefinition[]{ALGORITHM, PASSWORD, SALT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        SaltedSimpleDigestObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{ALGORITHM, PASSWORD, SALT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).build();
        }
    }

    static class BcryptPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("bcrypt"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"bcrypt"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition ITERATION_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("iteration-count-index", ModelType.INT, false).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition SALT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("salt-index", ModelType.INT, false).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("bcrypt-mapper", new AttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        BcryptPasswordObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{PASSWORD, SALT, ITERATION_COUNT};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            int salt = ElytronExtension.asIntIfDefined(context, SALT, propertyNode);
            int iterationCount = ElytronExtension.asIntIfDefined(context, ITERATION_COUNT, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).setSaltColumn(salt).setIterationCountColumn(iterationCount).build();
        }
    }

    static class ClearPasswordObjectDefinition
    implements PasswordMapperObjectDefinition {
        static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode("clear"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"clear"}))).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password-index", ModelType.INT, false).setMinSize(1)).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        static final ObjectTypeAttributeDefinition OBJECT_DEFINITION = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("clear-password-mapper", new AttributeDefinition[]{PASSWORD}).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

        ClearPasswordObjectDefinition() {
        }

        @Override
        public ObjectTypeAttributeDefinition getObjectDefinition() {
            return OBJECT_DEFINITION;
        }

        @Override
        public SimpleAttributeDefinition[] getAttributes() {
            return new SimpleAttributeDefinition[]{PASSWORD};
        }

        @Override
        public PasswordKeyMapper toPasswordKeyMapper(OperationContext context, ModelNode propertyNode) throws OperationFailedException, InvalidKeyException {
            String algorithm = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ALGORITHM, propertyNode);
            int password = ElytronExtension.asIntIfDefined(context, PASSWORD, propertyNode);
            return PasswordKeyMapper.builder().setDefaultAlgorithm(algorithm).setHashColumn(password).build();
        }
    }
}

