/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.extension.io.OutboundBindAddressUtils;

final class OutboundBindAddressRemoveHandler
extends AbstractRemoveStepHandler {
    OutboundBindAddressRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        CidrAddressTable<InetSocketAddress> bindingsTable = OutboundBindAddressUtils.getWorkerService(context).getBindingsTable();
        if (bindingsTable != null) {
            CidrAddress cidrAddress = OutboundBindAddressUtils.getCidrAddress(operation, context);
            InetSocketAddress bindAddress = OutboundBindAddressUtils.getBindAddress(operation, context);
            bindingsTable.removeExact(cidrAddress, (Object)bindAddress);
        }
    }
}

