/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.net.CidrAddressTable;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class WorkerService
implements Service<XnioWorker> {
    private final XnioWorker.Builder builder;
    private CidrAddressTable<InetSocketAddress> bindingsTable;
    private XnioWorker worker;
    private volatile StopContext stopContext;

    public WorkerService(OptionMap optionMap) {
        this(Xnio.getInstance().createWorkerBuilder().populateFromOptions(optionMap));
    }

    public WorkerService(XnioWorker.Builder builder) {
        this.builder = builder;
    }

    public void start(StartContext startContext) throws StartException {
        this.builder.setTerminationTask(this::stopDone);
        this.bindingsTable = this.builder.getBindAddressConfigurations();
        this.worker = this.builder.build();
    }

    public void stop(StopContext context) {
        this.stopContext = context;
        context.asynchronous();
        this.worker.shutdown();
        this.worker = null;
    }

    private void stopDone() {
        StopContext stopContext = this.stopContext;
        this.stopContext = null;
        assert (stopContext != null);
        stopContext.complete();
    }

    CidrAddressTable<InetSocketAddress> getBindingsTable() {
        return this.bindingsTable;
    }

    public XnioWorker getValue() throws IllegalStateException, IllegalArgumentException {
        return this.worker;
    }
}

