/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.io.IORootDefinition;
import org.wildfly.extension.io.IOSubsystemParser_1_0;
import org.wildfly.extension.io.IOSubsystemParser_1_1;
import org.wildfly.extension.io.IOSubsystemParser_2_0;
import org.wildfly.extension.io.Namespace;
import org.wildfly.extension.io.logging.IOLogger;

public class IOExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "io";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"io");
    protected static final PathElement BUFFER_POOL_PATH = PathElement.pathElement((String)"buffer-pool");
    protected static final PathElement WORKER_PATH = PathElement.pathElement((String)"worker");
    private static final String RESOURCE_NAME = IOExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final ModelNode NO_METRICS = new ModelNode(IOLogger.ROOT_LOGGER.noMetrics());

    public static StandardResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, IOExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.IO_1_0.getUriString(), IOSubsystemParser_1_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.IO_1_1.getUriString(), IOSubsystemParser_1_1::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.IO_2_0.getUriString(), IOSubsystemParser_2_0::new);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, ModelVersion.create((int)3));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)IORootDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)new IOSubsystemParser_2_0());
    }
}

