/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.common.net.Inet;
import org.wildfly.extension.io.OutboundBindAddressResourceDefinition;
import org.wildfly.extension.io.OutboundBindAddressUtils;
import org.wildfly.extension.io.logging.IOLogger;

final class OutboundBindAddressAddHandler
extends AbstractAddStepHandler {
    OutboundBindAddressAddHandler() {
        super(OutboundBindAddressResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        InetSocketAddress bindAddress;
        CidrAddress cidrAddress;
        InetSocketAddress existing;
        CidrAddressTable<InetSocketAddress> bindingsTable = OutboundBindAddressUtils.getWorkerService(context).getBindingsTable();
        if (bindingsTable != null && (existing = (InetSocketAddress)bindingsTable.putIfAbsent(cidrAddress = OutboundBindAddressUtils.getCidrAddress(operation, context), (Object)(bindAddress = OutboundBindAddressUtils.getBindAddress(operation, context)))) != null) {
            throw IOLogger.ROOT_LOGGER.unexpectedBindAddressConflict(context.getCurrentAddress(), cidrAddress, bindAddress, existing);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        OutboundBindAddressUtils.getWorkerService(context).getBindingsTable().removeExact(Inet.parseCidrAddress((String)operation.require("match").asString()), (Object)new InetSocketAddress(Inet.parseInetAddress((String)operation.require("bind-address").asString()), operation.get("bind-port").asInt(0)));
    }
}

