/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.jmx.MBeanServerExt;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class MBeanRegistrationService<T>
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "registration"});
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private final InjectedValue<T> value = new InjectedValue();
    private final String name;
    private ObjectName objectName;
    private final List<SetupAction> setupActions;

    public MBeanRegistrationService(String name, List<SetupAction> setupActions) {
        this.name = name;
        this.setupActions = setupActions;
    }

    public MBeanRegistrationService(String name, List<SetupAction> setupActions, Value<T> value) {
        this(name, setupActions);
        this.value.inject(value.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mBeanServer = this.getMBeanServer();
        Object value = this.value.getValue();
        try {
            this.objectName = new ObjectName(this.name);
        }
        catch (MalformedObjectNameException e) {
            throw JmxLogger.ROOT_LOGGER.mbeanRegistrationFailed(e, this.name);
        }
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(Collections.emptyMap());
            }
            try {
                JmxLogger.ROOT_LOGGER.debugf("Registering [%s] with name [%s]", value, this.objectName);
                if (mBeanServer instanceof MBeanServerExt) {
                    ((MBeanServerExt)MBeanServerExt.class.cast(mBeanServer)).registerMBeanInternal(value, this.objectName);
                } else {
                    mBeanServer.registerMBean(value, this.objectName);
                }
            }
            catch (Exception e) {
                throw JmxLogger.ROOT_LOGGER.mbeanRegistrationFailed(e, this.name);
            }
        }
        finally {
            for (SetupAction action : this.setupActions) {
                action.teardown(Collections.emptyMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        if (this.objectName == null) {
            JmxLogger.ROOT_LOGGER.cannotUnregisterObject();
        }
        MBeanServer mBeanServer = this.getMBeanServer();
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(Collections.emptyMap());
            }
            try {
                mBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                JmxLogger.ROOT_LOGGER.unregistrationFailure(e, this.objectName);
            }
        }
        finally {
            for (SetupAction action : this.setupActions) {
                action.teardown(Collections.emptyMap());
            }
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public Injector<MBeanServer> getMBeanServerInjector() {
        return this.injectedMBeanServer;
    }

    public Injector<T> getValueInjector() {
        return this.value;
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = (MBeanServer)this.injectedMBeanServer.getOptionalValue();
        if (mBeanServer == null) {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mBeanServer;
    }
}

