/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.jmx.PluggableMBeanServerImpl;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ModelControllerMBeanServerPlugin;
import org.jboss.as.server.Services;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MBeanServerService
implements Service<PluggableMBeanServer> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final String resolvedDomainName;
    private final String expressionsDomainName;
    private final boolean legacyWithProperPropertyFormat;
    private final boolean coreMBeanSensitivity;
    private final JmxAuthorizer authorizer;
    private final ManagedAuditLogger auditLoggerInfo;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final boolean forStandalone;
    private PluggableMBeanServer mBeanServer;
    private MBeanServerPlugin showModelPlugin;

    private MBeanServerService(String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, boolean coreMBeanSensitivity, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, boolean forStandalone) {
        this.resolvedDomainName = resolvedDomainName;
        this.expressionsDomainName = expressionsDomainName;
        this.legacyWithProperPropertyFormat = legacyWithProperPropertyFormat;
        this.coreMBeanSensitivity = coreMBeanSensitivity;
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.forStandalone = forStandalone;
    }

    @SafeVarargs
    public static ServiceController<?> addService(ServiceTarget batchBuilder, String resolvedDomainName, String expressionsDomainName, boolean legacyWithProperPropertyFormat, boolean coreMBeanSensitivity, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, boolean forStandalone, ServiceListener<? super PluggableMBeanServer> ... listeners) {
        MBeanServerService service = new MBeanServerService(resolvedDomainName, expressionsDomainName, legacyWithProperPropertyFormat, coreMBeanSensitivity, auditLoggerInfo, authorizer, forStandalone);
        return batchBuilder.addService(SERVICE_NAME, (Service)service).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        MBeanServer platform = ManagementFactory.getPlatformMBeanServer();
        ServiceContainer container = context.getController().getServiceContainer();
        PluggableMBeanServerImpl pluggable = platform instanceof PluggableMBeanServerImpl ? (PluggableMBeanServerImpl)((Object)platform) : new PluggableMBeanServerImpl(platform, null, container);
        MBeanServerDelegate delegate = platform instanceof PluggableMBeanServerImpl ? ((PluggableMBeanServerImpl)((Object)platform)).getMBeanServerDelegate() : null;
        pluggable.setAuditLogger(this.auditLoggerInfo);
        pluggable.setAuthorizer(this.authorizer);
        this.authorizer.setNonFacadeMBeansSensitive(this.coreMBeanSensitivity);
        if (this.resolvedDomainName != null || this.expressionsDomainName != null) {
            ConfiguredDomains configuredDomains = new ConfiguredDomains(this.resolvedDomainName, this.expressionsDomainName);
            this.showModelPlugin = new ModelControllerMBeanServerPlugin(configuredDomains, (ModelController)this.modelControllerValue.getValue(), delegate, this.legacyWithProperPropertyFormat, this.forStandalone);
            pluggable.addPlugin(this.showModelPlugin);
        }
        this.mBeanServer = pluggable;
    }

    public synchronized void stop(StopContext context) {
        this.mBeanServer.removePlugin(this.showModelPlugin);
        this.mBeanServer = null;
    }

    public synchronized PluggableMBeanServer getValue() throws IllegalStateException {
        return this.mBeanServer;
    }
}

