/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.as.jmx.DelegateMBeanServerPlugin;
import org.jboss.as.jmx.MBeanServerExt;
import org.jboss.as.jmx.ServiceNameFactory;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class MscMBeanServer
extends DelegateMBeanServerPlugin
implements MBeanServerExt {
    private final ServiceContainer container;

    public MscMBeanServer(MBeanServerPlugin delegate, ServiceContainer container) {
        super(delegate);
        this.container = container;
    }

    private ServiceContainer getContainer() {
        if (this.container == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return this.container;
    }

    private static ServiceName toServiceName(String name) {
        return ServiceNameFactory.newServiceName(name);
    }

    private void addMBean(ObjectInstance instance) {
        this.addMBean(instance, true);
    }

    private void addMBean(ObjectInstance instance, boolean addAliases) {
        ServiceContainer sc = this.getContainer();
        if (sc == null) {
            return;
        }
        ObjectName objectName = instance.getObjectName();
        String canonicalName = objectName.getCanonicalName();
        ServiceName serviceName = MscMBeanServer.toServiceName(canonicalName);
        ServiceBuilder builder = sc.addService(serviceName, (Service)new MBeanService(instance));
        if (addAliases) {
            builder.addAliases(new ServiceName[]{ServiceNameFactory.newCreateDestroy(canonicalName)});
            builder.addAliases(new ServiceName[]{ServiceNameFactory.newStartStop(canonicalName)});
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void removeMBean(ObjectName name) {
        ServiceContainer sc = this.getContainer();
        if (sc == null) {
            return;
        }
        ServiceController service = sc.getService(MscMBeanServer.toServiceName(name.getCanonicalName()));
        if (service != null) {
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(service);
            service.setMode(ServiceController.Mode.REMOVE);
            try {
                monitor.awaitStability();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                monitor.removeController(service);
            }
        }
    }

    @Override
    public ObjectInstance registerMBeanInternal(Object mbean, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance instance = super.registerMBean(mbean, name);
        this.addMBean(instance, false);
        return instance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        ObjectInstance instance = super.createMBean(className, name, params, signature);
        this.addMBean(instance);
        return instance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance instance = super.createMBean(className, name, loaderName, params, signature);
        this.addMBean(instance);
        return instance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance instance = super.createMBean(className, name, loaderName);
        this.addMBean(instance);
        return instance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        ObjectInstance instance = super.createMBean(className, name);
        this.addMBean(instance);
        return instance;
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance instance = super.registerMBean(object, name);
        this.addMBean(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            super.unregisterMBean(name);
        }
        finally {
            this.removeMBean(name);
        }
    }

    private static class MBeanService
    implements Service<ObjectInstance> {
        private ObjectInstance instance;

        private MBeanService(ObjectInstance instance) {
            this.instance = instance;
        }

        public void start(StartContext context) throws StartException {
        }

        public void stop(StopContext context) {
        }

        public ObjectInstance getValue() throws IllegalStateException, IllegalArgumentException {
            return this.instance;
        }
    }
}

