/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JMXSubsystemRemove;
import org.jboss.as.jmx.JmxAuditLoggerResourceDefinition;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.PluggableMBeanServerImpl;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class JMXSubsystemRootResource
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"jmx");
    private static final SimpleAttributeDefinition SHOW_MODEL_ALIAS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"show-model", (ModelType)ModelType.BOOLEAN, (boolean)true).addFlag(AttributeAccess.Flag.ALIAS)).build();
    public static final SimpleAttributeDefinition CORE_MBEAN_SENSITIVITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("non-core-mbean-sensitivity", ModelType.BOOLEAN, true).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.ACCESS_CONTROL)).setXmlName("non-core-mbeans")).setDefaultValue(new ModelNode(false))).build();
    private final List<AccessConstraintDefinition> accessConstraints = JMXExtension.JMX_SENSITIVITY_DEF.wrapAsList();
    private final ManagedAuditLogger auditLogger;
    private final JmxAuthorizer authorizer;

    private JMXSubsystemRootResource(ManagedAuditLogger auditLogger, JmxAuthorizer authorizer) {
        super(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("jmx"), (OperationStepHandler)new JMXSubsystemAdd(auditLogger, authorizer), (OperationStepHandler)new JMXSubsystemRemove(auditLogger, authorizer));
        this.auditLogger = auditLogger;
        this.authorizer = authorizer;
    }

    public static JMXSubsystemRootResource create(ManagedAuditLogger auditLogger, JmxAuthorizer authorizer) {
        return new JMXSubsystemRootResource(auditLogger, authorizer);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SHOW_MODEL_ALIAS, (OperationStepHandler)ShowModelAliasReadHandler.INSTANCE, (OperationStepHandler)ShowModelAliasWriteHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CORE_MBEAN_SENSITIVITY, null, (OperationStepHandler)CoreMBeansSensitivityWriteHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceResolved(this.auditLogger, this.authorizer));
        resourceRegistration.registerSubModel((ResourceDefinition)new ExposeModelResourceExpression(this.auditLogger, this.authorizer));
        resourceRegistration.registerSubModel((ResourceDefinition)RemotingConnectorResource.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)new JmxAuditLoggerResourceDefinition(this.auditLogger));
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    private static class CoreMBeansSensitivityWriteHandler
    extends AbstractWriteAttributeHandler<Boolean> {
        static final CoreMBeansSensitivityWriteHandler INSTANCE = new CoreMBeansSensitivityWriteHandler();

        private CoreMBeansSensitivityWriteHandler() {
            super(new AttributeDefinition[]{CORE_MBEAN_SENSITIVITY});
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
            this.setPluggableMBeanServerCoreSensitivity(context, resolvedValue.asBoolean());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
            this.setPluggableMBeanServerCoreSensitivity(context, valueToRestore.asBoolean());
        }

        private void setPluggableMBeanServerCoreSensitivity(OperationContext context, boolean sensitivity) {
            ServiceController controller = context.getServiceRegistry(false).getRequiredService(MBeanServerService.SERVICE_NAME);
            PluggableMBeanServerImpl server = (PluggableMBeanServerImpl)controller.getValue();
            server.setNonFacadeMBeansSensitive(sensitivity);
        }
    }

    private static class ShowModelAliasReadHandler
    implements OperationStepHandler {
        static final ShowModelAliasReadHandler INSTANCE = new ShowModelAliasReadHandler();

        private ShowModelAliasReadHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            context.getResult().set(resource.hasChild(PathElement.pathElement((String)"expose-model", (String)"resolved")));
        }
    }

    private static class ShowModelAliasWriteHandler
    implements OperationStepHandler {
        static final ShowModelAliasWriteHandler INSTANCE = new ShowModelAliasWriteHandler();

        private ShowModelAliasWriteHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean value = operation.get("value").asBoolean(false);
            boolean hasResource = context.readResource(PathAddress.EMPTY_ADDRESS).hasChild(ExposeModelResourceResolved.PATH_ELEMENT);
            if (value) {
                if (!hasResource) {
                    OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "add").getOperationHandler();
                    ModelNode addOp = new ModelNode();
                    addOp.get("operation").set("add");
                    addOp.get("address").set(PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                    context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
                }
            } else if (hasResource) {
                OperationStepHandler handler = context.getResourceRegistration().getOperationEntry(PathAddress.pathAddress((PathElement[])new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}), "remove").getOperationHandler();
                ModelNode addOp = new ModelNode();
                addOp.get("operation").set("remove");
                addOp.get("address").set(PathAddress.pathAddress((ModelNode)operation.get("address")).append(new PathElement[]{ExposeModelResourceResolved.PATH_ELEMENT}).toModelNode());
                context.addStep(addOp, handler, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

