/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.jmx.Attribute;
import org.jboss.as.jmx.Element;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.JmxAuditLogHandlerReferenceResourceDefinition;
import org.jboss.as.jmx.JmxAuditLoggerResourceDefinition;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMXExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jmx";
    private static final String RESOURCE_NAME = JMXExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final SensitivityClassification JMX_SENSITIVITY = new SensitivityClassification("jmx", "jmx", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition JMX_SENSITIVITY_DEF = new SensitiveTargetAccessConstraintDefinition(JMX_SENSITIVITY);
    static final JMXSubsystemParser_1_3 parserCurrent = new JMXSubsystemParser_1_3();
    static final JMXSubsystemParser_1_2 parser12 = new JMXSubsystemParser_1_2();
    static final JMXSubsystemParser_1_1 parser11 = new JMXSubsystemParser_1_1();
    static final JMXSubsystemParser_1_0 parser10 = new JMXSubsystemParser_1_0();
    static final JMXSubsystemWriter writer = new JMXSubsystemWriter();
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, JMXExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagedAuditLogger auditLogger = (ManagedAuditLogger)((ExtensionRegistry.ExtensionContextImpl)context).getAuditLogger(false, true);
        JmxAuthorizer authorizer = ((ExtensionRegistry.ExtensionContextImpl)context).getAuthorizer();
        registration.registerSubsystemModel((ResourceDefinition)JMXSubsystemRootResource.create(auditLogger, authorizer));
        registration.registerXMLElementWriter((XMLElementWriter)writer);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(registration);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_0.getUriString(), (XMLElementReader)parser10);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_1.getUriString(), (XMLElementReader)parser11);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_2.getUriString(), (XMLElementReader)parser12);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JMX_1_3.getUriString(), (XMLElementReader)parserCurrent);
    }

    private static ModelNode createAddOperation() {
        return JMXExtension.createOperation("add", new String[0]);
    }

    private static ModelNode createOperation(String name, String ... addressElements) {
        ModelNode op = new ModelNode();
        op.get("operation").set(name);
        op.get("address").add("subsystem", SUBSYSTEM_NAME);
        for (int i = 0; i < addressElements.length; ++i) {
            op.get("address").add(addressElements[i], addressElements[++i]);
        }
        return op;
    }

    private void registerTransformers(SubsystemRegistration registration) {
        ModelVersion version1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);
        ModelVersion version1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getSubsystemVersion());
        this.buildTransformers1_1_0(chainedBuilder.createBuilder(registration.getSubsystemVersion(), version1_1_0));
        this.buildTransformers1_0_0(chainedBuilder.createBuilder(version1_1_0, version1_0_0));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{version1_0_0, version1_1_0}});
    }

    private void buildTransformers1_0_0(ResourceTransformationDescriptionBuilder builder) {
        builder.setCustomResourceTransformer(new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode model = resource.getModel();
                Resource exposeResolvedResource = resource.getChild(PathElement.pathElement((String)"expose-model", (String)"resolved"));
                boolean showModel = false;
                if (exposeResolvedResource != null) {
                    showModel = model.isDefined();
                }
                model.get("show-model").set(showModel);
                ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
                for (String type : resource.getChildTypes()) {
                    if (type.equals("expose-model")) continue;
                    for (Resource.ResourceEntry child : resource.getChildren(type)) {
                        childContext.processChild(child.getPathElement(), (Resource)child);
                    }
                }
            }
        });
        builder.rejectChildResource(PathElement.pathElement((String)"expose-model", (String)"expression"));
        ResourceTransformationDescriptionBuilder resolvedBuilder = builder.addChildResource(PathElement.pathElement((String)"expose-model", (String)"resolved"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)resolvedBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"domain-name", "proper-property-format"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return JmxLogger.ROOT_LOGGER.domainNameMustBeJBossAs();
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.isDefined() && !attributeValue.asString().equals("jboss.as");
            }
        }, new String[]{"domain-name"})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return JmxLogger.ROOT_LOGGER.properPropertyFormatMustBeFalse();
            }

            public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                return super.rejectOperationParameter(address, attributeName, attributeValue, operation, context);
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || attributeValue.getType() == ModelType.BOOLEAN && attributeValue.asBoolean();
            }
        }, new String[]{"proper-property-format"});
        resolvedBuilder.setCustomResourceTransformer(ResourceTransformer.DISCARD);
        resolvedBuilder.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)new ResolvedOperationTransformer(true));
        resolvedBuilder.addOperationTransformationOverride("remove").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)new ResolvedOperationTransformer(false));
        resolvedBuilder.addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        resolvedBuilder.addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        resolvedBuilder.addOperationTransformationOverride("read-attribute").setCustomOperationTransformer(new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, final ModelNode operation) throws OperationFailedException {
                return new OperationTransformer.TransformedOperation(null, new OperationResultTransformer(){

                    public ModelNode transformResult(ModelNode result) {
                        if (operation.get("name").asString().equals("domain-name")) {
                            result.get("result").set("jboss.as");
                        }
                        result.get("outcome").set("success");
                        result.get("result");
                        return result;
                    }
                });
            }
        });
        builder.addChildResource(RemotingConnectorResource.REMOTE_CONNECTOR_CONFIG_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT});
    }

    private void buildTransformers1_1_0(ResourceTransformationDescriptionBuilder builder) {
        this.rejectDefinedCoreMBeansSensitivity(builder);
        this.registerRejectAuditLogTransformers(builder);
    }

    private void rejectDefinedCoreMBeansSensitivity(ResourceTransformationDescriptionBuilder builder) {
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY});
    }

    private void registerRejectAuditLogTransformers(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder loggerBuilder = builder.addChildResource(JmxAuditLoggerResourceDefinition.PATH_ELEMENT);
        ((AttributeTransformationDescriptionBuilder)loggerBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{JmxAuditLoggerResourceDefinition.ENABLED})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return JmxLogger.ROOT_LOGGER.auditLogEnabledMustBeFalse();
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{JmxAuditLoggerResourceDefinition.ENABLED});
        loggerBuilder.setCustomResourceTransformer(ResourceTransformer.DISCARD);
        builder.rejectChildResource(JmxAuditLoggerResourceDefinition.PATH_ELEMENT);
        loggerBuilder.setCustomResourceTransformer(ResourceTransformer.DISCARD);
        loggerBuilder.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        loggerBuilder.addOperationTransformationOverride("remove").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        loggerBuilder.addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                if (operation.require("name").asString().equals(JmxAuditLoggerResourceDefinition.ENABLED.getName())) {
                    OperationRejectionPolicy rejectPolicy = new OperationRejectionPolicy(){

                        public boolean rejectOperation(ModelNode preparedResult) {
                            return true;
                        }

                        public String getFailureDescription() {
                            return JmxLogger.ROOT_LOGGER.auditLogEnabledMustBeFalse();
                        }
                    };
                    return new OperationTransformer.TransformedOperation(null, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
                }
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
        });
        loggerBuilder.addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        loggerBuilder.addOperationTransformationOverride("read-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(OperationTransformer.DISCARD);
        loggerBuilder.discardChildResource(JmxAuditLogHandlerReferenceResourceDefinition.PATH_ELEMENT);
    }

    private static class JMXSubsystemWriter
    implements XMLStreamConstants,
    XMLElementWriter<SubsystemMarshallingContext> {
        private JMXSubsystemWriter() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            Namespace schemaVer = Namespace.CURRENT;
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(schemaVer.getUriString(), false);
            if (node.hasDefined("expose-model")) {
                ModelNode showModel = node.get("expose-model");
                if (showModel.hasDefined("resolved")) {
                    writer.writeEmptyElement(Element.EXPOSE_RESOLVED_MODEL.getLocalName());
                    ExposeModelResourceResolved.DOMAIN_NAME.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                    ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.marshallAsAttribute(showModel.get("resolved"), false, (XMLStreamWriter)writer);
                }
                if (showModel.hasDefined("expression")) {
                    writer.writeEmptyElement(Element.EXPOSE_EXPRESSION_MODEL.getLocalName());
                    ExposeModelResourceExpression.DOMAIN_NAME.marshallAsAttribute(showModel.get("expression"), false, (XMLStreamWriter)writer);
                }
            }
            if (node.hasDefined("remoting-connector")) {
                writer.writeStartElement(Element.REMOTING_CONNECTOR.getLocalName());
                ModelNode resourceModel = node.get("remoting-connector").get(JMXExtension.SUBSYSTEM_NAME);
                RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.marshallAsAttribute(resourceModel, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            if (node.hasDefined(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey()) && node.get(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey()).hasDefined(JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue())) {
                ModelNode auditLog = node.get(new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue()});
                writer.writeStartElement(Element.AUDIT_LOG.getLocalName());
                JmxAuditLoggerResourceDefinition.LOG_BOOT.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                JmxAuditLoggerResourceDefinition.LOG_READ_ONLY.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                JmxAuditLoggerResourceDefinition.ENABLED.marshallAsAttribute(auditLog, (XMLStreamWriter)writer);
                if (auditLog.hasDefined("handler") && auditLog.get("handler").keys().size() > 0) {
                    writer.writeStartElement("handlers");
                    for (String key : auditLog.get("handler").keys()) {
                        writer.writeEmptyElement("handler");
                        writer.writeAttribute("name", key);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (node.hasDefined(JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.getName())) {
                writer.writeStartElement(Element.SENSITIVITY.getLocalName());
                JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.marshallAsAttribute(node, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static class JMXSubsystemParser_1_3
    extends JMXSubsystemParser_1_2 {
        private JMXSubsystemParser_1_3() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showResolvedModel = false;
            boolean showExpressionModel = false;
            boolean connectorAdd = false;
            boolean auditLog = false;
            boolean sensitivity = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode add = JMXExtension.createAddOperation();
            list.add(add);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case EXPOSE_RESOLVED_MODEL: {
                        if (showResolvedModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_RESOLVED_MODEL.getLocalName());
                        }
                        showResolvedModel = true;
                        list.add(this.parseShowModelElement(reader, "resolved"));
                        continue block7;
                    }
                    case EXPOSE_EXPRESSION_MODEL: {
                        if (showExpressionModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_EXPRESSION_MODEL.getLocalName());
                        }
                        showExpressionModel = true;
                        list.add(this.parseShowModelElement(reader, "expression"));
                        continue block7;
                    }
                    case REMOTING_CONNECTOR: {
                        if (connectorAdd) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.REMOTING_CONNECTOR.getLocalName());
                        }
                        connectorAdd = true;
                        list.add(this.parseRemoteConnector(reader));
                        continue block7;
                    }
                    case AUDIT_LOG: {
                        if (auditLog) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.AUDIT_LOG.getLocalName());
                        }
                        auditLog = true;
                        this.parseAuditLogElement(reader, list);
                        continue block7;
                    }
                    case SENSITIVITY: {
                        if (sensitivity) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SENSITIVITY.getLocalName());
                        }
                        sensitivity = true;
                        this.parseSensitivity(add, reader);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseSensitivity(ModelNode add, XMLExtendedStreamReader reader) throws XMLStreamException {
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NON_CORE_MBEANS: {
                        JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private void parseAuditLogElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode op = JMXExtension.createOperation("add", new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue()});
            int count = reader.getAttributeCount();
            block8: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case LOG_BOOT: {
                        JmxAuditLoggerResourceDefinition.LOG_BOOT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case LOG_READ_ONLY: {
                        JmxAuditLoggerResourceDefinition.LOG_READ_ONLY.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block8;
                    }
                    case ENABLED: {
                        JmxAuditLoggerResourceDefinition.ENABLED.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block8;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            list.add(op);
            block9: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case HANDLERS: {
                        this.parseAuditLogHandlers(reader, list);
                        continue block9;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseAuditLogHandlers(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case HANDLER: {
                        this.parseAuditLogHandler(reader, list);
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseAuditLogHandler(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            String name = null;
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = value;
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            ModelNode op = JMXExtension.createOperation("add", new String[]{JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getKey(), JmxAuditLoggerResourceDefinition.PATH_ELEMENT.getValue(), JmxAuditLogHandlerReferenceResourceDefinition.PATH_ELEMENT.getKey(), name});
            list.add(op);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private static class JMXSubsystemParser_1_2
    extends JMXSubsystemParser_1_1 {
        private JMXSubsystemParser_1_2() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showResolvedModel = false;
            boolean showExpressionModel = false;
            boolean connectorAdd = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            block5: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case EXPOSE_RESOLVED_MODEL: {
                        if (showResolvedModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_RESOLVED_MODEL.getLocalName());
                        }
                        showResolvedModel = true;
                        list.add(this.parseShowModelElement(reader, "resolved"));
                        continue block5;
                    }
                    case EXPOSE_EXPRESSION_MODEL: {
                        if (showExpressionModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.EXPOSE_EXPRESSION_MODEL.getLocalName());
                        }
                        showExpressionModel = true;
                        list.add(this.parseShowModelElement(reader, "expression"));
                        continue block5;
                    }
                    case REMOTING_CONNECTOR: {
                        if (connectorAdd) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.REMOTING_CONNECTOR.getLocalName());
                        }
                        connectorAdd = true;
                        list.add(this.parseRemoteConnector(reader));
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        protected ModelNode parseShowModelElement(XMLExtendedStreamReader reader, String showModelChild) throws XMLStreamException {
            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", showModelChild});
            Object domainName = null;
            Object properPropertyFormat = null;
            block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DOMAIN_NAME: {
                        ExposeModelResource.getDomainNameAttribute(showModelChild).parseAndSetParameter(value, op, (XMLStreamReader)reader);
                        continue block4;
                    }
                    case PROPER_PROPETY_FORMAT: {
                        if (showModelChild.equals("resolved")) {
                            ExposeModelResourceResolved.PROPER_PROPERTY_FORMAT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                            continue block4;
                        }
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (domainName == null && properPropertyFormat == null) {
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            }
            return op;
        }
    }

    private static class JMXSubsystemParser_1_1
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_1() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            boolean showModel = false;
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            Object connectorAdd = null;
            list.add(JMXExtension.createAddOperation());
            block4: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case SHOW_MODEL: {
                        if (showModel) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SHOW_MODEL.getLocalName());
                        }
                        if (this.parseShowModelElement(reader)) {
                            ModelNode op = JMXExtension.createOperation("add", new String[]{"expose-model", "resolved"});
                            op.get("proper-property-format").set(false);
                            list.add(op);
                        }
                        showModel = true;
                        continue block4;
                    }
                    case REMOTING_CONNECTOR: {
                        if (connectorAdd != null) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.REMOTING_CONNECTOR.getLocalName());
                        }
                        list.add(this.parseRemoteConnector(reader));
                        continue block4;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        protected ModelNode parseRemoteConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").add("subsystem", JMXExtension.SUBSYSTEM_NAME).add("remoting-connector", JMXExtension.SUBSYSTEM_NAME);
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case USE_MANAGEMENT_ENDPOINT: {
                        RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return connector;
        }

        private boolean parseShowModelElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
            return ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
        }
    }

    private static class JMXSubsystemParser_1_0
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>> {
        private JMXSubsystemParser_1_0() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(JMXExtension.createAddOperation());
            boolean gotConnector = false;
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case JMX_CONNECTOR: {
                        if (gotConnector) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.JMX_CONNECTOR.getLocalName());
                        }
                        this.parseConnector(reader);
                        gotConnector = true;
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseConnector(XMLExtendedStreamReader reader) throws XMLStreamException {
            JmxLogger.ROOT_LOGGER.jmxConnectorNotSupported();
            String serverBinding = null;
            String registryBinding = null;
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case SERVER_BINDING: {
                        serverBinding = value;
                        continue block4;
                    }
                    case REGISTRY_BINDING: {
                        registryBinding = value;
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (serverBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SERVER_BINDING));
            }
            if (registryBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REGISTRY_BINDING));
            }
        }
    }

    private static class ResolvedOperationTransformer
    implements OperationTransformer {
        private final boolean showModel;

        public ResolvedOperationTransformer(boolean showModel) {
            this.showModel = showModel;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            pathAddress = pathAddress.subAddress(0, pathAddress.size() - 1);
            ModelNode op = Util.getWriteAttributeOperation((PathAddress)pathAddress, (String)"show-model", (ModelNode)new ModelNode(this.showModel));
            return new OperationTransformer.TransformedOperation(op, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

