/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.JMXSubsystemRootResource;
import org.jboss.as.jmx.JmxEffect;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.security.auth.server.SecurityIdentity;

class JMXSubsystemAdd
extends AbstractAddStepHandler {
    private final ManagedAuditLogger auditLoggerInfo;
    private final JmxAuthorizer authorizer;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;
    private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

    JMXSubsystemAdd(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor) {
        super(JMXSubsystemRootResource.JMX_CAPABILITY, new AttributeDefinition[]{JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY});
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.hostInfoAccessor = hostInfoAccessor;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        JMXSubsystemAdd.launchServices(context, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)), this.auditLoggerInfo, this.authorizer, this.securityIdentitySupplier, this.hostInfoAccessor);
    }

    static void launchServices(OperationContext context, ModelNode model, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor) throws OperationFailedException {
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, model, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, model, "expression");
        boolean legacyWithProperPropertyFormat = false;
        if (model.hasDefined("proper-property-format")) {
            legacyWithProperPropertyFormat = ExposeModelResourceExpression.DOMAIN_NAME.resolveModelAttribute(context, model).asBoolean();
        }
        boolean coreMBeanSensitivity = JMXSubsystemRootResource.CORE_MBEAN_SENSITIVITY.resolveModelAttribute(context, model).asBoolean();
        boolean isMasterHc = context.getProcessType() == ProcessType.HOST_CONTROLLER ? hostInfoAccessor.getHostControllerInfo(context).isMasterHc() : false;
        JmxEffect jmxEffect = null;
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER) {
            ModelNode rootModel = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false).getModel();
            String hostName = null;
            if (rootModel.hasDefined("host")) {
                hostName = rootModel.get("host").asString();
            }
            String serverGroup = null;
            if (rootModel.hasDefined("server-group")) {
                serverGroup = rootModel.get("server-group").asString();
            }
            jmxEffect = new JmxEffect(hostName, serverGroup);
        }
        MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, coreMBeanSensitivity, auditLoggerInfo, authorizer, securityIdentitySupplier, jmxEffect, context.getProcessType(), isMasterHc, new ServiceListener[0]);
    }

    static String getDomainName(OperationContext context, ModelNode model, String child) throws OperationFailedException {
        if (!model.hasDefined("expose-model")) {
            return null;
        }
        if (!model.get("expose-model").hasDefined(child)) {
            return null;
        }
        ModelNode childModel = model.get(new String[]{"expose-model", child});
        return ExposeModelResource.getDomainNameAttribute(child).resolveModelAttribute(context, childModel).asString();
    }
}

