package org.jboss.as.jmx.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.management.AttributeNotFoundException;
import javax.management.Attribute;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import javax.management.JMRuntimeException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.management.RuntimeOperationsException;
import javax.management.ReflectionException;
import javax.annotation.Generated;
import javax.management.NotCompliantMBeanException;
import javax.management.InstanceNotFoundException;
import java.lang.Error;
import javax.management.InvalidAttributeValueException;
import java.lang.Exception;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import javax.management.MBeanException;
import org.jboss.dmr.ModelType;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-25T16:59:25-0500")
public class JmxLogger_$logger extends DelegatingBasicLogger implements JmxLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JmxLogger_$logger.class.getName();
    public JmxLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotUnregisterObject() {
        super.log.logf(FQCN, WARN, null, cannotUnregisterObject$str());
    }
    private static final String cannotUnregisterObject = "WFLYJMX0004: No ObjectName available to unregister";
    protected String cannotUnregisterObject$str() {
        return cannotUnregisterObject;
    }
    @Override
    public final void unregistrationFailure(final Throwable cause, final ObjectName name) {
        super.log.logf(FQCN, ERROR, cause, unregistrationFailure$str(), name);
    }
    private static final String unregistrationFailure = "WFLYJMX0005: Failed to unregister [%s]";
    protected String unregistrationFailure$str() {
        return unregistrationFailure;
    }
    @Override
    public final void jmxConnectorNotSupported() {
        super.log.logf(FQCN, WARN, null, jmxConnectorNotSupported$str());
    }
    private static final String jmxConnectorNotSupported = "WFLYJMX0006: <jmx-connector/> is no longer supporting. <remoting-connector/> should be used instead to allow remote connections via JBoss Remoting.";
    protected String jmxConnectorNotSupported$str() {
        return jmxConnectorNotSupported;
    }
    private static final String compositeEntryTypeName = "entry";
    protected String compositeEntryTypeName$str() {
        return compositeEntryTypeName;
    }
    @Override
    public final String compositeEntryTypeName() {
        return String.format(getLoggingLocale(), compositeEntryTypeName$str());
    }
    private static final String compositeEntryTypeDescription = "An entry";
    protected String compositeEntryTypeDescription$str() {
        return compositeEntryTypeDescription;
    }
    @Override
    public final String compositeEntryTypeDescription() {
        return String.format(getLoggingLocale(), compositeEntryTypeDescription$str());
    }
    private static final String compositeEntryKeyDescription = "The key";
    protected String compositeEntryKeyDescription$str() {
        return compositeEntryKeyDescription;
    }
    @Override
    public final String compositeEntryKeyDescription() {
        return String.format(getLoggingLocale(), compositeEntryKeyDescription$str());
    }
    private static final String compositeEntryValueDescription = "The value";
    protected String compositeEntryValueDescription$str() {
        return compositeEntryValueDescription;
    }
    @Override
    public final String compositeEntryValueDescription() {
        return String.format(getLoggingLocale(), compositeEntryValueDescription$str());
    }
    private static final String compositeMapName = "A map";
    protected String compositeMapName$str() {
        return compositeMapName;
    }
    @Override
    public final String compositeMapName() {
        return String.format(getLoggingLocale(), compositeMapName$str());
    }
    private static final String compositeMapDescription = "The map is indexed by 'key'";
    protected String compositeMapDescription$str() {
        return compositeMapDescription;
    }
    @Override
    public final String compositeMapDescription() {
        return String.format(getLoggingLocale(), compositeMapDescription$str());
    }
    private static final String complexCompositeEntryTypeName = "Complex type";
    protected String complexCompositeEntryTypeName$str() {
        return complexCompositeEntryTypeName;
    }
    @Override
    public final String complexCompositeEntryTypeName() {
        return String.format(getLoggingLocale(), complexCompositeEntryTypeName$str());
    }
    private static final String complexCompositeEntryTypeDescription = "A complex type";
    protected String complexCompositeEntryTypeDescription$str() {
        return complexCompositeEntryTypeDescription;
    }
    @Override
    public final String complexCompositeEntryTypeDescription() {
        return String.format(getLoggingLocale(), complexCompositeEntryTypeDescription$str());
    }
    private static final String descriptorMBeanExpressionSupportFalse = "This mbean does not support expressions for attributes or operation parameters, even when supported by the underlying model. Instead the resolved attribute is returned, and the real typed value must be used when writing attributes/invoking operations.";
    protected String descriptorMBeanExpressionSupportFalse$str() {
        return descriptorMBeanExpressionSupportFalse;
    }
    @Override
    public final String descriptorMBeanExpressionSupportFalse() {
        return String.format(getLoggingLocale(), descriptorMBeanExpressionSupportFalse$str());
    }
    private static final String descriptorMBeanExpressionSupportTrue = "This mbean supports raw expressions for attributes and operation parameters where supported by the underlying model. If no expression is used, the string representation is converted into the real attribute value.";
    protected String descriptorMBeanExpressionSupportTrue$str() {
        return descriptorMBeanExpressionSupportTrue;
    }
    @Override
    public final String descriptorMBeanExpressionSupportTrue() {
        return String.format(getLoggingLocale(), descriptorMBeanExpressionSupportTrue$str());
    }
    private static final String descriptorAlternateMBeanExpressions = "To be able to set and read expressions go to %s";
    protected String descriptorAlternateMBeanExpressions$str() {
        return descriptorAlternateMBeanExpressions;
    }
    @Override
    public final String descriptorAlternateMBeanExpressions(final ObjectName objectName) {
        return String.format(getLoggingLocale(), descriptorAlternateMBeanExpressions$str(), objectName);
    }
    private static final String descriptorAlternateMBeanLegacy = "To read resolved values and to write typed attributes and use typed operation parameters go to %s";
    protected String descriptorAlternateMBeanLegacy$str() {
        return descriptorAlternateMBeanLegacy;
    }
    @Override
    public final String descriptorAlternateMBeanLegacy(final ObjectName objectName) {
        return String.format(getLoggingLocale(), descriptorAlternateMBeanLegacy$str(), objectName);
    }
    private static final String descriptorAttributeExpressionsAllowedTrue = "This attribute supports expressions";
    protected String descriptorAttributeExpressionsAllowedTrue$str() {
        return descriptorAttributeExpressionsAllowedTrue;
    }
    @Override
    public final String descriptorAttributeExpressionsAllowedTrue() {
        return String.format(getLoggingLocale(), descriptorAttributeExpressionsAllowedTrue$str());
    }
    private static final String descriptorAttributeExpressionsAllowedFalse = "This attribute does not support expressions";
    protected String descriptorAttributeExpressionsAllowedFalse$str() {
        return descriptorAttributeExpressionsAllowedFalse;
    }
    @Override
    public final String descriptorAttributeExpressionsAllowedFalse() {
        return String.format(getLoggingLocale(), descriptorAttributeExpressionsAllowedFalse$str());
    }
    private static final String propertyCompositeType = "A composite type representing a property";
    protected String propertyCompositeType$str() {
        return propertyCompositeType;
    }
    @Override
    public final String propertyCompositeType() {
        return String.format(getLoggingLocale(), propertyCompositeType$str());
    }
    private static final String propertyName = "The property name";
    protected String propertyName$str() {
        return propertyName;
    }
    @Override
    public final String propertyName() {
        return String.format(getLoggingLocale(), propertyName$str());
    }
    private static final String propertyValue = "The property value";
    protected String propertyValue$str() {
        return propertyValue;
    }
    @Override
    public final String propertyValue() {
        return String.format(getLoggingLocale(), propertyValue$str());
    }
    private static final String attributeNotFound = "WFLYJMX0007: Could not find any attribute matching: %s";
    protected String attributeNotFound$str() {
        return attributeNotFound;
    }
    @Override
    public final AttributeNotFoundException attributeNotFound(final String name) {
        final AttributeNotFoundException result = new AttributeNotFoundException(String.format(getLoggingLocale(), attributeNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeNotWritable = "WFLYJMX0008: Attribute %s is not writable";
    protected String attributeNotWritable$str() {
        return attributeNotWritable;
    }
    @Override
    public final AttributeNotFoundException attributeNotWritable(final Attribute attribute) {
        final AttributeNotFoundException result = new AttributeNotFoundException(String.format(getLoggingLocale(), attributeNotWritable$str(), attribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateObjectName = "WFLYJMX0009: Could not create ObjectName for address %s from string %s";
    protected String cannotCreateObjectName$str() {
        return cannotCreateObjectName;
    }
    @Override
    public final RuntimeException cannotCreateObjectName(final Throwable cause, final PathAddress address, final String s) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotCreateObjectName$str(), address, s), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetAttribute = "WFLYJMX0010: Could not set %s";
    protected String cannotSetAttribute$str() {
        return cannotSetAttribute;
    }
    @Override
    public final ReflectionException cannotSetAttribute(final Exception cause, final String name) {
        final ReflectionException result = new ReflectionException(cause, String.format(getLoggingLocale(), cannotSetAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String descriptionProviderNotFound = "WFLYJMX0011: No description provider found for %s";
    protected String descriptionProviderNotFound$str() {
        return descriptionProviderNotFound;
    }
    @Override
    public final InstanceNotFoundException descriptionProviderNotFound(final PathAddress address) {
        final InstanceNotFoundException result = new InstanceNotFoundException(String.format(getLoggingLocale(), descriptionProviderNotFound$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String differentLengths = "WFLYJMX0012: %s and %s have different lengths";
    protected String differentLengths$str() {
        return differentLengths;
    }
    @Override
    public final IllegalArgumentException differentLengths(final String name1, final String name2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), differentLengths$str(), name1, name2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAttributeType = "WFLYJMX0013: Bad type for '%s'";
    protected String invalidAttributeType$str() {
        return invalidAttributeType;
    }
    @Override
    public final InvalidAttributeValueException invalidAttributeType(final Throwable cause, final String name) {
        final InvalidAttributeValueException result = new InvalidAttributeValueException(String.format(getLoggingLocale(), invalidAttributeType$str(), name));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKey = "WFLYJMX0014: Invalid key %s for %s";
    protected String invalidKey$str() {
        return invalidKey;
    }
    @Override
    public final IllegalArgumentException invalidKey(final java.util.List<?> keys, final java.util.Map.Entry<?, Object> entry) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidKey$str(), keys, entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectName2 = "WFLYJMX0015: Invalid ObjectName: %s; %s";
    protected String invalidObjectName2$str() {
        return invalidObjectName2;
    }
    @Override
    public final Error invalidObjectName(final String name, final String message) {
        final Error result = new Error(String.format(getLoggingLocale(), invalidObjectName2$str(), name, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectName3 = "WFLYJMX0015: Invalid ObjectName: %s,%s; %s";
    protected String invalidObjectName3$str() {
        return invalidObjectName3;
    }
    @Override
    public final Error invalidObjectName(final String domain, final java.util.Hashtable<String, String> table, final String message) {
        final Error result = new Error(String.format(getLoggingLocale(), invalidObjectName3$str(), domain, table, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectName4 = "WFLYJMX0015: Invalid ObjectName: %s,%s,%s; %s";
    protected String invalidObjectName4$str() {
        return invalidObjectName4;
    }
    @Override
    public final Error invalidObjectName(final String domain, final String key, final String value, final String message) {
        final Error result = new Error(String.format(getLoggingLocale(), invalidObjectName4$str(), domain, key, value, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mbeanNotFound = "WFLYJMX0017: No MBean found with name %s";
    protected String mbeanNotFound$str() {
        return mbeanNotFound;
    }
    @Override
    public final InstanceNotFoundException mbeanNotFound(final ObjectName name) {
        final InstanceNotFoundException result = new InstanceNotFoundException(String.format(getLoggingLocale(), mbeanNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mbeanRegistrationFailed = "WFLYJMX0018: Failed to register mbean [%s]";
    protected String mbeanRegistrationFailed$str() {
        return mbeanRegistrationFailed;
    }
    @Override
    public final StartException mbeanRegistrationFailed(final Throwable cause, final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), mbeanRegistrationFailed$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noOperationCalled1 = "WFLYJMX0019: No operation called '%s'";
    protected String noOperationCalled1$str() {
        return noOperationCalled1;
    }
    @Override
    public final InstanceNotFoundException noOperationCalled(final String operation) {
        final InstanceNotFoundException result = new InstanceNotFoundException(String.format(getLoggingLocale(), noOperationCalled1$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noOperationCalled2 = "WFLYJMX0020: No operation called '%s' at %s";
    protected String noOperationCalled2$str() {
        return noOperationCalled2;
    }
    @Override
    public final MBeanException noOperationCalled(final Exception cause, final String operation, final PathAddress address) {
        final MBeanException result = new MBeanException(cause, String.format(getLoggingLocale(), noOperationCalled2$str(), operation, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String registrationNotFound = "WFLYJMX0022: No registration found for path address %s";
    protected String registrationNotFound$str() {
        return registrationNotFound;
    }
    @Override
    public final InstanceNotFoundException registrationNotFound(final PathAddress address) {
        final InstanceNotFoundException result = new InstanceNotFoundException(String.format(getLoggingLocale(), registrationNotFound$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownType = "WFLYJMX0024: Unknown type %s";
    protected String unknownType$str() {
        return unknownType;
    }
    @Override
    public final RuntimeException unknownType(final ModelType type) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownValue = "WFLYJMX0025: Unknown value %s";
    protected String unknownValue$str() {
        return unknownValue;
    }
    @Override
    public final IllegalArgumentException unknownValue(final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownValue$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardNameParameterRequired = "WFLYJMX0026: Need the name parameter for wildcard add";
    protected String wildcardNameParameterRequired$str() {
        return wildcardNameParameterRequired;
    }
    @Override
    public final IllegalStateException wildcardNameParameterRequired() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wildcardNameParameterRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownDomain = "WFLYJMX0029: Unknown domain: %s";
    protected String unknownDomain$str() {
        return unknownDomain;
    }
    @Override
    public final IllegalArgumentException unknownDomain(final String domain) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownDomain$str(), domain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionCannotBeConvertedIntoTargeteType = "WFLYJMX0030: Expression can not be converted into target type %s";
    protected String expressionCannotBeConvertedIntoTargeteType$str() {
        return expressionCannotBeConvertedIntoTargeteType;
    }
    @Override
    public final IllegalArgumentException expressionCannotBeConvertedIntoTargeteType(final javax.management.openmbean.OpenType<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expressionCannotBeConvertedIntoTargeteType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownChild = "WFLYJMX0031: Unknown child %s";
    protected String unknownChild$str() {
        return unknownChild;
    }
    @Override
    public final IllegalArgumentException unknownChild(final String child) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownChild$str(), child));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String objectNameCantBeNull = "WFLYJMX0032: ObjectName cannot be null";
    protected String objectNameCantBeNull$str() {
        return objectNameCantBeNull;
    }
    @Override
    public final IllegalArgumentException objectNameCantBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), objectNameCantBeNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noHandlerCalled = "WFLYJMX0036: There is no handler called '%s'";
    protected String noHandlerCalled$str() {
        return noHandlerCalled;
    }
    @Override
    public final IllegalStateException noHandlerCalled(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noHandlerCalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "WFLYJMX0037: Unauthorized access";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final JMRuntimeException unauthorized() {
        final JMRuntimeException result = new JMRuntimeException(String.format(getLoggingLocale(), unauthorized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAuthorizedToWriteAttribute = "WFLYJMX0038: Not authorized to write attribute: '%s'";
    protected String notAuthorizedToWriteAttribute$str() {
        return notAuthorizedToWriteAttribute;
    }
    @Override
    public final JMRuntimeException notAuthorizedToWriteAttribute(final String attributeName) {
        final JMRuntimeException result = new JMRuntimeException(String.format(getLoggingLocale(), notAuthorizedToWriteAttribute$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAuthorizedToReadAttribute = "WFLYJMX0039: Not authorized to read attribute: '%s'";
    protected String notAuthorizedToReadAttribute$str() {
        return notAuthorizedToReadAttribute;
    }
    @Override
    public final JMRuntimeException notAuthorizedToReadAttribute(final String attributeName) {
        final JMRuntimeException result = new JMRuntimeException(String.format(getLoggingLocale(), notAuthorizedToReadAttribute$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAuthorizedToExecuteOperation = "WFLYJMX0040: Not authorized to invoke operation: '%s'";
    protected String notAuthorizedToExecuteOperation$str() {
        return notAuthorizedToExecuteOperation;
    }
    @Override
    public final JMRuntimeException notAuthorizedToExecuteOperation(final String operationName) {
        final JMRuntimeException result = new JMRuntimeException(String.format(getLoggingLocale(), notAuthorizedToExecuteOperation$str(), operationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateMBeansInReservedDomain = "WFLYJMX0041: You can't create mbeans under the reserved domain '%s'";
    protected String cannotCreateMBeansInReservedDomain$str() {
        return cannotCreateMBeansInReservedDomain;
    }
    @Override
    public final NotCompliantMBeanException cannotCreateMBeansInReservedDomain(final String domain) {
        final NotCompliantMBeanException result = new NotCompliantMBeanException(String.format(getLoggingLocale(), cannotCreateMBeansInReservedDomain$str(), domain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dontKnowHowToDeserialize = "WFLYJMX0042: Don't know how to deserialize";
    protected String dontKnowHowToDeserialize$str() {
        return dontKnowHowToDeserialize;
    }
    @Override
    public final OperationsException dontKnowHowToDeserialize() {
        final OperationsException result = new OperationsException(String.format(getLoggingLocale(), dontKnowHowToDeserialize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedMethod = "WFLYJMX0043: %s is not supported";
    protected String unsupportedMethod$str() {
        return unsupportedMethod;
    }
    @Override
    public final UnsupportedOperationException unsupportedMethod(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedMethod$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRegisterMBeansUnderReservedDomain = "WFLYJMX0044: You can't register mbeans under the reserved domain '%s'";
    protected String cannotRegisterMBeansUnderReservedDomain$str() {
        return cannotRegisterMBeansUnderReservedDomain;
    }
    @Override
    public final String cannotRegisterMBeansUnderReservedDomain(final String domain) {
        return String.format(getLoggingLocale(), cannotRegisterMBeansUnderReservedDomain$str(), domain);
    }
    private static final String cannotUnregisterMBeansUnderReservedDomain = "WFLYJMX0045: You can't unregister mbeans under the reserved domain '%s'";
    protected String cannotUnregisterMBeansUnderReservedDomain$str() {
        return cannotUnregisterMBeansUnderReservedDomain;
    }
    @Override
    public final String cannotUnregisterMBeansUnderReservedDomain(final String domain) {
        return String.format(getLoggingLocale(), cannotUnregisterMBeansUnderReservedDomain$str(), domain);
    }
    private static final String badDomainInCalclulatedObjectNameException = "WFLYJMX0046: The ObjectName coming from MBeanRegistration.preRegister() '%s' is in a reserved JMX domain";
    protected String badDomainInCalclulatedObjectNameException$str() {
        return badDomainInCalclulatedObjectNameException;
    }
    @Override
    public final RuntimeOperationsException badDomainInCalclulatedObjectNameException(final ObjectName name) {
        final RuntimeOperationsException result = new RuntimeOperationsException(null, String.format(getLoggingLocale(), badDomainInCalclulatedObjectNameException$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorUnregisteringMBeanWithBadCalculatedName(final Exception e, final ObjectName name) {
        super.log.logf(FQCN, ERROR, e, errorUnregisteringMBeanWithBadCalculatedName$str(), name);
    }
    private static final String errorUnregisteringMBeanWithBadCalculatedName = "WFLYJMX0047: An error happened unregistering the '%s' MBean registered in a reserved JMX domain";
    protected String errorUnregisteringMBeanWithBadCalculatedName$str() {
        return errorUnregisteringMBeanWithBadCalculatedName;
    }
    private static final String addNotificationListerWithObjectNameNotSupported = "WFLYJMX0048: Add notification listener using ObjectName %s is not supported";
    protected String addNotificationListerWithObjectNameNotSupported$str() {
        return addNotificationListerWithObjectNameNotSupported;
    }
    @Override
    public final UnsupportedOperationException addNotificationListerWithObjectNameNotSupported(final ObjectName listener) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), addNotificationListerWithObjectNameNotSupported$str(), listener));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String removeNotificationListerWithObjectNameNotSupported = "WFLYJMX0049: Remove notification listener using ObjectName %s is not supported";
    protected String removeNotificationListerWithObjectNameNotSupported$str() {
        return removeNotificationListerWithObjectNameNotSupported;
    }
    @Override
    public final UnsupportedOperationException removeNotificationListerWithObjectNameNotSupported(final ObjectName listener) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), removeNotificationListerWithObjectNameNotSupported$str(), listener));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String addNotificationListenerNotAllowed = "WFLYJMX0050: Add notification listener using ObjectName %s is not supported";
    protected String addNotificationListenerNotAllowed$str() {
        return addNotificationListenerNotAllowed;
    }
    @Override
    public final UnsupportedOperationException addNotificationListenerNotAllowed(final ObjectName name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), addNotificationListenerNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String removeNotificationListenerNotAllowed = "WFLYJMX0051: Remove notification listener using ObjectName %s is not supported";
    protected String removeNotificationListenerNotAllowed$str() {
        return removeNotificationListenerNotAllowed;
    }
    @Override
    public final UnsupportedOperationException removeNotificationListenerNotAllowed(final ObjectName name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), removeNotificationListenerNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
