/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JmxAuditLogHandlerReferenceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JmxAuditLoggerResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"configuration", (String)"audit-log");
    public static final SimpleAttributeDefinition LOG_BOOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("log-boot", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition LOG_READ_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("log-read-only", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    static final List<SimpleAttributeDefinition> AUDIT_LOG_ATTRIBUTE_DEFINITIONS = Arrays.asList(LOG_BOOT, LOG_READ_ONLY, ENABLED);
    private final ManagedAuditLogger auditLogger;

    public JmxAuditLoggerResourceDefinition(ManagedAuditLogger auditLogger) {
        super(PATH_ELEMENT, JMXExtension.getResourceDescriptionResolver("audit-log"), (OperationStepHandler)new AuditLoggerAddHandler(auditLogger), (OperationStepHandler)new AuditLoggerRemoveHandler(auditLogger));
        this.auditLogger = auditLogger;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AuditLogWriteAttributeHandler wah = new AuditLogWriteAttributeHandler(this.auditLogger, new AttributeDefinition[]{LOG_BOOT, LOG_READ_ONLY, ENABLED});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_BOOT, null, (OperationStepHandler)wah);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LOG_READ_ONLY, null, (OperationStepHandler)wah);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENABLED, null, (OperationStepHandler)wah);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new JmxAuditLogHandlerReferenceResourceDefinition(this.auditLogger));
    }

    private static class AuditLogWriteAttributeHandler
    extends AbstractWriteAttributeHandler<Object> {
        private final ManagedAuditLogger auditLogger;

        AuditLogWriteAttributeHandler(ManagedAuditLogger auditLogger, AttributeDefinition ... attributeDefinitions) {
            super(attributeDefinitions);
            this.auditLogger = auditLogger;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Object> handbackHolder) throws OperationFailedException {
            if (attributeName.equals(LOG_BOOT.getName())) {
                handbackHolder.setHandback((Object)this.auditLogger.isLogBoot());
                this.auditLogger.setLogBoot(resolvedValue.asBoolean());
            } else if (attributeName.equals(ENABLED.getName())) {
                handbackHolder.setHandback((Object)this.auditLogger.getLoggerStatus());
                boolean enabled = resolvedValue.asBoolean();
                AuditLogger.Status status = enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLED;
                this.auditLogger.setLoggerStatus(status);
            } else if (attributeName.equals(LOG_READ_ONLY.getName())) {
                handbackHolder.setHandback((Object)this.auditLogger.isLogReadOnly());
                this.auditLogger.setLogReadOnly(resolvedValue.asBoolean());
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
            if (attributeName.equals(LOG_BOOT.getName())) {
                this.auditLogger.setLogBoot(((Boolean)handback).booleanValue());
            } else if (attributeName.equals(ENABLED.getName())) {
                this.auditLogger.setLoggerStatus((AuditLogger.Status)handback);
            } else if (attributeName.equals(LOG_READ_ONLY.getName())) {
                this.auditLogger.setLogReadOnly(((Boolean)handback).booleanValue());
            }
        }
    }

    private static class AuditLoggerRemoveHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLogger;

        AuditLoggerRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
            if (!"profile".equals(context.getCurrentAddress().getElement(0).getKey())) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final boolean wasReadOnly = auditLogger.isLogReadOnly();
                        final AuditLogger.Status oldStatus = auditLogger.getLoggerStatus();
                        auditLogger.setLoggerStatus(AuditLogger.Status.DISABLE_NEXT);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                auditLogger.setLogReadOnly(wasReadOnly);
                                auditLogger.setLoggerStatus(oldStatus);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    private static class AuditLoggerAddHandler
    implements OperationStepHandler {
        private final ManagedAuditLogger auditLoggerProvider;

        AuditLoggerAddHandler(ManagedAuditLogger auditLoggerProvider) {
            this.auditLoggerProvider = auditLoggerProvider;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            for (AttributeDefinition attributeDefinition : AUDIT_LOG_ATTRIBUTE_DEFINITIONS) {
                attributeDefinition.validateAndSet(operation, model);
            }
            if (!"profile".equals(context.getCurrentAddress().getElement(0).getKey())) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final boolean wasReadOnly = auditLoggerProvider.isLogReadOnly();
                        final boolean wasLogBoot = auditLoggerProvider.isLogBoot();
                        final AuditLogger.Status oldStatus = auditLoggerProvider.getLoggerStatus();
                        auditLoggerProvider.setLogReadOnly(LOG_READ_ONLY.resolveModelAttribute(context, model).asBoolean());
                        auditLoggerProvider.setLogBoot(LOG_BOOT.resolveModelAttribute(context, model).asBoolean());
                        boolean enabled = ENABLED.resolveModelAttribute(context, model).asBoolean();
                        auditLoggerProvider.setLoggerStatus(enabled ? AuditLogger.Status.LOGGING : AuditLogger.Status.DISABLED);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                auditLoggerProvider.setLogReadOnly(wasReadOnly);
                                auditLoggerProvider.setLoggerStatus(oldStatus);
                                auditLoggerProvider.setLogBoot(wasLogBoot);
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }
}

